-- Deploy gaia:pay_2016_04_14_create_table_pay_servicesnapshot to mysql

BEGIN;
CREATE TABLE `pay_servicesnapshot` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `order_id` varchar(12) NOT NULL UNIQUE,
    `service_id` integer NOT NULL,
    `name` varchar(100) NOT NULL,
    `short_description` varchar(100) NOT NULL,
    `detail_description` longtext NOT NULL,
    `exchange_points_ceiling` integer NOT NULL,
    `doctor_id` varchar(100),
    `hospital_id` varchar(100),
    `special_remind` longtext,
    `ceiling_price` integer NOT NULL,
    `payment_type` varchar(1) NOT NULL,
    `channel` varchar(1) NOT NULL,
    `service_flag` varchar(1) NOT NULL,
    `phone` varchar(20),
    `sms_phone` varchar(10),
    `pm_content` longtext,
    `address` varchar(100),
    `is_online` bool NOT NULL,
    `is_sale` bool NOT NULL,
    `is_voucher` bool NOT NULL,
    `ordering` integer NOT NULL,
    `sell_num_limit` integer NOT NULL,
    `total_num` integer NOT NULL,
    `start_time` datetime(6) NOT NULL,
    `end_time` datetime(6),
    `update_time` datetime(6) NOT NULL,
    `is_floor_price` bool NOT NULL,
    `only_use_points` bool NOT NULL,
    `single_user_buy_limit` integer NOT NULL,
    `need_address` bool NOT NULL,
    `need_sms_alert` bool NOT NULL,
    `bodypart_subitem_id` integer,
    `image_header` varchar(300) NOT NULL,
    `image_detail` varchar(300) NOT NULL,
    `is_multiattribute` bool NOT NULL,
    `share_get_cashback` bool NOT NULL,
    `refund_anytime` bool NOT NULL,
    `compensation_in_advance` bool NOT NULL,
    `cash_back_rate` integer NOT NULL,
    `fake_sold_num` integer NOT NULL,
    `notes` varchar(300),
    `show_location` bool NOT NULL,
    `tip` varchar(128) NOT NULL,
    `rating` double precision NOT NULL,
    `operation_effect_rating` double precision NOT NULL,
    `doctor_attitude_rating` double precision NOT NULL,
    `hospital_env_rating` double precision NOT NULL,
    `is_operation` bool NOT NULL,
    `is_vouchsafe` bool NOT NULL,
    `wiki_id` integer,
    `is_stage` bool NOT NULL,
    `reservation` integer NOT NULL,
    `valid_duration` integer,
    `points_deduction_percent` integer NOT NULL,
    `recommend_usecase` bool NOT NULL,
    `is_self_support` bool NOT NULL,
    `items` longtext NOT NULL,
    `item_key` varchar(40) NOT NULL,
    `self_support_discount` integer NOT NULL,
    `discount` integer NOT NULL,
    `pre_payment_price` integer NOT NULL,
    `total_price` integer NOT NULL,
    `original_price` integer NOT NULL,
    `gengmei_price` integer NOT NULL,
    `cash_back_fee` integer NOT NULL,
    `special_seckill_service_id` integer,
    `max_gengmei_price` integer NOT NULL
)
;
ALTER TABLE `pay_servicesnapshot` ADD CONSTRAINT `wiki_id_refs_id_5d4c73d2` FOREIGN KEY (`wiki_id`) REFERENCES `api_itemwiki` (`id`);
ALTER TABLE `pay_servicesnapshot` ADD CONSTRAINT `order_id_refs_id_540eed8a` FOREIGN KEY (`order_id`) REFERENCES `api_order` (`id`);
ALTER TABLE `pay_servicesnapshot` ADD CONSTRAINT `bodypart_subitem_id_refs_id_58bfcb9b` FOREIGN KEY (`bodypart_subitem_id`) REFERENCES `api_bodypartsubitem` (`id`);
ALTER TABLE `pay_servicesnapshot` ADD CONSTRAINT `service_id_refs_id_6e5cebad` FOREIGN KEY (`service_id`) REFERENCES `api_service` (`id`);
ALTER TABLE `pay_servicesnapshot` ADD CONSTRAINT `doctor_id_refs_id_27eef1c9` FOREIGN KEY (`doctor_id`) REFERENCES `api_doctor` (`id`);
ALTER TABLE `pay_servicesnapshot` ADD CONSTRAINT `hospital_id_refs_id_54887c6c` FOREIGN KEY (`hospital_id`) REFERENCES `api_hospital` (`id`);
ALTER TABLE `pay_servicesnapshot` ADD CONSTRAINT `special_seckill_service_id_refs_id_ed561f58` FOREIGN KEY (`special_seckill_service_id`) REFERENCES `api_specialseckillservice` (`id`);
COMMIT;
