# coding=utf8

from __future__ import unicode_literals, absolute_import, print_function

from django.db import models

from .topicreply import TopicReply


class ReplyHeadline(models.Model):
    class Meta:
        verbose_name = u'社区问答推荐'
        verbose_name_plural = u'社区问答推荐'
        db_table = 'api_replyheadline'
        app_label = 'talos'

    reply = models.ForeignKey(TopicReply, verbose_name=u"回复")
    is_online = models.BooleanField(verbose_name=u"是否上线", default=True)
    create_time = models.DateTimeField(verbose_name=u'创建时间', auto_now_add=True)

    @classmethod
    def is_recommend(cls, reply_id):
        try:
            ReplyHeadline.objects.get(reply_id=reply_id)
        except:
            return False
        return True

    @classmethod
    def get_recommend_reply_ids(cls, reply_ids):
        ids = list(cls.objects.filter(reply_id__in=reply_ids).values_list('reply_id', flat=True))
        return ids
