# coding: utf-8
from gm_types.gaia import TAG_V3_TYPE
from datetime import datetime
from django.db.models import Q
from group.models import Topic, TopicContent, TopicFollow, TopicTagV3
from agile.services.tag import get_tag_v3_attr_by_tag_v3_ids_by_url, get_ids_by_names

from .es import tzlc

_base_query = Q(is_online=True)


def get_topic_followers(topic_id):
    query = _base_query & Q(topic_id=topic_id)
    return list(TopicFollow.objects.filter(query).values_list("user_id", flat=True))


def get_topic_last_create_time(topic_id):
    query = _base_query & Q(topic_id=topic_id)
    obj = TopicContent.objects.filter(query).order_by("-create_time").first()
    if obj:
        return tzlc(obj.update_time)
    return tzlc(datetime(1970, 1, 1))


def get_topic_last_comment_time(topic_id):
    query = _base_query & Q(topic_id=topic_id)
    obj = TopicContent.objects.filter(query).order_by("-update_time").first()
    if obj:
        return tzlc(obj.update_time)
    return tzlc(datetime(1970, 1, 1))


def get_topic(instance):
    t = instance
    assert isinstance(t, Topic)

    topic_id = t.id

    is_show_index = True
    try:
        is_show_index = t.is_show_index
    except Exception as e:
        print(e)
        pass

    user_ids = get_topic_followers(topic_id)

    res = {
        "id": topic_id,
        "name": t.name,
        "mapping_type": "topic",
        "is_online": t.is_online,
        "create_time": tzlc(t.create_time),
        "update_time": tzlc(t.update_time),
        "last_content_create_time": get_topic_last_create_time(topic_id),
        "last_content_comment_time": get_topic_last_comment_time(topic_id),
        "tag_ids": [],
        "tag_names": [],
        "user_ids": user_ids,
        "user_follow_number": len(user_ids),
        "is_show_index": is_show_index
    }
    tag_v3_ids = list(TopicTagV3.objects.filter(topic_id=topic_id, is_online=True).values_list("tag_v3_id", flat=True))
    tags_v3_name = []
    tags_v3_ids = []

    tagv3_ids = get_ids_by_names(tags_ids=tag_v3_ids, tags_type=TAG_V3_TYPE.NORMAL, get_ids=True)
    tagv3_names = get_ids_by_names(tags_ids=tag_v3_ids, tags_type=TAG_V3_TYPE.NORMAL)
    tags_v3_ids.extend(tagv3_ids)
    tags_v3_name.extend(tagv3_names)

    second_classify_ids = get_tag_v3_attr_by_tag_v3_ids_by_url(tags_ids=tag_v3_ids, get_name=False,
                                                               agg_type=TAG_V3_TYPE.SECOND_CLASSIFY,
                                                               tag_type=TAG_V3_TYPE.FIRST_CLASSIFY)
    tag_v3_ids.extend(second_classify_ids)
    second_by_get_protag_names = get_tag_v3_attr_by_tag_v3_ids_by_url(tags_ids=tag_v3_ids, get_name=True,
                                                                      agg_type=TAG_V3_TYPE.NORMAL,
                                                                      tag_type=TAG_V3_TYPE.SECOND_CLASSIFY)
    tags_v3_name.extend(second_by_get_protag_names)
    second_by_get_protag_ids = get_tag_v3_attr_by_tag_v3_ids_by_url(tags_ids=tag_v3_ids, get_name=False,
                                                                    agg_type=TAG_V3_TYPE.NORMAL,
                                                                    tag_type=TAG_V3_TYPE.SECOND_CLASSIFY)
    tags_v3_ids.extend(second_by_get_protag_ids)

    res["tags_v3_name"] = list(set(tags_v3_name))
    res["tags_v3_ids"] = list(set(tags_v3_ids))

    return res
