#!/usr/bin/env python
# coding: utf-8

from django.conf import settings
from django.core.management.base import BaseCommand, CommandError

import random
from utils.id_blur.blur import blur


def random_scale():
    n = random.normalvariate(1, 0.3)
    if n < 0:
        n = 0
    if n > 2:
        n = 2
    return n


def default_action():
    actions = [
        ('auth_user', 100),
        ('api_userextra', 100),
        ('api_service', 100),
        ('api_problem', 100),
        ('api_topicreply', 100),
        ('api_diary', 100),
        ('api_devicerecord', 100),
    ]
    for db_table, increment in actions:
        increment *= random_scale()
        blur(db_table, int(increment))


class Command(BaseCommand):

    args = ''
    help = 'increase auto_increment value'

    from optparse import make_option

    option_list = BaseCommand.option_list + (
        make_option('-t', '--table', dest='table', type=str, help='table name', metavar='TABLE'),
        make_option('-i', '--increment', dest='increment', type=long, help='value to increase', metavar='INCREMENT'),
        make_option('-r', '--random', dest='random', action="store_true", default=False, help='random', metavar='RANDOM'),
        make_option('-d', '--default', dest='default', action="store_true", default=False, help='random', metavar='DEFAULT'),
    )

    def handle(self, *args, **options):
        table = options['table']
        increment = options['increment']
        use_random = options['random']
        default = options['default']

        if default:
            default_action()
            return

        if use_random:
            increment *= random_scale()

        blur(table, int(increment))


