# coding: utf-8
import time
import datetime


def datetime2timestamp(dt):
    return int(time.mktime(dt.timetuple()))


def strtime2datetime(stringDate):
    return datetime.datetime.fromtimestamp(time.mktime(time.strptime(stringDate, "%Y-%m-%d %H:%M:%S")))


def get_today_rest_seconds():
    """
    离24点还有多少秒
    :return:
    """
    now = datetime.datetime.now()
    today_begin = datetime.datetime(now.year, now.month, now.day, 0, 0, 0)
    tomorrow_begin = today_begin + datetime.timedelta(days=1)
    rest_seconds = (tomorrow_begin - now).seconds
    return rest_seconds


def get_today_range():
    now = datetime.datetime.now()

    today_begin = now - datetime.timedelta(
        hours=now.hour, minutes=now.minute, seconds=now.second,microseconds=now.microsecond
    )

    today_end = today_begin + datetime.timedelta(hours=23, minutes=59, seconds=59)

    return today_begin, today_end

