# coding: utf8
import json

import requests
from gm_types.error import ERROR

from rpc.tool.error_code import gen
from rpc.tool.log_tool import user_logger

# 小程序模板消息推送api
TEMPLATE_PUSH_API = 'https://api.weixin.qq.com/cgi-bin/message/wxopen/template/send?access_token={token}'

# 小程序订阅消息推送
SUBSCRIBE_MSG_PUSH_API = "https://api.weixin.qq.com/cgi-bin/message/subscribe/send?access_token={token}"


def applet_template_push(access_token, open_id, template_id, form_id, data=None, page=None):
    """
    小程序模板消息推送
    :param access_token:    str 接口调用凭据
    :param open_id:         str 接收者（用户）的 openid
    :param form_id:         str
    :param template_id:     str 模板消息的id
    :param data:            dict    模板内容，不填则下发空模板
    :param page:            str 点击模板卡片后的跳转页面，仅限本小程序内的页面。支持带参数,该字段不填则模板无跳转。
    :return:
    """
    if not all([access_token, open_id, template_id, form_id]):
        return gen(ERROR.PARAMS_INCOMPLETE)

    push_data = {
        "touser": open_id,
        "template_id": template_id,
        "page": page,
        "form_id": form_id
    }
    push_data.update({'data': data})
    result = requests.post(
                url=TEMPLATE_PUSH_API.format(token=access_token),
                data=json.dumps(push_data)
    )

    resp = json.loads(result.content.decode('utf-8'))
    user_logger.info("wechat push :{}".format(resp))
    return {
        'errcode': resp.get('errcode'),
        'errmsg': resp.get('errmsg'),
    }


def applet_subscribe_msg_push(access_token, open_id, template_id, data=None, page=None):
    """小程序订阅消息推送。

    :param access_token:    str 接口调用凭据
    :param open_id:         str 接收者（用户）的 openid
    :param template_id:     str 模板消息的id
    :param data:            dict    模板内容，不填则下发空模板
    :param page:            str 点击模板卡片后的跳转页面，仅限本小程序内的页面。支持带参数,该字段不填则模板无跳转。
    :return:
    """

    if not all([access_token, open_id, template_id]):
        return gen(ERROR.PARAMS_INCOMPLETE)

    push_data = {
        "touser": open_id,
        "template_id": template_id,
        "page": page,
        "data": data,
    }
    result = requests.post(
        url=SUBSCRIBE_MSG_PUSH_API.format(token=access_token),
        data=json.dumps(push_data)
    )

    resp = json.loads(result.content.decode('utf-8'))

    return {
        'errcode': resp.get('errcode'),
        'errmsg': resp.get('errmsg'),
    }
