#!/usr/bin/env python
# -*- coding: utf-8 -*-

from django.db.models import Q


class ServiceBase(object):

    base_query = Q(is_online=True)

    @staticmethod
    def get_querysets_data(model_, query, order_by=[], fields=[]):
        query_sets = model_.objects.filter(query).order_by(*order_by)

        if fields:
            query_sets = query_sets.values(*fields)

        return query_sets
