# coding=utf-8
import logging
import traceback
from agile.models.tag import AttrTag, TagMapOldTag, TagV3, TagV3MapAttrTag, StrategyContentTagV3, StrategyServiceTagV3, \
    ServiceNewTag
from django.db.models import Q
from gm_types.gaia import TAG_TYPE_ATTR, TAG_V3_TYPE
from talos.models.diary import DiaryTagV3

_base_query = Q(is_online=True)


class TagMapOldTagService(object):
    model = TagMapOldTag

    @classmethod
    def get_tag_v3_ids_by_old_tag_ids(cls, ids):
        """
        1 to many
        :ids: [ids]
        :return: [new_ids]
        """
        query = _base_query & Q(old_tag_id__in=ids)
        ids = cls.model.objects.filter(query).values_list("tag_id", flat=True)
        return ids


def get_all_tag_v3_id_names():
    """
    :return: [names]
    """
    return list(TagV3.objects.filter(_base_query).values("id", "name").all())


def get_tag_v3_names_by_tag_v3_ids(ids):
    """
    :ids: [ids]
    :return: [names]
    """
    query = _base_query & Q(id__in=ids)
    return list(TagV3.objects.filter(query).values_list("name", flat=True))


def get_tag_v3_attr_by_tag_v3_ids(ids, agg_type, need_id=False):
    """
    :ids: [ids]
    :agg_type: TAG_TYPE_ATTR
    :return: [sympton_names]
    """
    query = _base_query & Q(tag_id__in=ids)
    attr_ids = TagV3MapAttrTag.objects.filter(query).values_list("tag_attr_id", flat=True)
    if not attr_ids:
        return []
    if need_id:
        return list(set(list(attr_ids)))

    query2 = _base_query & Q(id__in=attr_ids) & Q(aggregate_type=agg_type)
    return list(AttrTag.objects.filter(query2).values_list("name", flat=True))


def get_tag_v3_attr_by_tag_v3_ids_by_url(tags_ids=[], agg_type=None, tags_names=[], get_name=True,
                                         tag_type=TAG_V3_TYPE.NORMAL):
    try:
        """
        根据项目标签拿到属性标签
        :param agge_type: 
        :return: 
        """
        all_tag_names = []
        all_tag_ids = []

        all_tag_dict = gets_nomal_dict(tags_ids=tags_ids, tag_type=tag_type, tags_name=tags_names)
        if all_tag_dict:
            if agg_type == TAG_V3_TYPE.FIRST_APPEAL:
                all_tag_ids = all_tag_dict.get("first_demands_ids", [])
                all_tag_names = all_tag_dict.get("first_demands", [])
            elif agg_type == TAG_V3_TYPE.SECOND_APPEAL:
                all_tag_ids = all_tag_dict.get("second_demands_ids", [])
                all_tag_names = all_tag_dict.get("second_demands", [])

            elif agg_type == TAG_V3_TYPE.FIRST_POSITION:
                all_tag_ids = all_tag_dict.get("first_positions_ids", [])
                all_tag_names = all_tag_dict.get("first_positions", [])
            elif agg_type == TAG_V3_TYPE.SECOND_POSITION:
                all_tag_ids = all_tag_dict.get("second_positions_ids", [])
                all_tag_names = all_tag_dict.get("second_positions", [])

            elif agg_type == TAG_V3_TYPE.MACROSCOPIC_MODE:
                all_tag_ids = all_tag_dict.get("first_solutions_ids", [])
                all_tag_names = all_tag_dict.get("first_solutions", [])
            elif agg_type == TAG_V3_TYPE.FIRST_BRAND:
                all_tag_ids = all_tag_dict.get("second_solutions_ids", [])
                all_tag_names = all_tag_dict.get("second_solutions", [])

            elif agg_type == TAG_V3_TYPE.NORMAL:
                all_tag_ids = all_tag_dict.get("project_tags_ids", [])
                all_tag_names = all_tag_dict.get("project_tags", [])
            elif agg_type == TAG_V3_TYPE.FIRST_CLASSIFY:
                all_tag_ids = all_tag_dict.get("first_classify_ids", [])
                all_tag_names = all_tag_dict.get("first_classify_names", [])
            elif agg_type == TAG_V3_TYPE.SECOND_CLASSIFY:
                all_tag_ids = all_tag_dict.get("second_classify_ids", [])
                all_tag_names = all_tag_dict.get("second_classify_names", [])

        if get_name:
            return all_tag_names
        else:
            return all_tag_ids
    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return []


def get_tag_v3_first_demands_by_tag_v3_ids(ids):
    """1级诉求"""
    all_tag_names = get_tag_v3_attr_by_tag_v3_ids_by_url(tags_ids=ids, agg_type=TAG_V3_TYPE.FIRST_APPEAL)
    return all_tag_names
    # return get_tag_v3_attr_by_tag_v3_ids(ids, TAG_TYPE_ATTR.FIRST_APPEAL)


def get_tag_v3_second_demands_by_tag_v3_ids(ids, need_id=False):
    """2级诉求"""
    all_tag_names = get_tag_v3_attr_by_tag_v3_ids_by_url(tags_ids=ids, agg_type=TAG_V3_TYPE.SECOND_APPEAL)
    return all_tag_names
    # return get_tag_v3_attr_by_tag_v3_ids(ids, TAG_TYPE_ATTR.SECOND_APPEAL)


def get_tag_v3_positions_by_tag_v3_ids(ids, need_id=False):
    """2级部位"""
    all_tag_names = get_tag_v3_attr_by_tag_v3_ids_by_url(tags_ids=ids, agg_type=TAG_V3_TYPE.SECOND_POSITION)
    return all_tag_names
    # return get_tag_v3_attr_by_tag_v3_ids(ids, TAG_TYPE_ATTR.POSITION)


def get_tag_v3_first_positions_by_tag_v3_ids(ids, need_id=False):
    """1级部位"""
    all_tag_names = get_tag_v3_attr_by_tag_v3_ids_by_url(tags_ids=ids, agg_type=TAG_V3_TYPE.FIRST_POSITION)
    return all_tag_names
    # return get_tag_v3_attr_by_tag_v3_ids(ids, TAG_TYPE_ATTR.FIRST_POSITION)


def get_tag_v3_first_solutions_by_tag_v3_ids(ids, need_id=False):
    """1级方式"""
    all_tag_names = get_tag_v3_attr_by_tag_v3_ids_by_url(tags_ids=ids, agg_type=TAG_V3_TYPE.MACROSCOPIC_MODE)
    return all_tag_names
    # return get_tag_v3_attr_by_tag_v3_ids(ids, TAG_TYPE_ATTR.MACROSCOPIC_MODE)


def get_tag_v3_second_solutions_by_tag_v3_ids(ids, need_id=False):
    """2级方式"""
    all_tag_names = get_tag_v3_attr_by_tag_v3_ids_by_url(tags_ids=ids, agg_type=TAG_V3_TYPE.FIRST_BRAND)
    return all_tag_names
    # return get_tag_v3_attr_by_tag_v3_ids(ids, TAG_TYPE_ATTR.MODE)


def get_all_tag_v3_names_by_type(agg_type):
    query = _base_query & Q(aggregate_type=agg_type)
    return list(AttrTag.objects.filter(query).values_list("name", flat=True))


def get_all_tag_v3_first_demands():
    """
    所有1级诉求
    :return: [names]
    """
    return get_all_tag_v3_names_by_type(TAG_TYPE_ATTR.FIRST_APPEAL)


def get_all_tag_v3_second_demands():
    """
    所有2级诉求
    :return: [names]
    """
    return get_all_tag_v3_names_by_type(TAG_TYPE_ATTR.SECOND_APPEAL)


def get_all_tag_v3_first_solutions():
    """
    所有1级方式
    :return: [names]
    """
    return get_all_tag_v3_names_by_type(TAG_TYPE_ATTR.MACROSCOPIC_MODE)


def get_all_tag_v3_second_solutions():
    """
    所有2级方式
    :return: [names]
    """
    return get_all_tag_v3_names_by_type(TAG_TYPE_ATTR.MODE)


def get_all_tag_v3_positions():
    """
    所有部位
    :return: [names]
    """
    return get_all_tag_v3_names_by_type(TAG_TYPE_ATTR.POSITION)


def get_ids_by_names(tags_names=[], tags_type=[], tags_ids=[], get_ids=False):
    try:
        """
        根据标签的名称获取ID
        :param name_list: 
        :return: 
        """
        from agile.views.tag_v3 import TagV3Service
        service = TagV3Service()
        all_tags = []
        all_tag_info = service.gets_info(tag_names=tags_names, tag_type=tags_type, tag_ids=tags_ids)
        if all_tag_info:
            if get_ids:
                for item in all_tag_info:
                    all_tags.append(item.get("id", None))
            elif len(tags_names) > 0:
                for item in all_tag_info:
                    all_tags.append(item.get("id", None))
            elif len(tags_ids) > 0:
                for item in all_tag_info:
                    all_tags.append(item.get("name", None))
            else:
                for item in all_tag_info:
                    all_tags.append(item.get("name", None))

        return all_tags
    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return []


def get_tagv3_ids_by_tagv3_names(names_list):
    all_tags = get_ids_by_names(tags_names=names_list, tags_type=TAG_V3_TYPE.NORMAL)
    return all_tags
    # return list(TagV3.objects.filter(name__in=names_list, is_online=True).values_list("id", flat=True))


def get_first_demand_ids_by_name(names_list):
    all_tags = get_ids_by_names(tags_names=names_list, tags_type=TAG_V3_TYPE.FIRST_APPEAL)
    return all_tags
    # return list(AttrTag.objects.filter(name__in=names_list, is_online=True).values_list("id", flat=True))


def get_second_demand_ids_by_name(names_list):
    all_tags = get_ids_by_names(tags_names=names_list, tags_type=TAG_V3_TYPE.SECOND_APPEAL)
    return all_tags
    # return list(AttrTag.objects.filter(name__in=names_list, is_online=True).values_list("id", flat=True))


def get_first_solution_ids_by_name(names_list):
    all_tags = get_ids_by_names(tags_names=names_list, tags_type=TAG_V3_TYPE.MACROSCOPIC_MODE)
    return all_tags
    # return list(AttrTag.objects.filter(name__in=names_list, is_online=True).values_list("id", flat=True))


def get_second_solution_ids_by_name(names_list):
    all_tags = get_ids_by_names(tags_names=names_list, tags_type=TAG_V3_TYPE.FIRST_BRAND)
    return all_tags
    # return list(AttrTag.objects.filter(name__in=names_list, is_online=True).values_list("id", flat=True))


def get_first_position_ids_by_name(names_list):
    all_tags = get_ids_by_names(tags_names=names_list, tags_type=TAG_V3_TYPE.FIRST_POSITION)
    return all_tags
    # return list(AttrTag.objects.filter(name__in=names_list, is_online=True).values_list("id", flat=True))


def get_second_position_ids_by_name(names_list):
    all_tags = get_ids_by_names(tags_names=names_list, tags_type=TAG_V3_TYPE.SECOND_POSITION)
    return all_tags
    # return list(AttrTag.objects.filter(name__in=names_list, is_online=True).values_list("id", flat=True))


def get_tagv3_analysis_info(content_id, content_type="diary"):
    project_tags_list = list()
    tagv3_ids = list()
    second_demands_list = list()
    second_solutions_list = list()
    second_positions_list = list()
    first_positions_list = list()
    first_solutions_list = list()
    first_demands_list = list()
    first_classify_ids_list = list()
    second_classify_ids_list = list()
    first_classify_names_list = list()
    second_classify_names_list = list()

    result = None
    if content_type in ["diary"]:
        result = StrategyContentTagV3.objects.using("doris").filter(content_id=content_id,
                                                                    content_type=content_type).first()
        tagv3_ids = list(DiaryTagV3.objects.filter(diary_id=content_id).values_list("tag_v3_id", flat=True))
    elif content_type == "service":
        result = StrategyServiceTagV3.objects.using("doris").filter(service_id=content_id).first()
        tagv3_ids = list(ServiceNewTag.objects.filter(service_id=content_id).values_list("tag_id", flat=True))

    need_refresh_data = False

    if not result and not tagv3_ids:
        if project_tags_list:
            return (True, set(), set(), set(), set(), set(), set(), set(project_tags_list), set(), set(), set(), set())
        else:
            return (need_refresh_data, set(), set(), set(), set(), set(), set(), set(), set(), set(), set(), set())
    else:
        need_refresh_data = True
        if result:
            if len(result.second_demands) > 0:
                second_demands_list = result.second_demands.split(",")

            if len(result.second_solutions) > 0:
                second_solutions_list = result.second_solutions.split(",")

            if len(result.second_positions) > 0:
                second_positions_list = result.second_positions.split(",")

            if len(result.first_demands) > 0:
                first_demands_list = result.first_demands.split(",")

            if len(result.first_solutions) > 0:
                first_solutions_list = result.first_solutions.split(",")

            if len(result.first_positions) > 0:
                first_positions_list = result.first_positions.split(",")

            if len(result.project_tags) > 0:
                project_tags_list.extend(result.project_tags.split(","))

            if len(result.first_classify_ids) > 0:
                first_classify_ids_list = result.first_classify_ids.split(",")

            if len(result.second_classify_ids) > 0:
                second_classify_ids_list = result.second_classify_ids.split(",")

            if len(result.first_classify_names) > 0:
                first_classify_names_list = result.first_classify_names.split(",")

            if len(result.second_classify_names) > 0:
                second_classify_names_list = result.second_classify_names.split(",")

        if len(tagv3_ids) > 0:
            tagv3_name = list(
                TagV3.objects.filter(id__in=tagv3_ids, tag_type=TAG_V3_TYPE.NORMAL).values_list("name", flat=True))
            if len(tagv3_name) > 0:
                project_tags_list.extend(tagv3_name)

            tagv3_name = get_ids_by_names(tags_ids=tagv3_ids, tags_type=TAG_V3_TYPE.SECOND_APPEAL)
            if len(tagv3_name) > 0:
                second_demands_list.extend(tagv3_name)
            tagv3_name = get_ids_by_names(tags_ids=tagv3_ids, tags_type=TAG_V3_TYPE.FIRST_APPEAL)
            if len(tagv3_name) > 0:
                first_demands_list.extend(tagv3_name)

            tagv3_name = get_ids_by_names(tags_ids=tagv3_ids, tags_type=TAG_V3_TYPE.FIRST_POSITION)
            if len(tagv3_name) > 0:
                first_positions_list.extend(tagv3_name)
            tagv3_name = get_ids_by_names(tags_ids=tagv3_ids, tags_type=TAG_V3_TYPE.SECOND_POSITION)
            if len(tagv3_name) > 0:
                second_positions_list.extend(tagv3_name)

            tagv3_name = get_ids_by_names(tags_ids=tagv3_ids, tags_type=TAG_V3_TYPE.FIRST_CLASSIFY)
            if len(tagv3_name) > 0:
                first_classify_names_list.extend(tagv3_name)
            tagv3_name = get_ids_by_names(tags_ids=tagv3_ids, tags_type=TAG_V3_TYPE.SECOND_CLASSIFY)
            if len(tagv3_name) > 0:
                second_classify_names_list.extend(tagv3_name)

            tagv3_name = get_ids_by_names(tags_ids=tagv3_ids, tags_type=TAG_V3_TYPE.MACROSCOPIC_MODE)
            if len(tagv3_name) > 0:
                first_solutions_list.extend(tagv3_name)
            tagv3_name = get_ids_by_names(tags_ids=tagv3_ids, tags_type=TAG_V3_TYPE.FIRST_BRAND)
            if len(tagv3_name) > 0:
                second_solutions_list.extend(tagv3_name)

    return (need_refresh_data, set(second_demands_list), set(second_solutions_list),
            set(second_positions_list), set(first_demands_list), set(first_solutions_list),
            set(first_positions_list), set(project_tags_list), set(first_classify_ids_list),
            set(second_classify_ids_list),
            set(first_classify_names_list), set(second_classify_names_list))


def get_tagv3_diary_analysis_info(content_id, content_type="diary"):
    try:
        project_tags_list = list()
        project_tags_ids_list = list()
        tagv3_ids_list = list()

        second_demands_list = list()
        second_solutions_list = list()
        second_positions_list = list()
        second_demands_ids_list = list()
        second_solutions_ids_list = list()
        second_positions_ids_list = list()

        first_demands_list = list()
        first_solutions_list = list()
        first_positions_list = list()
        first_demands_ids_list = list()
        first_solutions_ids_list = list()
        first_positions_ids_list = list()

        first_classify_names_list = list()
        first_classify_ids_list = list()
        second_classify_names_list = list()
        second_classify_ids_list = list()

        result = None
        if content_type in ["diary"]:
            result = StrategyContentTagV3.objects.using("doris").filter(content_id=content_id,
                                                                        content_type=content_type).first()
            tagv3_ids_list = list(DiaryTagV3.objects.filter(diary_id=content_id).values_list("tag_v3_id", flat=True))

        need_refresh_data = False
        if not result and not tagv3_ids_list:
            if project_tags_list:
                return (
                    True, set(), set(), set(), set(), set(), set(), set(), set(), set(), set(), set(), set(), set(),
                    set(), set(), set(), set(), set())
            else:
                return (
                    need_refresh_data, set(), set(), set(), set(), set(), set(), set(), set(), set(), set(), set(),
                    set(), set(), set(), set(), set(), set(), set())
        else:
            need_refresh_data = True
            if result:
                if len(result.second_demands) > 0:
                    second_demands_list = result.second_demands.split(",")
                if len(result.second_solutions) > 0:
                    second_solutions_list = result.second_solutions.split(",")
                if len(result.second_positions) > 0:
                    second_positions_list = result.second_positions.split(",")

                if len(result.first_demands) > 0:
                    first_demands_list = result.first_demands.split(",")
                if len(result.first_solutions) > 0:
                    first_solutions_list = result.first_solutions.split(",")
                if len(result.first_positions) > 0:
                    first_positions_list = result.first_positions.split(",")

                if len(result.project_tags) > 0:
                    project_tags_list.extend(result.project_tags.split(","))
                if len(result.project_tags_ids) > 0:
                    project_tags_ids_list.extend([int(item) for item in result.project_tags_ids.split(",")])

                if len(result.first_classify_ids) > 0:
                    first_classify_ids_list.extend([int(item) for item in result.first_classify_ids.split(",")])

                if len(result.second_classify_ids) > 0:
                    second_classify_ids_list.extend([int(item) for item in result.second_classify_ids.split(",")])

                if len(result.first_classify_names) > 0:
                    first_classify_names_list = result.first_classify_names.split(",")
                if len(result.second_classify_names) > 0:
                    second_classify_names_list = result.second_classify_names.split(",")
            if len(tagv3_ids_list) > 0:
                all_tagv3_data = TagV3.objects.filter(id__in=tagv3_ids_list)
                for item in all_tagv3_data:
                    if item.tag_type == TAG_V3_TYPE.NORMAL:
                        project_tags_list.append(item.name)
                        project_tags_ids_list.append(item.id)

                    if item.tag_type == TAG_V3_TYPE.FIRST_APPEAL:
                        first_demands_list.append(item.name)
                        first_demands_ids_list.append(item.id)
                    if item.tag_type == TAG_V3_TYPE.SECOND_APPEAL:
                        second_demands_list.append(item.name)
                        second_demands_ids_list.append(item.id)

                    if item.tag_type == TAG_V3_TYPE.FIRST_POSITION:
                        first_positions_list.append(item.name)
                        first_positions_ids_list.append(item.id)
                    if item.tag_type == TAG_V3_TYPE.SECOND_POSITION:
                        second_positions_list.append(item.name)
                        second_positions_ids_list.append(item.id)

                    if item.tag_type == TAG_V3_TYPE.FIRST_CLASSIFY:
                        first_classify_names_list.append(item.name)
                        first_classify_ids_list.append(item.id)
                    if item.tag_type == TAG_V3_TYPE.SECOND_CLASSIFY:
                        second_classify_names_list.append(item.name)
                        second_classify_ids_list.append(item.id)

                    if item.tag_type == TAG_V3_TYPE.MACROSCOPIC_MODE:
                        first_solutions_list.append(item.name)
                        first_solutions_ids_list.append(item.id)
                    if item.tag_type == TAG_V3_TYPE.FIRST_BRAND:
                        second_solutions_list.append(item.name)
                        second_solutions_ids_list.append(item.id)

                # project_tags_list.extend(get_ids_by_names(tags_ids=tagv3_ids_list, tags_type=TAG_V3_TYPE.NORMAL))
                # project_tags_ids_list.extend(
                #     get_ids_by_names(tags_ids=tagv3_ids_list, tags_type=TAG_V3_TYPE.NORMAL, get_ids=True))
                #
                # second_demands_list.extend(
                #     get_ids_by_names(tags_ids=tagv3_ids_list, tags_type=TAG_V3_TYPE.SECOND_APPEAL))
                # second_demands_ids_list.extend(
                #     get_ids_by_names(tags_ids=tagv3_ids_list, tags_type=TAG_V3_TYPE.SECOND_APPEAL, get_ids=True))
                #
                # first_demands_list.extend(get_ids_by_names(tags_ids=tagv3_ids_list, tags_type=TAG_V3_TYPE.FIRST_APPEAL))
                # first_demands_ids_list.extend(
                #     get_ids_by_names(tags_ids=tagv3_ids_list, tags_type=TAG_V3_TYPE.FIRST_APPEAL, get_ids=True))
                #
                # first_positions_list.extend(
                #     get_ids_by_names(tags_ids=tagv3_ids_list, tags_type=TAG_V3_TYPE.FIRST_POSITION))
                # first_positions_ids_list.extend(
                #     get_ids_by_names(tags_ids=tagv3_ids_list, tags_type=TAG_V3_TYPE.FIRST_POSITION, get_ids=True))
                #
                # second_positions_list.extend(
                #     get_ids_by_names(tags_ids=tagv3_ids_list, tags_type=TAG_V3_TYPE.SECOND_POSITION))
                # second_positions_ids_list.extend(
                #     get_ids_by_names(tags_ids=tagv3_ids_list, tags_type=TAG_V3_TYPE.SECOND_POSITION, get_ids=True))
                #
                # first_classify_names_list.extend(
                #     get_ids_by_names(tags_ids=tagv3_ids_list, tags_type=TAG_V3_TYPE.FIRST_CLASSIFY))
                # first_classify_ids_list.extend(
                #     get_ids_by_names(tags_ids=tagv3_ids_list, tags_type=TAG_V3_TYPE.FIRST_CLASSIFY, get_ids=True))
                #
                # second_classify_names_list.extend(
                #     get_ids_by_names(tags_ids=tagv3_ids_list, tags_type=TAG_V3_TYPE.SECOND_CLASSIFY))
                # second_classify_ids_list.extend(
                #     get_ids_by_names(tags_ids=tagv3_ids_list, tags_type=TAG_V3_TYPE.SECOND_CLASSIFY, get_ids=True))
                #
                # first_solutions_list.extend(
                #     get_ids_by_names(tags_ids=tagv3_ids_list, tags_type=TAG_V3_TYPE.MACROSCOPIC_MODE))
                # first_solutions_ids_list.extend(
                #     get_ids_by_names(tags_ids=tagv3_ids_list, tags_type=TAG_V3_TYPE.MACROSCOPIC_MODE, get_ids=True))
                #
                # second_solutions_list.extend(
                #     get_ids_by_names(tags_ids=tagv3_ids_list, tags_type=TAG_V3_TYPE.FIRST_BRAND))
                # second_solutions_ids_list.extend(
                #     get_ids_by_names(tags_ids=tagv3_ids_list, tags_type=TAG_V3_TYPE.FIRST_BRAND, get_ids=True))
            if len(project_tags_ids_list):
                ##获取项目标签关联的属性标签
                info_dict = gets_nomal_dict(tags_ids=project_tags_ids_list, tag_type=TAG_V3_TYPE.NORMAL)

                first_classify_ids_list.extend(info_dict.get("first_classify_ids", []))
                first_classify_names_list.extend(info_dict.get("first_classify_names", []))

                second_classify_ids_list.extend(info_dict.get("second_classify_ids", []))
                second_classify_names_list.extend(info_dict.get("second_classify_names", []))

                first_demands_ids_list.extend(info_dict.get("first_demands_ids", []))
                first_demands_list.extend(info_dict.get("first_demands", []))

                second_demands_ids_list.extend(info_dict.get("second_demands_ids", []))
                second_demands_list.extend(info_dict.get("second_demands", []))

                first_solutions_ids_list.extend(info_dict.get("first_solutions_ids", []))
                first_solutions_list.extend(info_dict.get("first_solutions", []))

                second_solutions_ids_list.extend(info_dict.get("second_solutions_ids", []))
                second_solutions_list.extend(info_dict.get("second_solutions", []))

                first_positions_ids_list.extend(info_dict.get("first_positions_ids", []))
                first_positions_list.extend(info_dict.get("first_positions", []))

                second_positions_ids_list.extend(info_dict.get("second_positions_ids", []))
                second_positions_list.extend(info_dict.get("second_positions", []))

        return (need_refresh_data,
                set(second_demands_list), set(second_solutions_list), set(second_positions_list),
                set(second_demands_ids_list), set(second_solutions_ids_list), set(second_positions_ids_list),
                set(first_demands_ids_list), set(first_solutions_ids_list), set(first_positions_ids_list),
                set(first_demands_list), set(first_solutions_list), set(first_positions_list),
                set(project_tags_list), set(project_tags_ids_list),
                set(first_classify_ids_list), set(first_classify_names_list),
                set(second_classify_ids_list), set(second_classify_names_list))
    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return ()


def get_diary_ids_for_ai_tab(last_diary_id=None, max_diary_id=None):
    q = Q(first_positions__contains='脸') | \
        Q(first_positions__contains='唇') | \
        Q(first_positions__contains='眼') | \
        Q(first_positions__contains='鼻') | \
        Q(first_positions__contains='眉')

    if last_diary_id:
        strategy_content = StrategyContentTagV3.objects.using("jerry_tidb").filter(content_id=last_diary_id).last()
        q &= Q(id__gt=strategy_content.id)
        if max_diary_id:
            max_diary_id += strategy_content.id

    if max_diary_id:
        q &= Q(id__lt=max_diary_id)

    result = StrategyContentTagV3.objects.using("jerry_tidb").filter(q).all().values_list('content_id', flat=True)
    return result


def gets_synonym_homoionym_by_ids_names(tags_ids=[], tag_type=None, get_name=True):
    try:
        """
        根据标签的名称获取ID
        :param name_list: 
        :return: 
        """
        from agile.views.tag_v3 import TagV3Service
        service = TagV3Service()
        synonym_tags = []
        all_tag_info = service.gets_synonym_or_homoionym(tag_ids=tags_ids, tag_type=tag_type, get_synonym=True)
        for item in all_tag_info:
            syno_data = all_tag_info[item]
            if len(syno_data):
                synonym_tags.extend(syno for syno in syno_data if len(syno) > 0)
        return synonym_tags

    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return []


def gets_nomal_dict(tags_ids=[], tag_type=None, tags_name=[]):
    try:
        """
        根据标签的名称获取ID
        :param name_list: 
        :return: 
        """
        from agile.views.tag_v3 import TagV3Service

        tags_id_list = []
        tags_name_lsit = []

        first_classify_ids = []
        second_classify_ids = []
        first_classify_names = []
        second_classify_names = []

        project_tags = []
        first_demands = []
        second_demands = []
        first_solutions = []
        second_solutions = []
        first_positions = []
        second_positions = []

        project_tags_ids = []
        first_demands_ids = []
        second_demands_ids = []
        first_solutions_ids = []
        second_solutions_ids = []
        first_positions_ids = []
        second_positions_ids = []

        if isinstance(tags_ids, (str, int)):
            tags_id_list.append(tags_ids)
        else:
            tags_id_list = tags_ids
        service = TagV3Service()
        all_tag_info = service.gets_relation_tag(tag_ids=tags_id_list, tag_type=tag_type, tag_names=tags_name_lsit)
        logging.info("get tags_id_list:%s,all_tag_info:%s" % (tags_id_list, all_tag_info))

        if all_tag_info:
            for item in tags_id_list:
                tag_info = all_tag_info.get(str(item), {})
                if tag_info:
                    for tag in tag_info:
                        id = tag.get("id", None)
                        name = tag.get("name", None)
                        tag_type = tag.get("tag_type", None)
                        logging.info("get tag_type:%s" % (type(tag_type)))
                        if tag_type == TAG_V3_TYPE.FIRST_CLASSIFY:
                            first_classify_ids.append(id)
                            first_classify_names.append(name)
                        elif tag_type == TAG_V3_TYPE.SECOND_CLASSIFY:
                            second_classify_ids.append(id)
                            second_classify_names.append(name)
                        elif tag_type == TAG_V3_TYPE.NORMAL:
                            project_tags_ids.append(id)
                            project_tags.append(name)
                        elif tag_type == TAG_V3_TYPE.FIRST_APPEAL:
                            first_demands_ids.append(id)
                            first_demands.append(name)
                        elif tag_type == TAG_V3_TYPE.SECOND_APPEAL:
                            second_demands_ids.append(id)
                            second_demands.append(name)
                        elif tag_type == TAG_V3_TYPE.MACROSCOPIC_MODE:
                            first_solutions_ids.append(id)
                            first_solutions.append(name)
                        elif tag_type == TAG_V3_TYPE.FIRST_BRAND:
                            second_solutions_ids.append(id)
                            second_solutions.append(name)
                        elif tag_type == TAG_V3_TYPE.FIRST_POSITION:
                            first_positions_ids.append(id)
                            first_positions.append(name)
                        elif tag_type == TAG_V3_TYPE.SECOND_POSITION:
                            second_positions_ids.append(id)
                            second_positions.append(name)

        logging.info("get second_demands_ids:%s,second_demands:%s" % (second_demands_ids, second_demands))
        return {"first_classify_ids": list(set(first_classify_ids)),
                "first_classify_names": list(set(first_classify_names)),
                "second_classify_ids": list(set(second_classify_ids)),
                "second_classify_names": list(set(second_classify_names)),
                "project_tags_ids": list(set(project_tags_ids)), "project_tags": list(set(project_tags)),
                "first_demands_ids": list(set(first_demands_ids)), "first_demands": list(set(first_demands)),
                "second_demands_ids": list(set(second_demands_ids)), "second_demands": list(set(second_demands)),
                "first_solutions_ids": list(set(first_solutions_ids)), "first_solutions": list(set(first_solutions)),
                "second_solutions_ids": list(set(second_solutions_ids)),
                "second_solutions": list(set(second_solutions)),
                "first_positions_ids": list(set(first_positions_ids)), "first_positions": list(set(first_positions)),
                "second_positions_ids": list(set(second_positions_ids)), "second_positions": list(set(second_positions))
                }

    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return {}


def get_tag_v3_operators_tags(content_id=None):
    try:
        all_tags = list(
            set(DiaryTagV3.objects.filter(diary_id=content_id).values_list("tag_v3_id", flat=True)))
        all_operators_ids = get_ids_by_names(tags_ids=all_tags, tags_type=TAG_V3_TYPE.EXCHANGE, get_ids=True)
        all_operators_ids.extend(get_ids_by_names(tags_ids=all_tags, tags_type=TAG_V3_TYPE.COMMUNITY, get_ids=True))
        all_operators_ids.extend(get_ids_by_names(tags_ids=all_tags, tags_type=TAG_V3_TYPE.CITY, get_ids=True))
        all_operators_ids.extend(get_ids_by_names(tags_ids=all_tags, tags_type=TAG_V3_TYPE.PROVINCE, get_ids=True))
        all_operators_ids.extend(get_ids_by_names(tags_ids=all_tags, tags_type=TAG_V3_TYPE.COUNTRY, get_ids=True))
        all_operators_ids.extend(get_ids_by_names(tags_ids=all_tags, tags_type=TAG_V3_TYPE.SUPERSTAR, get_ids=True))
        all_operators_ids.extend(get_ids_by_names(tags_ids=all_tags, tags_type=TAG_V3_TYPE.CARD_DISPLAY, get_ids=True))

        return all_operators_ids
    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return []


def get_tag_v3_anecdote_tags(content_id=None):
    try:
        all_tags = list(
            set(DiaryTagV3.objects.filter(diary_id=content_id).values_list("tag_v3_id", flat=True)))
        all_operators_ids = get_ids_by_names(tags_ids=all_tags, tags_type=TAG_V3_TYPE.SUPERSTAR)
        return all_operators_ids
    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return []


def get_tag_v3_anecdote_tag_ids(content_id=None):
    try:
        all_tags = list(
            set(DiaryTagV3.objects.filter(diary_id=content_id).values_list("tag_v3_id", flat=True)))
        all_operators_ids = get_ids_by_names(tags_ids=all_tags, tags_type=TAG_V3_TYPE.SUPERSTAR, get_ids=True)
        return all_operators_ids
    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return []
