# coding=utf-8
from django.core.management import BaseCommand
from openpyxl import Workbook, load_workbook

from api.models import BuDanLuRu


class Command(BaseCommand):
    """
    补单录入添加类型
    python manage.py add_budanluru_type
    """

    def handle(self, *args, **kwargs):
        objs = BuDanLuRu.objects.all()
        workbook = load_workbook('./budan_luru.xlsx')
        sheet = workbook.get_active_sheet()
        datas = {}
        for item in sheet:
            datas[item[0].value] = item[5].value
        for obj in objs:
            if datas.get(obj.id, None) != None:
                obj.type = datas.get(obj.id)
                obj.save()

