#!/usr/bin/env python
# -*- coding:utf-8 -*-
#
#   Author  :   RobertDing
#   E-mail  :   robertdingx@gmail.com
#   Date    :   16/03/18 10:19:01
#   Desc    :   大礼包渠道之前数据插入数据库
#
from __future__ import absolute_import, division, with_statement, print_function

from django.core.management import BaseCommand

from api.models import BusinessChannel


items = [
    (0, '360生活助手'),
    (1, '付款成功后微信分享'),
    (2, '内部使用'),
    (3, '易拉宝'),
    (4, 'CEO发红包'),
    (5, '市场合作'),
    (6, '8.5返场券'),
    (7, '游戏-愿望树'),
    (8, '99更美周年大礼包'),
    (9, '微信摇'),
    (10, '品牌组活动'),
    (11, '市场组活动'),
    (12, '邀请好友'),
    (13, '接受邀请'),
    (14, '百度优惠'),
    (15, '2016元旦'),
    (16, '经纬中国'),
    (17, '分众专享'),
    (18, '嗒嗒巴士'),
]


class Command(BaseCommand):

    def handle(self, *args, **kwargs):
        data = BusinessChannel.objects.all()
        if data:
            print('错误: api_business_channel 数据库不为空')
            return
        BusinessChannel.objects.bulk_create([
            BusinessChannel(id=id, desc=desc) for (id, desc) in items])
