# coding=utf-8
from django.core.management import BaseCommand

from hippo.models import MerchantContract
from utils.execel import ExcelReader
import datetime


class Command(BaseCommand):
    """
    添加商户合同包含抽拥比例
    """

    def handle(self, *args, **options):
        path = 'merchant_contract.xlsx'
        e_reader = ExcelReader(path)
        print(e_reader)
        e_reader.sheet_select_by_name(u"有纸质版合同-转诊")
        row_num=e_reader.row_number
        print(row_num)
        res=[]
        for line in range(1,row_num):
            row=e_reader.read_row(line)
            # print(row[4],type(row[4]),type(row[4]) is unicode)
            try:
                res.append(MerchantContract(
                    merchant_id= row[3],
                    cash_back_rate_str=row[4] if type(row[4]) is unicode else str(row[4]*100)+"%",
                    start_time=row[5],
                    # end_time=datetime.datetime.strptime(row[6], "%Y-%m-%d")
                ))
            except:
                print('error:', row)
                continue
        MerchantContract.objects.bulk_create(res)
        print("增加",row_num,len(res))
        
