# coding: utf-8


from django.core.management import BaseCommand

from api.models.doctor import Doctor
from api.models import CouponDoctorRestrict, Coupon

from xml.etree import ElementTree as ET


big_string = """
<text>
<option value="001d9eeb32ce43de8253d442e23ddb00" selected="selected">001d9eeb32ce43de8253d442e23ddb00:成都莱尹医疗美容诊所(成都莱尹医疗美容诊所)(民营医院)(在线)</option>
<option value="0238f19a9ecb4ed9926fb946e1460a78" selected="selected">0238f19a9ecb4ed9926fb946e1460a78:兰州三爱整形美容医院(兰州三爱整形美容医院)(民营医院)(在线)</option>
<option value="0b583a0e260a11e695a200163e000a4a" selected="selected">0b583a0e260a11e695a200163e000a4a:广州健丽医疗美容(广州健丽医疗美容)(民营医院)(在线)</option>
<option value="0c0e63b870b711e6ba7300163e000d0b" selected="selected">0c0e63b870b711e6ba7300163e000d0b:广州华美医疗美容医院(广州华美医疗美容医院)(民营医院)(在线)</option>
<option value="0c83e032471a11e6982d00163e000d0b" selected="selected">0c83e032471a11e6982d00163e000d0b:北京雅靓医疗美容(北京雅靓医疗美容)(民营医院)(在线)</option>
<option value="0db0fcd88dc911e6901c00163e000a4a" selected="selected">0db0fcd88dc911e6901c00163e000a4a:上海美莱医疗美容门诊部(上海美莱医疗美容医院)(民营医院)(在线)</option>
<option value="1355e2f8e68e11e5930c00163e000a4a" selected="selected">1355e2f8e68e11e5930c00163e000a4a:壹加壹整形美容医院（华南旗舰院）(壹加壹整形美容医院（华南旗舰院）)(民营医院)(在线)</option>
<option value="13b1b85c9f3011e68c5d00163e000d0b" selected="selected">13b1b85c9f3011e68c5d00163e000d0b:广州海珠今生医疗门诊部(广州海珠今生医疗门诊部)(民营医院)(在线)</option>
<option value="13d05327e46e4ffc929b7bb05b2c41ac" selected="selected">13d05327e46e4ffc929b7bb05b2c41ac:洛阳孔繁荣医疗美容门诊部(洛阳孔繁荣医疗美容门诊部)(民营医院)(在线)</option>
<option value="17de4e42943911e6b13400163e00062b" selected="selected">17de4e42943911e6b13400163e00062b:上海艺星医疗美容医院(上海艺星医疗美容医院)(民营医院)(在线)</option>
<option value="1904a2cd07bc4858a7fc952481fe8734" selected="selected">1904a2cd07bc4858a7fc952481fe8734:四川友谊医院(四川友谊医院)(民营医院)(在线)</option>
<option value="1a58a60194324ba0b92ed18ddff36042" selected="selected">1a58a60194324ba0b92ed18ddff36042:青岛华韩整形美容医院(青岛华韩整形美容医院)(民营医院)(在线)</option>
<option value="2658deca551a47ae999cb6fef0294572" selected="selected">2658deca551a47ae999cb6fef0294572:重庆长良医疗美容(重庆长良医疗美容)(民营医院)(在线)</option>
<option value="2da81dcfdf6d48f787e92232e3fdefab" selected="selected">2da81dcfdf6d48f787e92232e3fdefab:煤医医疗美容医院(原煤炭总医院整形美容中心）(煤医医疗美容医院(原煤炭总医院整形美容中心）)(民营医院)(在线)</option>
<option value="34e8443866bb47948659f8e46aca8786" selected="selected">34e8443866bb47948659f8e46aca8786:成都琢悦医疗美容门诊部(成都琢悦医疗美容门诊部)(民营医院)(在线)</option>
<option value="363440eab90611e5831600163e002fb3" selected="selected">363440eab90611e5831600163e002fb3:重庆天艺美整形(重庆天艺美整形)(民营医院)(在线)</option>
<option value="3bf662bcdd5c11e6940e00163e00062b" selected="selected">3bf662bcdd5c11e6940e00163e00062b:合肥华美美容医院(合肥华美整形美容医院)(民营医院)(在线)</option>
<option value="3e00f028f81d11e6af9e00163e0051d4" selected="selected">3e00f028f81d11e6af9e00163e0051d4:北京凯润婷（原史三八）医疗美容医院(北京凯润婷（原史三八）医疗美容医院)(民营医院)(在线)</option>
<option value="3f8a750ff2b641ac8b186ea820bba509" selected="selected">3f8a750ff2b641ac8b186ea820bba509:北京韩啸医疗美容(北京韩啸医疗美容)(民营医院)(在线)</option>
<option value="454fe69e00a64890b7b011854498807f" selected="selected">454fe69e00a64890b7b011854498807f:重庆万家燕整形外科医院(重庆万家燕整形外科医院)(民营医院)(在线)</option>
<option value="48e5808efc9811e59e9e00163e002fb3" selected="selected">48e5808efc9811e59e9e00163e002fb3:成都艾米丽医疗美容整形(成都艾米丽医疗美容整形)(民营医院)(在线)</option>
<option value="4cad5202621d4a6b9ce340efccf59d87" selected="selected">4cad5202621d4a6b9ce340efccf59d87:南京华美美容医院(南京华美整形医院)(民营医院)(在线)</option>
<option value="4d7074d659f611e6bd4700163e001c72" selected="selected">4d7074d659f611e6bd4700163e001c72:成都赵善军博士整形美容(成都赵善军博士整形美容)(民营医院)(在线)</option>
<option value="4dafecfc29ef48fe94d738f0d4a517a6" selected="selected">4dafecfc29ef48fe94d738f0d4a517a6:北京亚楠容悦医疗美容诊所(北京亚楠容悦医疗美容诊所)(民营医院)(在线)</option>
<option value="4fce56414b16433bb09180b3aff8013b" selected="selected">4fce56414b16433bb09180b3aff8013b:杭州港丽医疗美容诊所(杭州港丽医疗美容)(民营医院)(在线)</option>
<option value="5379f79ca49e11e686ed00163e00062b" selected="selected">5379f79ca49e11e686ed00163e00062b:广州艺美整形(广州艺美整形)(民营医院)(在线)</option>
<option value="53af6e4aebb74abab1fc7993dbd5a560" selected="selected">53af6e4aebb74abab1fc7993dbd5a560:杭州美莱医疗美容医院(杭州美莱医疗美容医院)(民营医院)(在线)</option>
<option value="5572bb1ed96f11e6bf8600163e001c72" selected="selected">5572bb1ed96f11e6bf8600163e001c72:四川美莱医学美容医院(四川美莱医学美容医院)(民营医院)(在线)</option>
<option value="59a09a764b3011e681f800163e000a4a" selected="selected">59a09a764b3011e681f800163e000a4a:福州爱美尔整形(福州爱美尔医疗美容)(民营医院)(在线)</option>
<option value="5b9f74031cbf4d9da5895c755128ce64" selected="selected">5b9f74031cbf4d9da5895c755128ce64:美国容丽妍南京分院（中国区旗舰院）(美国容丽妍南京分院（中国区旗舰院）)(民营医院)(在线)</option>
<option value="5cdbcf3044b411e68d6000163e002fb3" selected="selected">5cdbcf3044b411e68d6000163e002fb3:深圳江南阳光医疗美容医院(深圳江南阳光医疗美容医院)(民营医院)(在线)</option>
<option value="5e6c58dfecdf4f148f9cf49bfc981fbc" selected="selected">5e6c58dfecdf4f148f9cf49bfc981fbc:重庆军科整形医院(重庆军科整形医院)(民营医院)(在线)</option>
<option value="5e9c5ecddcf24392b3d5194ad879285a" selected="selected">5e9c5ecddcf24392b3d5194ad879285a:广东韩妃医疗美容医院(广东韩妃医疗美容医院)(民营医院)(在线)</option>
<option value="63383892c2ed4795b78362790df382cc" selected="selected">63383892c2ed4795b78362790df382cc:郑州华领医疗美容医院(郑州华领医疗美容医院)(民营医院)(在线)</option>
<option value="6358ca1ed9f911e5849500163e000a4a" selected="selected">6358ca1ed9f911e5849500163e000a4a:昆明梦想医疗美容医院(昆明梦想医疗美容医院)(民营医院)(在线)</option>
<option value="66a56310fceb11e6863600163e0051d4" selected="selected">66a56310fceb11e6863600163e0051d4:苏州美莱美容医院(苏州美莱美容医院)(民营医院)(在线)</option>
<option value="689f5fbd278a40be80e457394568a240" selected="selected">689f5fbd278a40be80e457394568a240:艾尔莎·奥拉克医疗美容门诊部(艾尔莎·奥拉克医疗美容门诊部)(民营医院)(在线)</option>
<option value="69a42cf0d62b11e5935d00163e002cb6" selected="selected">69a42cf0d62b11e5935d00163e002cb6:北京百达丽医疗美容门诊部(北京百达丽医疗美容门诊部)(民营医院)(在线)</option>
<option value="69f06004b82911e5a48a00163e000d0b" selected="selected">69f06004b82911e5a48a00163e000d0b:北京知音医疗美容(北京知音医疗美容)(民营医院)(在线)</option>
<option value="6ae01d10f4514b8c853710358ecbf379" selected="selected">6ae01d10f4514b8c853710358ecbf379:郑州美莱医疗美容医院(郑州美莱)(民营医院)(在线)</option>
<option value="6e55dcb6f72b4486bf684554b20a8214" selected="selected">6e55dcb6f72b4486bf684554b20a8214:佛山市禅城区中心医院(佛山市禅城区中心医院)(民营医院)(在线)</option>
<option value="719378f703a84b178385213e3e4a4d31" selected="selected">719378f703a84b178385213e3e4a4d31:北京圣贝口腔（海淀店）(北京圣贝口腔（海淀店）)(民营医院)(在线)</option>
<option value="7423172a091811e6974700163e002fb3" selected="selected">7423172a091811e6974700163e002fb3:成都玛丽亚医疗美容(成都玛丽亚医疗美容)(民营医院)(在线)</option>
<option value="85c47f9711a84f06adb79a5d5f6849ed" selected="selected">85c47f9711a84f06adb79a5d5f6849ed:厦门美莱医疗美容医院(厦门美莱医疗美容医院)(民营医院)(在线)</option>
<option value="8a52a078b16b11e6b80100163e001c72" selected="selected">8a52a078b16b11e6b80100163e001c72:紫馨医疗美容医院(紫馨医疗美容医院)(民营医院)(在线)</option>
<option value="9489f05c136111e7b07500163e000d0b" selected="selected">9489f05c136111e7b07500163e000d0b:重庆时光整形美容医院(重庆时光整形美容医院)(民营医院)(在线)</option>
<option value="96f8717d20e348bdbbfa4caa428d6418" selected="selected">96f8717d20e348bdbbfa4caa428d6418:河南GY广运整形（美博士）医疗美容(河南GY广运整形（美博士）医疗美容)(民营医院)(在线)</option>
<option value="9734add0e897442bad7d56bde527df20" selected="selected">9734add0e897442bad7d56bde527df20:北京惠合嘉美医疗美容(北京惠合嘉美医疗美容)(民营医院)(在线)</option>
<option value="98b6ea32bb5a11e5b0a700163e001c72" selected="selected">98b6ea32bb5a11e5b0a700163e001c72:深圳富华医疗美容医院(深圳富华医疗美容医院)(民营医院)(在线)</option>
<option value="9918ad7eb8f511e58f8200163e000a4a" selected="selected">9918ad7eb8f511e58f8200163e000a4a:北京嘉禾妇儿医疗美容(北京嘉禾妇儿医疗美容)(民营医院)(在线)</option>
<option value="a0cd721c3da04d67b061617d2d75a87e" selected="selected">a0cd721c3da04d67b061617d2d75a87e:广州积美医疗美容门诊部(广州积美医疗美容门诊部)(民营医院)(在线)</option>
<option value="a26df72c911111e6a45800163e00062b" selected="selected">a26df72c911111e6a45800163e00062b:河南汇星医疗美容整形(河南汇星医疗美容整形)(民营医院)(在线)</option>
<option value="a2c203f8a2d811e5939400163e00062b" selected="selected">a2c203f8a2d811e5939400163e00062b:四川悦好医学美容医院(四川悦好医学美容医院)(民营医院)(在线)</option>
<option value="a4175712348211e6a73400163e000a4a" selected="selected">a4175712348211e6a73400163e000a4a:中家医家庭医生整形美容医院(中家医家庭医生整形美容医院)(民营医院)(在线)</option>
<option value="a657ea1602d411e7b1f900163e002cb6" selected="selected">a657ea1602d411e7b1f900163e002cb6:北京艺星医疗美容医院(北京艺星医疗美容医院)(民营医院)(在线)</option>
<option value="a6d4dffa0eeb41bc82e6286dd25bc57f" selected="selected">a6d4dffa0eeb41bc82e6286dd25bc57f:云南华美美莱美容医院(云南华美美莱美容医院)(民营医院)(在线)</option>
<option value="a9aa901b8c85441aabd268e954201dbc" selected="selected">a9aa901b8c85441aabd268e954201dbc:成都极光口腔(成都极光口腔)(民营医院)(在线)</option>
<option value="aef1f5093e0b4192ac36e6baa3e07f9b" selected="selected">aef1f5093e0b4192ac36e6baa3e07f9b:成都美绽美整形美容医院(成都美绽美整形美容医院)(民营医院)(在线)</option>
<option value="b031138447f711e6bb7d00163e00062b" selected="selected">b031138447f711e6bb7d00163e00062b:成都恒博医疗美容(成都恒博医疗美容)(民营医院)(在线)</option>
<option value="b0be931fe70e4e0d81d2e0eca18039db" selected="selected">b0be931fe70e4e0d81d2e0eca18039db:杭州艺星医疗美容医院(杭州艺星医疗美容医院)(民营医院)(在线)</option>
<option value="b0d5d7709f2c11e681ea00163e00062b" selected="selected">b0d5d7709f2c11e681ea00163e00062b:深圳健丽医疗美容门诊部(深圳健丽医疗美容门诊部)(民营医院)(在线)</option>
<option value="b4cc85ad356548ff9572556a3406b5c8" selected="selected">b4cc85ad356548ff9572556a3406b5c8:台州维多利亚(台州维多利亚整形美容)(民营医院)(在线)</option>
<option value="bb274ddd998647e5b121f0876acade38" selected="selected">bb274ddd998647e5b121f0876acade38:苏州康美美容医院(苏州康美美容医院)(民营医院)(在线)</option>
<option value="bda9dd213fbf4fcd95d74d855a87e46b" selected="selected">bda9dd213fbf4fcd95d74d855a87e46b:济南艺星医疗美容医院(济南艺星医疗美容医院)(民营医院)(在线)</option>
<option value="beijingjinyanziyiliaomeirongzhensuo" selected="selected">beijingjinyanziyiliaomeirongzhensuo:北京金燕子医疗美容诊所(北京金燕子医疗美容诊所)(民营医院)(在线)</option>
<option value="beijingjumeishiyiliaomeirongzhensuo" selected="selected">beijingjumeishiyiliaomeirongzhensuo:北京溪峰聚美仕医疗美容诊所(北京溪峰聚美仕医疗美容诊所)(民营医院)(在线)</option>
<option value="c2355c40fb2e4ab7a92355318baabc16" selected="selected">c2355c40fb2e4ab7a92355318baabc16:重庆世代美医疗美容门诊部(重庆世代美医疗美容门诊部)(民营医院)(在线)</option>
<option value="c29f3b43f3f7462d9edd861c354ee16f" selected="selected">c29f3b43f3f7462d9edd861c354ee16f:西安画美医疗美容医院(西安画美医疗美容医院)(民营医院)(在线)</option>
<option value="c30180bc876549d3a1d547e0be52ae8e" selected="selected">c30180bc876549d3a1d547e0be52ae8e:北京画美医疗美容（原长虹整形）(北京画美医疗美容（原长虹整形）)(民营医院)(在线)</option>
<option value="c4e818d43ce646599f15c4b42d1be614" selected="selected">c4e818d43ce646599f15c4b42d1be614:南京艺星医疗美容(南京艺星医疗美容)(民营医院)(在线)</option>
<option value="cc1100e8293211e6a63900163e002fb3" selected="selected">cc1100e8293211e6a63900163e002fb3:北京润美玉之光医疗美容(北京润美玉之光医疗美容)(民营医院)(在线)</option>
<option value="d062fcde0b7111e68fe600163e000a4a" selected="selected">d062fcde0b7111e68fe600163e000a4a:杭州华山连天美医疗美容医院(杭州华山连天美医疗美容医院)(民营医院)(在线)</option>
<option value="d6934136e50111e596d100163e002fb3" selected="selected">d6934136e50111e596d100163e002fb3:上海时光整形外科医院(上海时光整形外科医院)(民营医院)(在线)</option>
<option value="d6b4be784a174c11a87869a8d4819aa1" selected="selected">d6b4be784a174c11a87869a8d4819aa1:西安美莱医学美容医院(西安美莱医学美容医院)(民营医院)(在线)</option>
<option value="da14d5a20d1b11e7b1c000163e0051d4" selected="selected">da14d5a20d1b11e7b1c000163e0051d4:上海仁爱医院(上海仁爱医院)(民营医院)(在线)</option>
<option value="dbbe6886e0f911e5a8a800163e0051d4" selected="selected">dbbe6886e0f911e5a8a800163e0051d4:杭州甄美医疗美容医院(杭州甄美医疗美容医院)(民营医院)(在线)</option>
<option value="e363016609284e2eaf3e61cbe7dbe041" selected="selected">e363016609284e2eaf3e61cbe7dbe041:杭州薇琳医疗美容医院(杭州薇琳医疗美容医院)(民营医院)(在线)</option>
<option value="e411bdb7902b43a7b1f5b58aa4eef863" selected="selected">e411bdb7902b43a7b1f5b58aa4eef863:深圳艺星医疗美容医院(深圳艺星医疗美容医院)(民营医院)(在线)</option>
<option value="e42425bdd4564c9287108739cb58ea85" selected="selected">e42425bdd4564c9287108739cb58ea85:上海爱莫儿医疗美容门诊部(上海爱莫儿医疗美容门诊部)(民营医院)(在线)</option>
<option value="e4c06a6ab0ae468fb5fe095a46440b18" selected="selected">e4c06a6ab0ae468fb5fe095a46440b18:西安米兰柏羽医疗美容医院（原西安美立方）(西安米兰柏羽医疗美容医院（原西安美立方）)(民营医院)(在线)</option>
<option value="e56323f8eb4511e598d900163e00062b" selected="selected">e56323f8eb4511e598d900163e00062b:北京炫美医疗美容(北京炫美医疗美容)(民营医院)(在线)</option>
<option value="e59a58d3fccc4694b129c74f06bfedeb" selected="selected">e59a58d3fccc4694b129c74f06bfedeb:重庆美莱整形美容医院(重庆美莱整形美容医院)(民营医院)(在线)</option>
<option value="efd89b77c7b948eab5663f5f4f0a6f2e" selected="selected">efd89b77c7b948eab5663f5f4f0a6f2e:重庆美奥口腔医院(重庆美奥口腔医院)(民营医院)(在线)</option>
<option value="fe807a429b72401680a649f2af2ef4d3" selected="selected">fe807a429b72401680a649f2af2ef4d3:壹加壹口腔（华南旗舰院）(壹加壹口腔（华南旗舰院）)(民营医院)(在线)</option>
<option value="GZMEYL" selected="selected">GZMEYL:广东美恩整形美容医院(广东美恩整形美容医院)(民营医院)(在线)</option>
<option value="mgzx" selected="selected">mgzx:上海玫瑰医疗美容医院(上海玫瑰医疗美容医院)(民营医院)(在线)</option>
<option value="shanghaimeilianchenyiliaomeirongyiyuan" selected="selected">shanghaimeilianchenyiliaomeirongyiyuan:上海愉悦美联臣医疗美容医院有限公司(上海愉悦美联臣医疗美容医院有限公司)(民营医院)(在线)</option>
<option value="shanghaipuruiyankeyiyuan" selected="selected">shanghaipuruiyankeyiyuan:上海普瑞眼科医院(上海普瑞眼科医院)(民营医院)(在线)</option>
<option value="shhmylmryy" selected="selected">shhmylmryy:上海华美医疗美容医院(上海华美医疗美容医院)(民营医院)(在线)</option>
<option value="shtdylmryy" selected="selected">shtdylmryy:上海天大医疗美容医院(上海天大医疗美容医院)(民营医院)(在线)</option>
<option value="sichuanjiaodianyixuemeirongyiyuan" selected="selected">sichuanjiaodianyixuemeirongyiyuan:四川娇点医学美容医院(四川娇点医学美容医院)(民营医院)(在线)</option>
<option value="sichuanjundayixueyanjiusuofushuyiyuan" selected="selected">sichuanjundayixueyanjiusuofushuyiyuan:四川军大医学研究所附属医院(四川军大医学研究所附属医院)(民营医院)(在线)</option>
<option value="zhongqingjunmeimiaoyanzhengxingmeirongyiyuan" selected="selected">zhongqingjunmeimiaoyanzhengxingmeirongyiyuan:重庆军美医疗美容医院(重庆军美医疗美容医院)(民营医院)(在线)</option>
</text>
"""


def split_xml_snv():
	doc = ET.fromstring(big_string)
	hospital_infos = doc.getchildren()
	doctor_id2hospital_name = dict()
	for info in hospital_infos:
		string = info.text
		doctor_id, hospital_name_info = string.split(":")
		hospital_name = hospital_name_info.split("(")[0]
		doctor_id2hospital_name[doctor_id] = hospital_name
		print string
	print doctor_id2hospital_name
	return doctor_id2hospital_name


class Command(BaseCommand):

	def handle(self, *args, **options):
		coupon_ids = [
			58284,
			58285,
			58286,
			58287,
			58288,
			58289,
			58290,
			58291,
			58292,
			58293,
			58294,
			58295,
			58296,
			58323,
		]
		insert_flag = True

		need_insert_count = -1

		coupons = Coupon.objects.filter(id__in=coupon_ids)
		if not coupons:
			print("美劵不存在，请确认！ 美劵ids={}".format(coupon_ids))
			return

		doctor_id2hospital_name = split_xml_snv()
		doctor_ids = list(doctor_id2hospital_name.keys())

		doctor_hospitals = Doctor.objects.filter(id__in=doctor_ids).values("hospital_id")
		hospital_ids = [dh["hospital_id"] for dh in doctor_hospitals]
		doctors = Doctor.objects.filter(hospital_id__in=hospital_ids, is_online=1)

		insert_doctor_num = 0
		for doctor in doctors:
			if need_insert_count == insert_doctor_num:
				return
			for coupon in coupons:
				# if doctor.hospital.name not in doctor_id2hospital_name.values():
				# 	print(doctor.id + doctor.hospital.name + u"不符合要求")
				# 	continue
				print(doctor.id, doctor.hospital.name, coupon.id)

				doctor_id = doctor.id
				if insert_flag:
					cdr = CouponDoctorRestrict.objects.filter(
						coupon_id=coupon.id,
						doctor_id=doctor_id
					).first()
					if not cdr:
						cdr = CouponDoctorRestrict.objects.create(
							coupon_id=coupon.id,
							doctor_id=doctor_id
						)
						print(cdr.doctor_id, coupon.id, "new")
					else:
						print(cdr.doctor_id, coupon.id, "old")
			insert_doctor_num += 1
