#coding: utf8
import xlrd
from django.core.management import BaseCommand
from gm_types.gaia import TAG_TYPE

from api.models import ServiceTag, Tag
from api.tasks.service_task import refresh_service_cache_info

class Command(BaseCommand):

    def handle(self, *args, **options):
        
        data = []

        for row in data:
            
            service_id= int(row[0])
            specialtag_id= int(row[1])
            print (service_id, specialtag_id)
            tag = Tag.objects.filter(id=specialtag_id).first()
            if tag and tag.tag_type == TAG_TYPE.YUNYING:
                try:
                    ServiceTag.objects.get_or_create(service_id=service_id, tag_id=specialtag_id)
                    print "导入成功service_id:{},specialtag_id{}".format(service_id, specialtag_id)
                except Exception as e:
                    print "导入失败service_id:{},specialtag_id{}".format(service_id, specialtag_id)
                    print str(e)
            else:
                print "所选标签不是运营标签, 导入失败service_id:{},specialtag_id{}".format(service_id, specialtag_id)
        refresh_service_cache_info(service_ids=[item[0] for item in data])
        print ('运行结束')
