# coding=utf-8
from api.models import ServiceItem, ServiceRegisterItem
from django.core.management import BaseCommand
from rpc.tool.log_tool import info_logger
from django.db import transaction
from django.db.models import Q


class Command(BaseCommand):
    def handle(self, *args, **options):
        with transaction.atomic():

            service_item_id_list_have_register = ServiceRegisterItem.objects.filter(~Q(serviceitem=None)).values_list('serviceitem_id',flat=True)
            service_item_id_list_no_register = ServiceItem.objects.filter(~Q(id__in=service_item_id_list_have_register)&Q(is_delete=False)).values_list('id', flat=True)
            print service_item_id_list_no_register
            print len(service_item_id_list_no_register)
            info_logger.info('clean_not_have_register_sku------count_sku----{}个'.format(len(service_item_id_list_no_register)))
            info_logger.info('clean_not_have_register_sku------sku_id_list----{}'.format(service_item_id_list_no_register))
            ServiceItem.objects.filter(id__in=list(service_item_id_list_no_register)).update(is_delete=True)
            print u'------Done!--------'
