# coding:utf-8

"""名医大赏结果调整。"""

from django.core.management import BaseCommand, CommandError

from gm_types.gaia import FAMOUS_DOCTOR_JOIN_TYPE

from api.models.activities import FamousDoctorsRegistrationer
from api.services.activities.famous_doctors import FamousDoctorService


class Command(BaseCommand):
    """名医大赏结果调整。"""

    def add_arguments(self, parser):
        parser.add_argument('-id', '--hospital_id', dest='hospital_id', type=str)
        parser.add_argument('-i', '--item_id', dest='item_id', type=int)
        parser.add_argument('-c', '--count', dest='count', type=int)

    def handle(self, *args, **options):

        hospital_id = options.get('hospital_id')
        item_id = options.get('item_id')
        count = options.get('count')
        if not all([hospital_id, item_id, count]):
            raise CommandError("参数没有不全")

        register_item = FamousDoctorsRegistrationer.objects.get(
            doctor_id=hospital_id, doctor_type=FAMOUS_DOCTOR_JOIN_TYPE.HOSPITAL
        )

        FamousDoctorService.add_virtual_vote(
            doc_type=FAMOUS_DOCTOR_JOIN_TYPE.HOSPITAL,
            doc_id=hospital_id,
            item_id=item_id,
            reg_id=register_item.id,
            cnt=count
        )
