# -*- coding: utf-8 -*-
''' 拼团固定时间短信推送 '''
''' 添加crontab任务 2020年4月30日16时 定时触发 '''
from datetime import datetime

from django.core.management import BaseCommand
from pay.tasks.groupbuy_msg_tool import GroupbuyMsgList, groupbuy_push_message
from api.models import Person
from django.conf import settings


class Command(BaseCommand):

    # def add_arguments(self, parser):
    #     parser.add_argument('activity_id')

    def handle(self, *args, **options):
        # activity_id = int(options['activity_id'])
        activity_ids = [7208, 7224, 7267, 7298]
        for activity_id in activity_ids:
            self.do_it(activity_id)

    def do_it(activity_id):
        print('start send groupbuy msg activity is {} at {}'.format(activity_id, datetime.now()))

        obj = GroupbuyMsgList(activity_id=activity_id)
        user_ids = obj.gets_user_ids()
        user_ids = list(set(user_ids))
        obj_ids = Person.objects.filter(is_puppet=False, user_id__in=user_ids).values_list('user_id', flat=True)
        user_ids = list(set(obj_ids))
        for user_id in user_ids:
            groupbuy_push_message(user_id, settings.GIFT_REMIND)

        print('end send groupbuy msg at {}'.format(datetime.now()))
