# coding=utf-8
from api.models import CommodityCategory
from django.core.management import BaseCommand
import time
import json


data = [[u'玻尿酸', u'玻尿酸填充/除皱', [u'隆鼻', u'填充额头', u'垫下巴', u'填充苹果肌', u'填充太阳穴', u'丰唇', u'丰卧蚕', u'垫眉弓', u'丰面颊', u'丰唇珠', u'丰鼻基底', u'丰耳垂', u'丰眼窝', u'填泪沟', u'全脸填充', u'去静态纹', u'去法令纹', u'去颈纹', u'去面部细纹', u''], u'', u'', u'', u'玻尿酸', [u'EME(逸美)', u'TWINHA', u'TWINHA 大分子', u'TWINHA 小分子', u'爱贝芙', u'爱芙莱', u'爱芙丽', u'爱美飞', u'奥地利公主 volume', u'奥昵', u'宝尼达', u'碧萃诗', u'菲羽', u'海薇', u'韩国艾莉薇', u'韩国婕尔', u'韩国伊婉C Plus', u'韩国伊婉V Plus', u'姣兰', u'婕尔玻尿酸', u'美国乔雅登极致', u'美国乔雅登雅致', u'瑞典瑞蓝2号', u'瑞典瑞蓝丽瑅', u'润百颜', u'润百颜白紫', u'润百颜黑金', u'润百颜星耀', u'润百颜月盈', u'润致玻尿酸', u'润致动能素', u'润致臻活胶原动能液', u'润致臻活亮肤动能液', u'舒颜', u'丝丽Stylage lips', u'思黛莉', u'塑欣Sutron', u'欣菲聆', u'馨妍', u'贝丽姿', u'法思丽', u'芙媄登', u'公主', u'铂金瑞蓝', u'海薇M+', u'玻尿酸溶解酶', u'美国乔雅登丰颜', u'觉醒']], [u'玻尿酸', u'玻尿酸祛黑眼圈', u'', u'', u'', u'', u'玻尿酸', [u'EME(逸美)', u'TWINHA', u'TWINHA 大分子', u'TWINHA 小分子', u'爱贝芙', u'爱芙莱', u'爱芙丽', u'爱美飞', u'奥地利公主 volume', u'奥昵', u'宝尼达', u'碧萃诗', u'菲羽', u'海薇', u'韩国艾莉薇', u'韩国婕尔', u'韩国伊婉C Plus', u'韩国伊婉V Plus', u'姣兰', u'婕尔玻尿酸', u'美国乔雅登极致', u'美国乔雅登雅致', u'瑞典瑞蓝2号', u'瑞典瑞蓝丽瑅', u'润百颜', u'润百颜白紫', u'润百颜黑金', u'润百颜星耀', u'润百颜月盈', u'润致玻尿酸', u'润致动能素', u'润致臻活胶原动能液', u'润致臻活亮肤动能液', u'舒颜', u'丝丽Stylage lips', u'思黛莉', u'塑欣Sutron', u'欣菲聆', u'馨妍', u'贝丽姿', u'法思丽', u'芙媄登', u'公主', u'铂金瑞蓝', u'海薇M+', u'玻尿酸溶解酶', u'美国乔雅登丰颜', u'觉醒']], [u'玻尿酸', u'玻尿酸溶解酶', u'', u'', u'', u'', u'玻尿酸', [u'EME(逸美)', u'TWINHA', u'TWINHA 大分子', u'TWINHA 小分子', u'爱贝芙', u'爱芙莱', u'爱芙丽', u'爱美飞', u'奥地利公主 volume', u'奥昵', u'宝尼达', u'碧萃诗', u'菲羽', u'海薇', u'韩国艾莉薇', u'韩国婕尔', u'韩国伊婉C Plus', u'韩国伊婉V Plus', u'姣兰', u'婕尔玻尿酸', u'美国乔雅登极致', u'美国乔雅登雅致', u'瑞典瑞蓝2号', u'瑞典瑞蓝丽瑅', u'润百颜', u'润百颜白紫', u'润百颜黑金', u'润百颜星耀', u'润百颜月盈', u'润致玻尿酸', u'润致动能素', u'润致臻活胶原动能液', u'润致臻活亮肤动能液', u'舒颜', u'丝丽Stylage lips', u'思黛莉', u'塑欣Sutron', u'欣菲聆', u'馨妍', u'贝丽姿', u'法思丽', u'芙媄登', u'公主', u'铂金瑞蓝', u'海薇M+', u'玻尿酸溶解酶', u'美国乔雅登丰颜', u'觉醒']], [u'肉毒素', u'肉毒素', [u'去动态纹', u'去法令纹', u'去鱼尾纹', u'去抬头纹', u'去川字纹', u'去木偶纹', u'去鼻背纹', u'去面部细纹', u'瘦脸', u'瘦腿', u'瘦肩', u'缩鼻头', u'去狐臭', u'治疗多汗', u'去露龈笑', u'颏肌放松', u'去眉间纹', u'提升下颌缘', u''], u'', u'', u'', u'肉毒素', [u'美国保妥适(BOTOX)', u'兰州衡力', u'进口', u'国产']], [u'水光针', u'水光针', u'', u'', u'水光针注射仪器', [u'德玛莎一代', u'德玛莎二代', u'德玛莎三代'], u'水光针', [u'润百颜', u'润月雅', u'欣菲聆', u'术唯可', u'蔓百薇', u'海菲乐', u'菁芙', u'碧萃诗', u'绽美娅', u'润致', u'益术康', u'昕芙康', u'赛洛丝汀', u'欣可聆', u'恒丽', u'海月兰', u'伊肤泉', u'伊贝肤', u'嗨体', u'奥妮', u'梵伊度', u'东国', u'菲洛嘉', u'双美胶原蛋白', u'海恩', u'丝丽动能素', u'嗨注', u'瑞漾', u'TWINHA', u'百肤谜']], [u'激光脱毛', u'冰点脱毛', u'', [u'手臂', u'小腿', u'大腿', u'腋下', u'唇部', u'私密部位', u'络腮胡', u'全身', u'面颊', u'鬓毛', u'乳晕', u'手指', u'大臂', u'小臂', u'发际线', u'手背', u'脚趾', u'脚背', u'胸毛', u'腹毛', u''], u'脱毛仪', u'以色列飞顿超级冰点脱毛', u'', u''], [u'激光脱毛', u'光子脱毛', u'', [u'手臂', u'小腿', u'大腿', u'腋下', u'唇部', u'私密部位', u'络腮胡', u'全身', u'面颊', u'鬓毛', u'乳晕', u'手指', u'大臂', u'小臂', u'发际线', u'手背', u'脚趾', u'脚背', u'胸毛', u'腹毛', u''], u'脱毛仪', u'以色列飞顿超级冰点脱毛', u'', u''], [u'自体脂肪填充', u'自体脂肪填充面部', [u'填充苹果肌', u'丰面颊', u'填充太阳穴', u'填充额头', u'隆鼻', u'垫下巴', u'丰鼻基底', u'丰眉弓', u'丰卧蚕', u'丰唇', u'全脸填充', u'去法令纹', u'填充泪沟', u'丰眼窝', u'丰耳垂', u'除皱'], [u'颞发际部',u'额发际', u'额部', u'眉心部', u'眉弓部', u'面颊', u'下颏'], u'', u'', u'', u''], [u'自体脂肪填充', u'自体脂肪丰臀', u'', u'', u'', u'', u'', u''], [u'自体脂肪填充', u'自体脂肪隆胸', u'', u'', u'', u'', u'', u''], [u'自体脂肪填充', u'脂肪填充失败修复', u'', u'', u'', u'', u'', u''], [u'自体脂肪填充', u'自体脂肪丰手', u'', u'', u'', u'', u'', u''], [u'植发养发', u'植发', u'', u'', u'植发仪', [u'单体毛囊培植再生技术（FUT）', u'单毛囊提取技术（FUE）', u'无疤痕毛发移植（SHT）'], u'', u''], [u'植发养发', u'植眉', u'', u'', u'植发仪', [u'单体毛囊培植再生技术（FUT）', u'单毛囊提取技术（FUE）', u'无疤痕毛发移植（SHT）'], u'', u''], [u'植发养发', u'植睫毛', u'', u'', u'植发仪', [u'单体毛囊培植再生技术（FUT）', u'单毛囊提取技术（FUE）', u'无疤痕毛发移植（SHT）'], u'', u''], [u'植发养发', u'毛囊检测', u'', u'', u'', u'', u'', u''], [u'植发养发', u'植鬓角', u'', u'', u'植发仪', [u'单体毛囊培植再生技术（FUT）', u'单毛囊提取技术（FUE）', u'无疤痕毛发移植（SHT）'], u'', u''], [u'植发养发', u'植胡须', u'', u'', u'植发仪', [u'单体毛囊培植再生技术（FUT）', u'单毛囊提取技术（FUE）', u'无疤痕毛发移植（SHT）'], u'', u''], [u'植发养发', u'植胸毛', u'', u'', u'植发仪', [u'单体毛囊培植再生技术（FUT）', u'单毛囊提取技术（FUE）', u'无疤痕毛发移植（SHT）'], u'', u''], [u'植发养发', u'植私密毛发', u'', u'', u'植发仪', [u'单体毛囊培植再生技术（FUT）', u'单毛囊提取技术（FUE）', u'无疤痕毛发移植（SHT）'], u'', u''], [u'植发养发', u'发质护理', u'', u'', u'', u'', u'', u''], [u'植发养发', u'疤痕植发', u'', u'', u'植发仪', [u'单体毛囊培植再生技术（FUT）', u'单毛囊提取技术（FUE）', u'无疤痕毛发移植（SHT）'], u'', u''], [u'眼部整形', u'黑眼圈', u'激光祛黑眼圈', u'', u'', u'', u'', u''], [u'眼部整形', u'开眼角', [u'开内眼角', u'开外眼角'], u'', u'', u'', u'', u''], [u'眼部整形', u'双眼皮', [u'定点双眼皮', u'埋线双眼皮', u'切开双眼皮'], u'', u'', u'', u'', u''], [u'眼部整形', u'填充泪沟', u'胶原蛋白填泪沟', u'', u'', u'', u'', u''], [u'眼部整形', u'填充卧蚕', u'胶原蛋白丰卧蚕', u'', u'', u'', u'', u''], [u'眼部整形', u'眼部综合', u'', u'', u'', u'', u'', u''], [u'眼部整形', u'祛眼袋', [u'激光祛眼袋', u'内切祛眼袋', u'外切祛眼袋', u'眶隔脂肪释放祛眼袋'], u'', u'', u'', u'', u''], [u'眼部整形', u'上睑微整', [u'上眼睑去脂', u'上睑提肌', u'切眉术'], u'', u'', u'', u'', u''], [u'眼部整形', u'眼部修复', u'', u'', u'', u'', u'', u''], [u'眼部整形', u'下眼睑下至', u'下眼下至术', u'', u'', u'', u'', u''], [u'眼部整形', u'垫眉弓', u'', u'', u'', u'', u'', u''], [u'皮肤美容', u'美白嫩肤', [u'美白导入', u'黑脸娃娃', u'彩光嫩肤', u'白瓷娃娃', u'E光嫩肤', u'微针美肤', u'光子嫩肤'], u'', u'', u'', u'', u''], [u'皮肤美容', u'祛痘', [u'果酸换肤', u'红蓝光祛痘', u'小气泡美肤', u'杏仁酸焕肤'], u'', u'', u'', u'', u''], [u'皮肤美容', u'补水保湿', [u'种植面膜', u'玻尿酸精华导入', u'水氧活肤', u'无针水光', u'微针水光'], u'', u'', u'', u'', u''], [u'皮肤美容', u'祛痘印痘坑', [u'射频微针', u'微针美塑', u'化学换肤', u'像素激光', u'点阵激光'], u'', u'', u'', u'', u''], [u'皮肤美容', u'祛斑祛痣', [u'镭射净肤', u'激光点痣', u'激光祛斑', u'注射祛斑'], u'', u'', u'', u'', u''], [u'皮肤美容', u'祛疤', [u'手术祛疤', u'注射祛疤', u'激光祛疤', u'无创疤痕修复'], u'', u'', u'', u'', u''], [u'皮肤美容', u'皮肤修复', [u'祛妊娠纹', u'祛胎记', u'激光去纹身', u'激光去红血丝', u'抗敏修复'], u'', u'', u'', u'', u''], [u'面部轮廓', u'苹果肌', u'胶原蛋白填充苹果肌', u'', u'', u'', u'', u''], [u'面部轮廓', u'瘦脸', [u'激光溶脂瘦脸', u'溶脂针', u'射频溶脂瘦脸', u'取颊脂垫瘦脸', u'面部吸脂'], u'', u'', u'', u'', u''], [u'面部轮廓', u'额头', [u'额头缩小', u'假体丰额头'], u'', u'', u'', u'', u''], [u'面部轮廓', u'太阳穴', u'假体丰太阳穴', u'', u'', u'', u'', u''], [u'面部轮廓', u'下巴', [u'下巴吸脂术/除双下巴', u'曼特波隆下巴', u'硅胶垫下巴', u'膨体垫下巴', u'下巴截骨术'], u'', u'', u'', u'', u''], [u'面部轮廓', u'酒窝梨涡', u'酒窝成形术', u'', u'', u'', u'', u''], [u'面部轮廓', u'除法令纹', u'手术去法令纹', u'', u'', u'', u'', u''], [u'面部轮廓', u'下巴修复', [u'下巴硅胶假体取出', u'下巴硅胶膨体取出'], u'', u'', u'', u'', u''], [u'面部轮廓', u'眉弓', u'假体垫眉弓', u'', u'', u'', u'', u''], [u'面部轮廓', u'颧骨颧弓', [u'颧骨颧弓整形术', u'颧骨内推', u'颧骨降低'], u'', u'', u'', u'', u''], [u'面部轮廓', u'上下颚', [u'下颚前突/地包天', u'上颚前突/天包地', u'上下颚手术/突嘴矫正', u'面部不对成矫正'], u'', u'', u'', u'', u''], [u'面部轮廓', u'下颌', [u'V-LINE瓜子瘦脸手术', u'下颌角整形'], u'', u'', u'', u'', u''], [u'美体塑形', u'吸脂', u'', [u'腰腹', u'大腿', u'小腿', u'手臂', u'背部', u'臀部', u'肩部', u'脸部', u'颈部', u'腹部', u'腰部', u'大臂', u'副乳', u'小臂', u'胸部', u'全身', u'下颌缘', u'下巴'], u'吸脂/溶脂仪', [u'以色列磁雕精灵', u'以色列魔塑', u'美国酷塑冷冻溶脂', u'德国水动力吸脂', u'以色列宝丽太黄金微雕'], u'', u''], [u'美体塑形', u'射频溶脂', u'', [u'腰腹', u'大腿', u'小腿', u'手臂', u'背部', u'臀部', u'肩部', u'脸部', u'颈部', u'腹部', u'腰部', u'大臂', u'副乳', u'小臂', u'胸部', u'全身', u'下颌缘', u'下巴'], u'吸脂/溶脂仪', [u'以色列磁雕精灵', u'以色列魔塑', u'美国酷塑冷冻溶脂', u'德国水动力吸脂', u'以色列宝丽太黄金微雕'], u'', u''], [u'美体塑形', u'冷冻溶脂', u'', [u'腰腹', u'大腿', u'小腿', u'手臂', u'背部', u'臀部', u'肩部', u'脸部', u'颈部', u'腹部', u'腰部', u'大臂', u'副乳', u'小臂', u'胸部', u'全身', u'下颌缘', u'下巴'], u'吸脂/溶脂仪', [u'以色列磁雕精灵', u'以色列魔塑', u'美国酷塑冷冻溶脂', u'德国水动力吸脂', u'以色列宝丽太黄金微雕'], u'', u''], [u'美体塑形', u'超声溶脂', u'', [u'腰腹', u'大腿', u'小腿', u'手臂', u'背部', u'臀部', u'肩部', u'脸部', u'颈部', u'腹部', u'腰部', u'大臂', u'副乳', u'小臂', u'胸部', u'全身', u'下颌缘', u'下巴'], u'吸脂/溶脂仪', [u'以色列磁雕精灵', u'以色列魔塑', u'美国酷塑冷冻溶脂', u'德国水动力吸脂', u'以色列宝丽太黄金微雕'], u'', u''], [u'美体塑形', u'隔空溶脂', u'', [u'腰腹', u'大腿', u'小腿', u'手臂', u'背部', u'臀部', u'肩部', u'脸部', u'颈部', u'腹部', u'腰部', u'大臂', u'副乳', u'小臂', u'胸部', u'全身', u'下颌缘', u'下巴'], u'吸脂/溶脂仪', [u'以色列磁雕精灵', u'以色列魔塑', u'美国酷塑冷冻溶脂', u'德国水动力吸脂', u'以色列宝丽太黄金微雕'], u'', u''], [u'美体塑形', u'动氧纤体', u'', [u'腰腹', u'大腿', u'小腿', u'手臂', u'背部', u'臀部', u'肩部', u'脸部', u'颈部', u'腹部', u'腰部', u'大臂', u'副乳', u'小臂', u'胸部', u'全身', u'下颌缘', u'下巴'], u'吸脂/溶脂仪', [u'以色列磁雕精灵', u'以色列魔塑', u'美国酷塑冷冻溶脂', u'德国水动力吸脂', u'以色列宝丽太黄金微雕'], u'', u''], [u'美体塑形', u'中医减肥', u'', [u'腰腹', u'大腿', u'小腿', u'手臂', u'背部', u'臀部', u'肩部', u'脸部', u'颈部', u'腹部', u'腰部', u'大臂', u'副乳', u'小臂', u'胸部', u'全身', u'下颌缘', u'下巴'], u'吸脂/溶脂仪', [u'以色列磁雕精灵', u'以色列魔塑', u'美国酷塑冷冻溶脂', u'德国水动力吸脂', u'以色列宝丽太黄金微雕'], u'', u''], [u'美体塑形', u'激光溶脂', u'', [u'腰腹', u'大腿', u'小腿', u'手臂', u'背部', u'臀部', u'肩部', u'脸部', u'颈部', u'腹部', u'腰部', u'大臂', u'副乳', u'小臂', u'胸部', u'全身', u'下颌缘', u'下巴'], u'吸脂/溶脂仪', [u'以色列磁雕精灵', u'以色列魔塑', u'美国酷塑冷冻溶脂', u'德国水动力吸脂', u'以色列宝丽太黄金微雕'], u'', u''], [u'美体塑形', u'丰臀', u'', u'', u'', u'', u'', u''], [u'美体塑形', u'其他', u'', u'', u'', u'', u'', u''], [u'口腔', u'洁牙', [u'超声波洁牙', u'洗牙', u'喷砂洗牙', u'气动洁牙', u'放大镜洁牙', u'手工洁治'], u'', u'口腔设备', [u'瑞士EMS', u'德国卡瓦', u'法国赛特利', u'德国维润', u'美国TPC', u'锐速', u'天东', u'和茂'], u'', u''], [u'口腔', u'美白牙齿', [u'活性牙膜美白', u'冷光美白', u'美白剂美白牙齿', u'美白贴片', u'皓齿美白', u'激光美白', u'牙托美白', u''], u'', u'口腔设备', [u'瑞士EMS', u'德国卡瓦', u'法国赛特利', u'德国维润', u'美国TPC', u'锐速', u'天东', u'和茂'], u'', u''], [u'口腔', u'牙齿矫正', [u'牙齿金属矫正', u'牙齿陶瓷矫正', u'牙齿隐形矫正', u'隐形托槽矫正', u'自锁托槽矫正', u'舌侧矫正', u'牙齿托槽矫正'], u'', u'口腔设备', [u'瑞士EMS', u'德国卡瓦', u'法国赛特利', u'德国维润', u'美国TPC', u'锐速', u'天东', u'和茂'], u'', u''], [u'口腔', u'牙齿治疗', [u'补牙', u'拔牙', u'根管治疗', u'牙周护理', u'牙龈炎', u'拔智齿', u'牙髓炎'], u'', u'口腔设备', [u'瑞士EMS', u'德国卡瓦', u'法国赛特利', u'德国维润', u'美国TPC', u'锐速', u'天东', u'和茂'], u'', u''], [u'口腔', u'美容冠', [u'合金烤瓷牙', u'全瓷牙', u'贵金属烤瓷牙', u'二氧化锆全瓷牙'], u'', u'口腔设备', [u'瑞士EMS', u'德国卡瓦', u'法国赛特利', u'德国维润', u'美国TPC', u'锐速', u'天东', u'和茂'], u'', u''], [u'口腔', u'牙贴面', [u'瓷贴面', u'树脂贴面'], u'', u'口腔设备', [u'瑞士EMS', u'德国卡瓦', u'法国赛特利', u'德国维润', u'美国TPC', u'锐速', u'天东', u'和茂'], u'', u''], [u'口腔', u'种植牙', [u'普通种植', u'即刻种植', u'微创种植牙', u'微创即刻种植'], u'', u'口腔设备', [u'瑞士EMS', u'德国卡瓦', u'法国赛特利', u'德国维润', u'美国TPC', u'锐速', u'天东', u'和茂'], u'', u''], [u'口腔', u'口腔综合治疗', u'口腔溃疡', u'', u'口腔设备', [u'瑞士EMS', u'德国卡瓦', u'法国赛特利', u'德国维润', u'美国TPC', u'锐速', u'天东', u'和茂'], u'', u''], [u'口腔', u'早期矫治', [u'间隙保持器', u'MRC肌功能矫治', u'乳牙间隙管理'], u'', u'', u'', u'', u''], [u'口腔', u'牙周刮治', [u'放大镜下刮治', u'龈下刮治'], u'', u'', u'', u'', u''], [u'口腔', u'口腔检查', [u'龋齿检测', u'牙修复检查', u'儿童早期矫治检查', u'种植牙检查', u'全口检查', u'正畸检查'], u'', u'', u'', u'', u''], [u'口腔', u'龋齿', [u'涂氟', u'窝沟封闭'], u'', u'', u'', u'', u''], [u'抗衰老', u'紧致提升', [u'热玛吉', u'热拉提', u'射频紧肤', u'皮秒激光', u'埋线提升', u'NIR光波紧肤', u'超声刀', u'电波拉皮', u'拉皮手术提升', u'内窥镜手术提升', u'小切口手术提升', u'青春解码仪美肤', u'去颈纹'], u'', u'光电射频仪', [u'美国索尔塔热玛吉', u'以色列飞顿热提拉二代', u'以色列飞顿热提拉一代', u'以色列飞顿丽肤美', u'美国索尔塔热玛吉', u'以色列飞顿丽肤美', u'德国欧洲之星fotona4D', u'美国赛诺秀蜂巢皮秒', u'以色列赛诺龙-凯黛乐超皮秒', u'斯洛文尼亚欧洲之星星际行者', u'科英Q开关Nd：YAG'], u'线雕材料', [u'恒生PPDO线', u'美国美国QUILL快翎线', u'韩国美迪塑']], [u'', u'', u'', u'', u'', u'', u'嗨体', u'嗨体Hearty'], [u'抗衰老', u'注射除皱', u'', u'', u'', u'', u'', u''], [u'唇部整形', u'丰唇/唇珠', u'', u'', u'', u'', u'', u''], [u'唇部整形', u'唇部综合', u'', u'', u'', u'', u'', u''], [u'唇部整形', u'缩人中', u'', u'', u'', u'', u'', u''], [u'唇部整形', u'M唇手术', u'', u'', u'', u'', u'', u''], [u'唇部整形', u'手术去露龈笑', u'', u'', u'', u'', u'', u''], [u'唇部整形', u'嘴角上扬术', u'', u'', u'', u'', u'', u''], [u'唇部整形', u'厚唇改薄', u'', u'', u'', u'', u'', u''], [u'唇部整形', u'唇部修复', u'', u'', u'', u'', u'', u''], [u'唇部整形', u'唇腭裂手术', u'', u'', u'', u'', u'', u''], [u'鼻部整形', u'隆鼻', [u'胶原蛋白隆鼻', u'硅胶隆鼻', u'埋线隆鼻', u'假体隆鼻', u'膨体隆鼻', u'耳软骨复合隆鼻', u'鼻中隔软骨隆鼻', u'肋软骨隆鼻', u'自体真皮隆鼻'], u'', u'', u'', u'隆鼻假体', [u'美国射极峰', u'韩国韩士生科鼻假体', u'美国菲思挺', u'索康鼻假体', u'万和鼻假体', u'威宁鼻假体', u'信晟鼻假体', u'久盛鼻假体', u'美国曼特波假体', u'超体Transplus', u'美国舒铂面假体', u'美国舒铂鼻假体', u'恒生PPDO线', u'韩国美迪塑', u'韩士生科鼻假体', u'韩国美迪菲', u'双美胶原蛋白植入剂-肤丽美', u'双美胶原蛋白植入剂-肤柔美']], [u'鼻部整形', u'鼻头整形', [u'胶原蛋白隆鼻', u'硅胶隆鼻', u'埋线隆鼻', u'假体隆鼻', u'膨体隆鼻', u'耳软骨复合隆鼻', u'鼻中隔软骨隆鼻', u'肋软骨隆鼻', u'自体真皮隆鼻'], u'', u'', u'', u'隆鼻假体', [u'美国射极峰', u'韩国韩士生科鼻假体', u'美国菲思挺', u'索康鼻假体', u'万和鼻假体', u'威宁鼻假体', u'信晟鼻假体', u'久盛鼻假体', u'美国曼特波假体', u'超体Transplus', u'美国舒铂面假体', u'美国舒铂鼻假体', u'恒生PPDO线', u'韩国美迪塑', u'韩士生科鼻假体', u'韩国美迪菲', u'双美胶原蛋白植入剂-肤丽美', u'双美胶原蛋白植入剂-肤柔美']], [u'鼻部整形', u'缩鼻翼', [u'胶原蛋白隆鼻', u'硅胶隆鼻', u'埋线隆鼻', u'假体隆鼻', u'膨体隆鼻', u'耳软骨复合隆鼻', u'鼻中隔软骨隆鼻', u'肋软骨隆鼻', u'自体真皮隆鼻'], u'', u'', u'', u'隆鼻假体', [u'美国射极峰', u'韩国韩士生科鼻假体', u'美国菲思挺', u'索康鼻假体', u'万和鼻假体', u'威宁鼻假体', u'信晟鼻假体', u'久盛鼻假体', u'美国曼特波假体', u'超体Transplus', u'美国舒铂面假体', u'美国舒铂鼻假体', u'恒生PPDO线', u'韩国美迪塑', u'韩士生科鼻假体', u'韩国美迪菲', u'双美胶原蛋白植入剂-肤丽美', u'双美胶原蛋白植入剂-肤柔美']], [u'鼻部整形', u'鼻骨矫正', [u'胶原蛋白隆鼻', u'硅胶隆鼻', u'埋线隆鼻', u'假体隆鼻', u'膨体隆鼻', u'耳软骨复合隆鼻', u'鼻中隔软骨隆鼻', u'肋软骨隆鼻', u'自体真皮隆鼻'], u'', u'', u'', u'隆鼻假体', [u'美国射极峰', u'韩国韩士生科鼻假体', u'美国菲思挺', u'索康鼻假体', u'万和鼻假体', u'威宁鼻假体', u'信晟鼻假体', u'久盛鼻假体', u'美国曼特波假体', u'超体Transplus', u'美国舒铂面假体', u'美国舒铂鼻假体', u'恒生PPDO线', u'韩国美迪塑', u'韩士生科鼻假体', u'韩国美迪菲', u'双美胶原蛋白植入剂-肤丽美', u'双美胶原蛋白植入剂-肤柔美']], [u'鼻部整形', u'鼻小柱延长', [u'胶原蛋白隆鼻', u'硅胶隆鼻', u'埋线隆鼻', u'假体隆鼻', u'膨体隆鼻', u'耳软骨复合隆鼻', u'鼻中隔软骨隆鼻', u'肋软骨隆鼻', u'自体真皮隆鼻'], u'', u'', u'', u'隆鼻假体', [u'美国射极峰', u'韩国韩士生科鼻假体', u'美国菲思挺', u'索康鼻假体', u'万和鼻假体', u'威宁鼻假体', u'信晟鼻假体', u'久盛鼻假体', u'美国曼特波假体', u'超体Transplus', u'美国舒铂面假体', u'美国舒铂鼻假体', u'恒生PPDO线', u'韩国美迪塑', u'韩士生科鼻假体', u'韩国美迪菲', u'双美胶原蛋白植入剂-肤丽美', u'双美胶原蛋白植入剂-肤柔美']], [u'鼻部整形', u'垫鼻基底', [u'胶原蛋白隆鼻', u'硅胶隆鼻', u'埋线隆鼻', u'假体隆鼻', u'膨体隆鼻', u'耳软骨复合隆鼻', u'鼻中隔软骨隆鼻', u'肋软骨隆鼻', u'自体真皮隆鼻'], u'', u'', u'', u'隆鼻假体', [u'美国射极峰', u'韩国韩士生科鼻假体', u'美国菲思挺', u'索康鼻假体', u'万和鼻假体', u'威宁鼻假体', u'信晟鼻假体', u'久盛鼻假体', u'美国曼特波假体', u'超体Transplus', u'美国舒铂面假体', u'美国舒铂鼻假体', u'恒生PPDO线', u'韩国美迪塑', u'韩士生科鼻假体', u'韩国美迪菲', u'双美胶原蛋白植入剂-肤丽美', u'双美胶原蛋白植入剂-肤柔美']], [u'鼻部整形', u'鼻孔矫正', [u'胶原蛋白隆鼻', u'硅胶隆鼻', u'埋线隆鼻', u'假体隆鼻', u'膨体隆鼻', u'耳软骨复合隆鼻', u'鼻中隔软骨隆鼻', u'肋软骨隆鼻', u'自体真皮隆鼻'], u'', u'', u'', u'', [u'美国射极峰', u'韩国韩士生科鼻假体', u'美国菲思挺', u'索康鼻假体', u'万和鼻假体', u'威宁鼻假体', u'信晟鼻假体', u'久盛鼻假体', u'美国曼特波假体', u'超体Transplus', u'美国舒铂面假体', u'美国舒铂鼻假体', u'恒生PPDO线', u'韩国美迪塑', u'韩士生科鼻假体', u'韩国美迪菲', u'双美胶原蛋白植入剂-肤丽美', u'双美胶原蛋白植入剂-肤柔美']], [u'鼻部整形', u'鼻修复', [u'胶原蛋白隆鼻', u'硅胶隆鼻', u'埋线隆鼻', u'假体隆鼻', u'膨体隆鼻', u'耳软骨复合隆鼻', u'鼻中隔软骨隆鼻', u'肋软骨隆鼻', u'自体真皮隆鼻'], u'', u'', u'', u'隆鼻假体', [u'美国射极峰', u'韩国韩士生科鼻假体', u'美国菲思挺', u'索康鼻假体', u'万和鼻假体', u'威宁鼻假体', u'信晟鼻假体', u'久盛鼻假体', u'美国曼特波假体', u'超体Transplus', u'美国舒铂面假体', u'美国舒铂鼻假体', u'恒生PPDO线', u'韩国美迪塑', u'韩士生科鼻假体', u'韩国美迪菲']], [u'半永久', u'半永久美瞳线', u'', u'', u'', u'', u'', u''], [u'半永久', u'半永久纹唇', u'', u'', u'', u'', u'', u''], [u'半永久', u'半永久发际线', u'', u'', u'', u'', u'', u''], [u'半永久', u'半永久纹眉', u'', u'', u'', u'', u'', u''], [u'半永久', u'半永久纹眼线', u'', u'', u'', u'', u'', u''], [u'半永久', u'孕睫术', u'', u'', u'', u'', u'', u''], [u'胸部整形', u'隆胸', u'假体隆胸', u'', u'', u'', u'隆胸假体', [u'美国曼托', u'荷兰美国傲诺拉', u'法国伊思雅（ES升级版）', u'上海康宁', u'上海威宁', u'广州万和', u'韩国蓓菈', u'德国宝俪', u'美国傲诺拉']], [u'胸部整形', u'乳头整形', [u'乳头内陷矫正', u'乳头缩小', u''], u'', u'', u'', u'隆胸假体', [u'美国曼托', u'荷兰美国傲诺拉', u'法国伊思雅（ES升级版）', u'上海康宁', u'上海威宁', u'广州万和', u'韩国蓓菈', u'德国宝俪', u'美国傲诺拉']], [u'胸部整形', u'祛副乳', [u'吸脂去副乳', u'手术去副乳'], u'', u'', u'', u'隆胸假体', [u'美国曼托', u'荷兰美国傲诺拉', u'法国伊思雅（ES升级版）', u'上海康宁', u'上海威宁', u'广州万和', u'韩国蓓菈', u'德国宝俪', u'美国傲诺拉']], [u'胸部整形', u'乳晕美化', [u'乳晕漂红', u'乳晕缩小'], u'', u'', u'', u'隆胸假体', [u'美国曼托', u'荷兰美国傲诺拉', u'法国伊思雅（ES升级版）', u'上海康宁', u'上海威宁', u'广州万和', u'韩国蓓菈', u'德国宝俪', u'美国傲诺拉']], [u'胸部整形', u'胸型美化', [u'乳房下垂矫正',u'乳房缩小'], u'', u'', u'', u'隆胸假体', [u'美国曼托', u'荷兰美国傲诺拉', u'法国伊思雅（ES升级版）', u'上海康宁', u'上海威宁', u'广州万和', u'韩国蓓菈', u'德国宝俪', u'美国傲诺拉']], [u'胸部整形', u'胸部修复', [u'隆胸修复',u'胸部假体取出'], u'', u'', u'', u'隆胸假体', [u'美国曼托', u'荷兰美国傲诺拉', u'法国伊思雅（ES升级版）', u'上海康宁', u'上海威宁', u'广州万和', u'韩国蓓菈', u'德国宝俪', u'美国傲诺拉']], [u'私密整形', u'女性私密', [u'私密紧致',u'私密修复',u'私密漂红',u'私密养护'], u'', u'光电射频仪', [u'以色列飞顿菲蜜丽', u'意大利DEKA'], u'', u''], [u'私密整形', u'男性私密', u'', u'', u'光电射频仪', [u'以色列飞顿菲蜜丽', u'意大利DEKA'], u'', u''], [u'耳部整形', u'耳部矫正', u'招风耳矫正', u'', u'', u'', u'', u''], [u'耳部整形', u'耳再造', u'', u'', u'', u'', u'', u''],[u'眼科', u'视力检查', u'', u'', u'', u'', u'', u''], [u'眼科', u'眼科疾病', [u'青光眼',u'结膜炎',u'散光',u'沙眼',u'角膜炎',u'视网膜脱落'], u'', u'', u'', u'', u''], [u'眼科', u'近视矫正', [u'全飞秒激光术',u'飞秒激光手术',u'晶体植入',u'全激光手术',u'绿飞秒',u'准分子激光术',u'后巩膜加固术'], u'', u'', u'', u'', u''], [u'眼科', u'弱视矫正', u'', u'', u'', u'', u'', u''], [u'眼科', u'斜视矫正', u'', u'', u'', u'', u'', u''], [u'眼科', u'远视矫正', u'', u'', u'', u'', u'', u'']]

class Command(BaseCommand):

    def handle(self, *args, **options):

        print('------ starting -----')
        start_time = time.time()
        print("start at: ", start_time)

        db_exit_names = []

        #CommodityCategory.objects.all().delete()
        for data_item in range(len(data)):
            rows = data[data_item]
            #属性信息
            rows_5 = []
            if rows[5]:
                if isinstance(rows[5], list):
                    rows_5 = rows[5]
                else:
                    rows_5 = [rows[5]]

            rows_7 = []
            if rows[7]:
                if isinstance(rows[7], list):
                    rows_7 = rows[7]
                else:
                    rows_7 = [rows[7]]
            data_1 = rows[3] if rows[3] else []
            data_2 = [u'{}/{}'.format(rows[4], item) for item in rows_5] if rows[4] and rows_5 else []
            data_3 = [u'{}/{}'.format(rows[6], item) for item in rows_7] if rows[6] and rows_7 else []
            shuxing = json.dumps({
                1: [item.decode('utf-8') for item in data_1],
                2: [item.decode('utf-8') for item in data_2],
                3: [item.decode('utf-8') for item in data_3],
            })

            if not rows[0]:
                continue

            #一级类目
            db_exit_names.append(rows[0])
            if rows[1]:
                obj, is_create = CommodityCategory.objects.update_or_create(name=rows[0], father_id=0, defaults={
                                'property_info': ''})
            else:
                obj, is_create = CommodityCategory.objects.update_or_create(name=rows[0], father_id=0, defaults={
                'property_info': shuxing
            })

            father_id = obj.id


            #二级类目
            if rows[1]:
                if isinstance(rows[1], list):
                    db_exit_names.extend(rows[1])
                    for rows_1_item in rows[1]:
                        if rows[2]:
                            obj, is_create = CommodityCategory.objects.update_or_create(name=rows_1_item,
                                                                                     father_id=father_id, defaults={
                                'property_info': ""})
                        else:

                            obj, is_create = CommodityCategory.objects.update_or_create(name=rows_1_item,
                                                                                        father_id=father_id, defaults={
                                    'property_info': shuxing})
                else:
                    db_exit_names.append(rows[1])
                    if rows[2]:
                        obj, is_create = CommodityCategory.objects.update_or_create(name=rows[1], father_id=father_id, defaults={
                                'property_info': ""})
                    else:
                        obj, is_create = CommodityCategory.objects.update_or_create(name=rows[1],
                                                                                    father_id=father_id, defaults={
                                'property_info': shuxing})

            father_id = obj.id
            #三级类目
            if rows[2]:
                if isinstance(rows[2], list):
                    db_exit_names.extend(rows[2])
                    for rows_2_item in rows[2]:
                        obj, is_create = CommodityCategory.objects.update_or_create(name=rows_2_item, father_id=father_id,
                                                                                    defaults={'property_info': shuxing})
                else:
                    db_exit_names.append(rows[2])
                    obj, is_create = CommodityCategory.objects.update_or_create(name=rows[2], father_id=father_id,
                                                                                defaults={'property_info': shuxing})
        CommodityCategory.objects.exclude(name__in=db_exit_names).delete()

        end_time = time.time()
        print("end at: ", end_time)
        print('total use {} s.'.format(end_time - start_time))
        print('Done!')
