# coding=utf-8
# description:导入产品提供的美购service和tag关联的数据,数据来自excel
# author:gao ming
# update time:2019.05.07

import xlrd
from django.core.management import BaseCommand
from statistic.models import PromotionChannel
from gm_types.gaia import TAG_TYPE




def add_service_tag(file):
	try:
		data = xlrd.open_workbook(file.decode('utf-8'))
		sheets=data.sheets()
	except Exception as e:
		print str(e)
		print "file not exists!"

	for sheet in sheets:
		for index in range(1,sheet.nrows):
			row=sheet.row_values(index)
			if row:
				try:
					idfa,active_time=row[0],row[2]
					channel=PromotionChannel.objects.create(appid="promotion_qianka",idfa=idfa,create_time=active_time,active_time=active_time,update_time=active_time,platform_type=1)
					print(channel.idfa)
					print(channel.active_time)
					print(channel.update_time)
					channel.save()
				except Exception as e:
					print str(e)



class Command(BaseCommand):
    """
    python manage.py relation_190507_service_with_tag
    """
    def handle(self, *args, **options):
        add_service_tag("qianka.xlsx")
        print 'Complete!'