# coding=utf-8
from django.core.management import BaseCommand

from api.models import Special, SpecialItem, ServiceRecommend


class Command(BaseCommand):
    """
    处理美购推荐数据
    python manage.py set_servicerecommend_data
    """

    def handle(self, *args, **options):
        special = Special.objects.get(type=Special.SPECIAL_TYPE.RECOMMEND)
        specialItems = SpecialItem.objects.filter(special=special)
        for specialItem in specialItems:
            try:
                servicerecommend = ServiceRecommend.objects.get_or_create(service_id=specialItem.service.id)[0]
                servicerecommend.is_recommend = specialItem.is_recommend
                servicerecommend.rank = specialItem.rank
                servicerecommend.is_delete = False
                servicerecommend.save()
                print servicerecommend.id
            except Exception as e:
                print e.message
                continue
