# coding=utf-8
import tablib
from django.core.management import BaseCommand
from gm_types.gaia import YINUO_TYPE

from api.models import Service


class Command(BaseCommand):
    """
    设置一诺保险默认的美购
    python manage.py set_yinuo_service
    """

    def handle(self, *args, **options):
        dt_result = tablib.Dataset()
        dt_result.headers = [u'美购ID', u'是否搭售保险', u'一诺保险类型']
        services = Service.objects.filter(is_insurance=True)
        for service in services:
            row = []
            print service.id
            row.append(service.id)
            row.append(str(service.is_insurance))
            service.yinuo_type = YINUO_TYPE.CASUALTY
            row.append(YINUO_TYPE.getDesc(service.yinuo_type))
            service.save()
            dt_result.append(row)
        open(u'/data/insurance/yinuo.xlsx', 'wb').write(dt_result.xlsx)
        print('Done!')
