#!/usr/bin/env python
# -*- coding:utf-8 -*-
#
#   Author  :   zhangxiaolin
#   E-mail  :   petelin1120@gmail.com
#   Date    :   17/10/16 16:16
#   Desc    :   展示发送给第三方的退款单信息
from api.models import CashBackOrder, RefundOrder
from pay.models import WechatRefund, ApplePayRefund
from pay.models.alipay import AlipayRefund


def show_refund_order_info(refundorder_id=None, cashbackorder_id=None):
    assert refundorder_id is not None or cashbackorder_id is not None
    if refundorder_id is not None:
        refund_order = RefundOrder.objects.get(id=refundorder_id)
        which_type = "退款"
        order_no = refund_order.order_id
    elif cashbackorder_id is not None:
        cashback_order = CashBackOrder.objects.get(id=cashbackorder_id)
        which_type = "返现"
        order_no = cashback_order.order_id

    # 微信退款
    try:
        wechat_refund = WechatRefund.objects.get(order_no=order_no)
    except WechatRefund.DoesNotExist:
        pass
    else:
        print "{}{which_type}, {which_type}单号:{}, 退款金额:{}".format("微信", wechat_refund.out_refund_no,
                                                                  wechat_refund.refund_fee, which_type=which_type)
        return ("wechat", wechat_refund.out_refund_no, wechat_refund.refund_fee)

    try:
        apple_refund = ApplePayRefund.objects.get(order_no=order_no)
    except ApplePayRefund.DoesNotExist:
        pass
    else:
        print "{}{which_type}, {which_type}单号:{}, 退款金额:{}".format("连连支付", apple_refund.no_refund,
                                                                  apple_refund.money_refund, which_type=which_type)
        return ("lianlian", apple_refund.no_refund, apple_refund.money_refund)

    try:
        alipay_refund = AlipayRefund.objects.get(order_no=order_no)
    except AlipayRefund.DoesNotExist:
        print '找不到退款单'
        return None
    else:
        print "{}{which_type}, {which_type}单号:{}, 退款金额:{}".format("支付宝", alipay_refund.batch_no,
                                                                  alipay_refund.refund_fee, which_type=which_type)
        return ("ali", alipay_refund.batch_no, alipay_refund.refund_fee)
