#!/usr/bin/env python
# -*- coding: utf-8 -*-
import time
from django.conf import settings
from django.core.management import BaseCommand

from agile.models import TagMapOldTag
from api.models import TabOperateV2, TabOperateV2TagV3
from group.models import Group, GroupTag, GroupTagV3
from polymer.models import PolymerTag, Polymer, PolymerTagV3


class Command(BaseCommand):
    """
    标签-标签3.0
    python manage.py tag3_tag_map --type=*
    type: choice is group/polymer/tab
    """
    def add_arguments(self, parser):
        parser.add_argument(
            '--type',
            help=u'内容类型(单选), choice is group/polymer/tab ...'
        )

    def handle(self, *args, **options):
        content_type = options.get('type')
        if not content_type:
            print('请输入正确参数:--type=*, choice is group/polymer/tab')
        print('type= {}'.format(content_type))
        content_type = content_type.lower()
        start = time.time()
        if content_type == 'tab':
            tab_operates = TabOperateV2.objects.filter(
                is_online=True
            ).order_by('id')
            tab_operates_objects = []
            for operate in tab_operates.iterator():
                old_tag_ids = list(operate.tags.all().values_list('id', flat=True))
                if not old_tag_ids:
                    continue
                tag3_ids = list(TagMapOldTag.objects.using(settings.SLAVE_DB_NAME).filter(
                    old_tag_id__in=old_tag_ids
                ).values_list('tag_id', flat=True))
                if not tag3_ids:
                    continue
                for _id in set(tag3_ids):
                    tab_operates_objects.append(
                        TabOperateV2TagV3(
                            tag_v3_id=_id,
                            tab_operate_v2_id=operate.id,
                        ))
                if len(tab_operates_objects) >= 200:
                    TabOperateV2TagV3.objects.bulk_create(tab_operates_objects)
                    tab_operates_objects = []
            TabOperateV2TagV3.objects.bulk_create(tab_operates_objects)
        elif content_type == 'polymer':
            polymers = Polymer.objects.filter(
                is_online=True
            ).order_by('id')
            polymertagv3_objects = []
            for polymer in polymers.iterator():
                old_tag_ids = list(PolymerTag.objects.using(settings.SLAVE_DB_NAME).filter(
                    polymer_id=polymer.id, is_online=True
                ).values_list('tag_id', flat=True))
                if not old_tag_ids:
                    continue
                tag3_ids = list(TagMapOldTag.objects.using(settings.SLAVE_DB_NAME).filter(
                    old_tag_id__in=old_tag_ids
                ).values_list('tag_id', flat=True))
                if not tag3_ids:
                    continue
                for _id in set(tag3_ids):
                    polymertagv3_objects.append(
                        PolymerTagV3(
                            tag_v3_id=_id,
                            polymer_id=polymer.id,
                        ))
                if len(polymertagv3_objects) >= 200:
                    PolymerTagV3.objects.bulk_create(polymertagv3_objects)
                    polymertagv3_objects = []
            PolymerTagV3.objects.bulk_create(polymertagv3_objects)

        elif content_type == 'group':
            groups = Group.objects.filter(
                is_online=True
            ).order_by('id')
            group_tag_objects = []
            for group in groups.iterator():
                old_tag_ids = list(GroupTag.objects.filter(
                    group_id=group.id, is_online=True
                ).values_list('tag_id', flat=True))
                if not old_tag_ids:
                    continue
                tag3_ids = list(TagMapOldTag.objects.using(settings.SLAVE_DB_NAME).filter(
                    old_tag_id__in=old_tag_ids
                ).values_list('tag_id', flat=True))
                if not tag3_ids:
                    continue
                for _id in set(tag3_ids):
                    group_tag_objects.append(
                        GroupTagV3(
                            tag_v3_id=_id,
                            group_id=group.id,
                        ))
                if len(group_tag_objects) >= 200:
                    GroupTagV3.objects.bulk_create(group_tag_objects)
                    group_tag_objects = []
            GroupTagV3.objects.bulk_create(group_tag_objects)

        print('Done! cost {} s'.format(time.time()-start))
