# coding: utf-8
import math
import time
import re
from rpc.tool.log_tool import user_transfer_logger
from multiprocessing import Manager
from django.core.management.base import BaseCommand
from django.contrib.auth.models import User
from django.db.models import Q, Max
from gm_types.gaia import LOGIN_AUTH_TYPE, USER_ACCOUNT_TYPE
from threadpool import ThreadPool, makeRequests
from api.models.user import UserExtra, PlatformUser

task_pool = ThreadPool(num_workers=4, poll_timeout=2)

queue = Manager().Queue(maxsize=4)
queue.put(1)  # 触发程序开始
args_list = []
w_sql = open("transfer_user_sql.sql", "w+")



def judge_third_user_id(auth_user_id):
    try:
        if re.match(r'^\d{11}$', auth_user_id):         #手机号
                return None

        if str(auth_user_id).startswith('wechat'):      #微信私信
                return USER_ACCOUNT_TYPE.WECHAT_PUB

        if str(auth_user_id).startswith('onhoFt'):      #微信
                return USER_ACCOUNT_TYPE.WECHAT

        if str(auth_user_id).startswith('owncIu'):      #微信小程序
                return USER_ACCOUNT_TYPE.WECHAT

        else:
            return 16
    except:
        user_transfer_logger.info(msg='auth_user_id=={auth_user_id} is failed'.format(auth_user_id=auth_user_id))
        return 16


def generate(t_args):
    queue = t_args.get("queue")
    extra_id = t_args.get("id")

    start_id = queue.get()
    limit = 200
    extra = UserExtra.objects.filter(Q(pk__gt=start_id, id__gt=extra_id))[: limit]. \
        values('user_id', 'auth_type')
    max_id = extra.aggregate(max_id=Max('id'))

    queue.put(max_id["max_id"])

    user_ids, p_users = [], {}
    for extra_item in extra:
        user_ids.append(extra_item.get('user_id'))
        e_type = extra_item.get('auth_type')
        if e_type == LOGIN_AUTH_TYPE.COUPON:
            e_type = LOGIN_AUTH_TYPE.phone

        if e_type == LOGIN_AUTH_TYPE.WechatSmall:
            e_type = LOGIN_AUTH_TYPE.Wechat
        p_users[extra_item.get('user_id')] = {'user_id': extra_item.get('user_id'), 'platform_type': e_type}
    users = User.objects.filter(id__in=user_ids).values('id', 'username')

    for user in users:
        _temp = p_users.get(user.get('id'))

        if _temp:
            p_users[user.get('id')].update({'platform_id': user.get('username')})

        if not _temp.get('platform_type'):
            user_name = judge_third_user_id(user.get('username'))
            if not user_name:
                continue
            elif user_name == 16:
                pass
            else:
                _temp['platform_type'] = user_name

    insert_sql = "INSERT INTO INSERT INTO api_platformuser(user_id,platform_type,platform_id) VALUES"
    for p_user in p_users:
        if p_users[p_user].get('platform_type') == LOGIN_AUTH_TYPE.phone:
            continue
        if not p_users[p_user].get('platform_type'):
            p_users[p_user]['platform_type'] = 0

        insert_sql += '({user_id}, {platform_type}, {platform_id}),'.format(user_id=p_user,
                                                                           platform_type=p_users[p_user].get('platform_type'),
                                                                           platform_id=p_users[p_user].get('platform_id'))

    insert_sql = insert_sql.strip(',')
    insert_sql += ';\n'
    w_sql.write(insert_sql)
    print(insert_sql)
    print("this thread max_id=", max_id.get('max_id'))


class Command(BaseCommand):

    def add_arguments(self, parser):
        parser.add_argument('user_id', nargs='?', type=int)

    def handle(self, *args, **options):
        extra_id = options.get('user_id') or 1

        print('------ starting -----')
        start_time = time.time()
        print("start at: ", start_time)
        per_num = 200
        count = UserExtra.objects.filter(id__gt=extra_id).count()
        cnt = int(math.ceil(count / per_num))
        for _ in range(cnt):
            #generate({"queue": queue, "id": extra_id})
            args_list.append({"queue": queue, "id": extra_id})

        print("len====", len(args_list))
        temp = makeRequests(generate, args_list=args_list)
        [task_pool.putRequest(req) for req in temp]
        task_pool.wait()

        end_time = time.time()
        print("last_user_id", queue.get())
        print("end at: ", end_time)
        print('total use {} s.'.format(end_time - start_time))
        print('Done!')
