# coding=utf-8
from django.conf import settings
from django.core.management import BaseCommand

from api.models.pushtask2 import PushUser


class Command(BaseCommand):
    """
    PushUser 更新is_read字段默认值  update_pushuser_default_value
    """

    def handle(self, *args, **options):
        print("START")
        start = 0
        offset = 1000
        queryset = PushUser.objects.raw(
            "select max(id) id from api_pushuser"
        )
        max_id = int(queryset[0].id) if queryset[0].id else 0
        print(max_id)
        while True:
            push_info = PushUser.objects.filter(id__gte=start, id__lte=start+offset, is_read=False)
            if not push_info and start > max_id:
                break
            if push_info:
                push_info.update(is_read=True)
            start += 1000

        print("DONE")
