# -*- coding: utf-8 -*-
import datetime

from django.conf import settings
from django.db import models
from gm_types.artemis import ACCREDIT_TYPE, ACCREDIT_TIMES_TYPE, ACCREDIT_STATUS


class BaseModel(models.Model):
    class Meta:
        abstract = True

    created_time = models.DateTimeField(verbose_name=u'添加时间', auto_now_add=True)
    modify_time = models.DateTimeField(verbose_name=u'最后更新时间', auto_now=True)


class CPTWhiteList(BaseModel):
    class Meta:
        db_table = 'advertise_cptwhitelist'
        verbose_name = 'CPT商户授权白名单'

    objects = models.Manager().db_manager(using=settings.ARTEMIS_DB_NAME)

    doctor_id = models.CharField(max_length=100, verbose_name=u'医生ID')
    reason = models.CharField('授权原因', max_length=256)
    start_time = models.DateTimeField('开始时间')
    end_time = models.DateTimeField('结束时间')
    comment = models.CharField('备注', max_length=256, default='', null=True)
    enable = models.BooleanField(default=True, verbose_name=u'是否授权')
    accredit_type = models.IntegerField('授权方式', choices=ACCREDIT_TYPE, default=ACCREDIT_TYPE.CPT)
    accredit_times_type	= models.IntegerField('次数限制类型', choices=ACCREDIT_TIMES_TYPE, default=ACCREDIT_TIMES_TYPE.NO_LIMIT)
    accredit_times = models.IntegerField('授权次数', default=0, null=True)
    status = models.CharField('授权状态', default=ACCREDIT_STATUS.CANCEL, null=True, max_length=20)

    def get_status(self):
        if not self.enable:
            return ACCREDIT_STATUS.CANCEL
        now = datetime.datetime.now()
        if now < self.start_time:
            return ACCREDIT_STATUS.PRE
        elif now < self.end_time:
            return ACCREDIT_STATUS.ING
        else:
            return ACCREDIT_STATUS.DONE