#! /usr/bin/env python
# -*- coding: utf-8 -*-

from django.db import models
from gm_upload import ImgUrlField, IMG_TYPE


class PlasticTemplate(models.Model):
    class Meta:
        verbose_name = u'整形模板'
        db_table = 'api_plastic_template'

    face_style = models.CharField(verbose_name=u"脸型维度描述", max_length=200, default='')
    face_style_desc = models.CharField(verbose_name=u"脸型描述", max_length=200, default='') # 废弃
    fenggelian = models.CharField(verbose_name=u"风格脸", max_length=200, default='')
    shoulian = models.IntegerField(verbose_name=u"瘦脸", default=0)
    zhailian = models.IntegerField(verbose_name=u"窄脸", default=0)
    xiaolian = models.IntegerField(verbose_name=u"小脸", default=0)
    dayan = models.IntegerField(verbose_name=u"大眼", default=0)
    yanjiaodu = models.IntegerField(verbose_name=u"眼角度", default=0)
    shouquangu = models.IntegerField(verbose_name=u"瘦颧骨", default=0)
    shouxiahegu = models.IntegerField(verbose_name=u"瘦下颌骨", default=0)
    shoubi = models.IntegerField(verbose_name=u"瘦鼻", default=0)
    changbi = models.IntegerField(verbose_name=u"长鼻", default=0)
    xiaba = models.IntegerField(verbose_name=u"下巴", default=0)
    etou = models.IntegerField(verbose_name=u"额头", default=0)
    zuixing = models.IntegerField(verbose_name=u"嘴型", default=0)
    weixiao = models.IntegerField(verbose_name=u"微笑", default=0)
    yanju = models.IntegerField(verbose_name=u"眼距", default=0)
    yanyidong = models.IntegerField(verbose_name=u"眼移动", default=0)
    suorenzhong = models.IntegerField(verbose_name=u"缩人中", default=0)
    heiyanquan = models.IntegerField(verbose_name=u"黑眼圈", default=0)
    falingwen = models.IntegerField(verbose_name=u"法令纹", default=0)
    created_time = models.DateTimeField(u'创建时间', auto_now_add=True)
    updated_time = models.DateTimeField(u'更新时间', auto_now=True)

    def detail(self):
        return {
            "face_style": self.face_style,
            "fenggelian":self.fenggelian,
            "shoulian":self.shoulian,
            "zhailian":self.zhailian,
            "xiaolian":self.xiaolian,
            "dayan": self.dayan,
            "yanjiaodu": self.yanjiaodu,
            "shouquangu": self.shouquangu,
            "shouxiahegu": self.shouxiahegu,
            "shoubi": self.shoubi,
            "changbi": self.changbi,
            "xiaba": self.xiaba,
            "etou": self.etou,
            "zuixing": self.zuixing,
            "weixiao": self.weixiao,
            "yanju": self.yanju,
            "yanyidong": self.yanyidong,
            "suorenzhong": self.suorenzhong,
            "heiyanquan": self.heiyanquan,
            "falingwen": self.falingwen,
        }


class AppealCard(models.Model):
    class Meta:
        verbose_name = u'模拟整形诉求卡片'
        db_table = 'api_plastic_appeal_card'

    appeal_tag_id = models.IntegerField(verbose_name=u"二级诉求标签id", default=0)
    similar_star_name = models.CharField(verbose_name=u"相似明星姓名", max_length=20, default='')
    similar_star_image = ImgUrlField(u'图片', img_type=IMG_TYPE.HOMESLIDE, max_length=200, default='')
    cost_range = models.CharField(verbose_name=u"价格区间", max_length=25, default='')

    created_time = models.DateTimeField(u'创建时间', auto_now_add=True)
    updated_time = models.DateTimeField(u'更新时间', auto_now=True)
    is_online = models.BooleanField(u'是否上线', default=False)

    def detail(self):
        return {
            "appeal_tag_id": self.appeal_tag_id,
            "similar_star_name": self.similar_star_name,
            "similar_star_image": self.similar_star_image,
            "cost_range": self.cost_range,
        }
