# -*- coding: utf-8 -*-
from django.db import models
from gm_upload import ImgUrlField, IMG_TYPE


class AiFeedKyc(models.Model):
    class Meta:
        verbose_name = u'ai频道页kyc'
        db_table = 'api_ai_feed_kyc'

    user_id = models.IntegerField(verbose_name=u"用户id", db_index=True)
    device_id = models.CharField(verbose_name=u"设备id", max_length=128, db_index=True)
    image_url = ImgUrlField(img_type=IMG_TYPE.TOPICIMAGE, max_length=300, verbose_name=u'图片地址')
    face_shape = models.CharField(verbose_name=u"脸型关键词", max_length=64)
    face_style = models.CharField(verbose_name=u"喜欢的脸部风格:", max_length=64)
    face_feature = models.CharField(verbose_name=u"五官关键词:", max_length=64)
    created_time = models.DateTimeField(u'创建时间', auto_now_add=True)
    updated_time = models.DateTimeField(u'更新时间', auto_now=True)
