# -*- coding: utf-8 -*-
from datetime import date

from django.db import models
from django.utils import timezone
from gm_upload import ImgUrlField, IMG_TYPE
from gm_types.gaia import QUERY_OPERATION_TYPE

from api.tool.datetime_tool import get_timestamp


class QueryOperation(models.Model):
    class Meta:
        verbose_name = u'搜索运营位'
        db_table = 'api_query_operation'
        app_label = 'api'

    type = models.IntegerField(verbose_name=u"类型", choices=QUERY_OPERATION_TYPE)
    icon = ImgUrlField(
        img_type=IMG_TYPE.CAMPAIGNIMAGELINK, max_length=256, verbose_name=u'icon图片')
    button_icon = ImgUrlField(
        img_type=IMG_TYPE.CAMPAIGNIMAGELINK, max_length=256, verbose_name=u'按钮图片')
    titile = models.CharField(max_length=256, verbose_name="内容标题", default='')
    desc = models.CharField(max_length=256, verbose_name=u"描述文案", default='')
    gm_url = models.CharField(max_length=256, verbose_name=u"更美协议", default='')
    rank = models.IntegerField(verbose_name=u"权重", default=0)
    start_time = models.DateTimeField(verbose_name=u'生效时间', default=date.min)
    end_time = models.DateTimeField(verbose_name=u'失效时间', default=date.max)

    is_online = models.IntegerField(verbose_name=u"是否上线", null=False, default=0)

    create_time = models.DateTimeField(verbose_name=u'创建时间', default=timezone.now)
    update_time = models.DateTimeField(verbose_name=u'更新时间', default=timezone.now)

    def detial(self):

        return {
            "id": self.id,
            "type": self.type,
            "icon": self.icon,
            "button_icon": self.button_icon,
            "is_online": self.is_online,
            "title": self.titile,
            "desc": self.desc,
            "rank": self.rank,
            "gm_url": self.gm_url,
            "start_time": u"" if self.start_time.date() == date.min else get_timestamp(self.start_time),
            "end_time": u"" if self.end_time.date() == date.max else get_timestamp(self.end_time),
        }


class QueryOperationWord(models.Model):
    class Meta:
        verbose_name = u'运营位搜索词'
        db_table = 'api_query_operation_word'
        app_label = 'api'

    word = models.CharField(max_length=80, verbose_name=u"搜索词", default="")
    operation_id = models.IntegerField(verbose_name=u"搜索运营位id", default=0)

    create_time = models.DateTimeField(verbose_name=u'创建时间', default=timezone.now)
    update_time = models.DateTimeField(verbose_name=u'更新时间', default=timezone.now)



