# -*- coding: utf-8 -*-
from django.db import models
from django.utils import timezone
from gm_upload import ImgUrlField, IMG_TYPE
from cached_property import cached_property
from agile.models.tag import TagV3
import logging
import traceback


class SpecialPool(models.Model):
    class Meta:
        verbose_name = u'专题池'
        db_table = 'api_special_pool'
        app_label = 'api'

    name = models.CharField(max_length=80, verbose_name=u"名称", null=True)
    home_feed_cover_image = ImgUrlField(
        img_type=IMG_TYPE.CAMPAIGNIMAGELINK, max_length=128, verbose_name=u'首页feed封面图')
    detail_cover_image = ImgUrlField(
        img_type=IMG_TYPE.CAMPAIGNIMAGELINK, max_length=128, verbose_name=u'详情页封面图')
    visual_page_id = models.IntegerField(verbose_name=u"可视化页面ID", default=0)
    callback_for_ai = models.BooleanField(verbose_name=u"是否AI召回", default=False)
    is_online = models.BooleanField(verbose_name=u"是否上线", default=True)
    order = models.IntegerField(verbose_name=u"展示权重", default=999999)
    a_position_image = ImgUrlField(
        img_type=IMG_TYPE.CAMPAIGNIMAGELINK, max_length=128, verbose_name=u'A位置尺寸图：（335*344px）')
    b_position_image = ImgUrlField(
        img_type=IMG_TYPE.CAMPAIGNIMAGELINK, max_length=128, verbose_name=u'B位置尺寸图：（335*156px）')
    c_d_position_image = ImgUrlField(
        img_type=IMG_TYPE.CAMPAIGNIMAGELINK, max_length=128, verbose_name=u'C/D位置尺寸图：（168*188px）')
    created_time = models.DateTimeField(verbose_name=u'创建时间', default=timezone.now)
    update_time = models.DateTimeField(verbose_name=u'更新时间', default=timezone.now)

    @cached_property
    def get_tag_ids(self):
        try:
            tag_ids = list(
                set(SpecialPoolRelationTag.objects.filter(special_pool_id=self.id, is_deleted=False).values_list(
                    "project_tag_id", flat=True)))
            return tag_ids
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return []

    @cached_property
    def get_tag_names(self):
        try:
            info_tag = list()
            tag_ids = list(
                set(SpecialPoolRelationTag.objects.filter(special_pool_id=self.id, is_deleted=False).values_list(
                    "project_tag_id", flat=True)))
            tag_names = list(set(TagV3.objects.filter(id__in=tag_ids, is_online=True).values_list("name", flat=True)))
            from agile.services.tag import gets_nomal_dict
            for item in tag_ids:
                tag_type = TagV3.objects.filter(id=item, is_online=True).values_list("tag_type", flat=True).first()
                all_tag_dict = gets_nomal_dict(tags_ids=[item], tag_type=tag_type)
                ###获取名称
                info_tag.extend(all_tag_dict.get("first_classify_names", []))
                info_tag.extend(all_tag_dict.get("first_demands", []))
                info_tag.extend(all_tag_dict.get("second_classify_names", []))
                info_tag.extend(all_tag_dict.get("second_demands", []))
                info_tag.extend(all_tag_dict.get("first_solutions", []))
                info_tag.extend(all_tag_dict.get("second_solutions", []))
                info_tag.extend(all_tag_dict.get("first_positions", []))
                info_tag.extend(all_tag_dict.get("second_positions", []))
                info_tag.extend(all_tag_dict.get("project_tags", []))

            return tag_names, info_tag
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return [], []


class SpecialPoolRelationTag(models.Model):
    class Meta:
        verbose_name = u'专题池关联标签'
        db_table = 'api_special_pool_relation_tag'
        app_label = 'api'

    special_pool_id = models.IntegerField(verbose_name=u"专题池ID", default=0)
    project_tag_id = models.IntegerField(verbose_name=u"项目标签ID", default=0)
    is_deleted = models.BooleanField(verbose_name=u"是否删除", default=False)
    created_time = models.DateTimeField(verbose_name=u'创建时间', default=timezone.now)
    update_time = models.DateTimeField(verbose_name=u'更新时间', default=timezone.now)
