# coding=utf-8
from django.db import models


class PushGiftRecord(models.Model):
    class Meta:
        verbose_name = u'授权接收push后领取礼包的记录'
        db_table = 'api_push_gift_record'

    user_id = models.IntegerField(verbose_name=u'用户id', db_index=True)
    gift_id = models.IntegerField(verbose_name=u'礼包id')

    create_time = models.DateTimeField(verbose_name='创建时间', auto_now_add=True)
    update_time = models.DateTimeField(verbose_name='最后更新时间', auto_now=True)
