# -*- coding=utf-8
from django.db import models
from django.contrib.auth.models import User
from .area import  City, Region
from .tag import Tag
from gm_types.push import (
    PUSH_USER_TYPE2,
    HERA_PUSH_TYPE2,
    SEND_STATUS,
    HERA_PUSH_PLATFORM,
)



class PushTask2(models.Model):
    '''
        推送任务
    '''
    class Meta:
        verbose_name = u'消息推送2'
        verbose_name_plural = u'消息推送2'
        db_table = 'api_pushtask2'
        app_label = 'api'

    jiguang_id=models.CharField(verbose_name=u'极光ID',max_length=128,null=True)
    task_id=models.CharField(verbose_name=u'任务ID',max_length=128,null=True)
    heading = models.CharField(verbose_name=u'主标题',max_length=512, null=True)
    subheading = models.CharField(verbose_name=u'副标题',max_length=512,null=False)

    image = models.URLField(verbose_name='image', blank=True, default='')
    push_image = models.URLField(verbose_name='push_image', blank=True, null=True, default='')
    platform=models.CharField(verbose_name="推送平台",max_length=64,choices=HERA_PUSH_PLATFORM)
    pushtype=models.CharField(verbose_name="推送类型",max_length=256,choices=HERA_PUSH_TYPE2)

    pushvalue=models.CharField(verbose_name="推送值",max_length=512)
    linkid=models.CharField(verbose_name="推送类型参数",max_length=512)
    url=models.CharField(verbose_name="推送url",max_length=512)

    pushtime = models.DateTimeField(verbose_name=u'推送时间', blank=True, null=True, default=None)
    pushtags=models.ManyToManyField(Tag, verbose_name=u'推送tag')

    region = models.ManyToManyField(Region, verbose_name=u'推送大区列表')
    city = models.ManyToManyField(City, verbose_name=u'推送城市列表')
    usertype = models.IntegerField(verbose_name=u'推送用户类型', default=0,choices=PUSH_USER_TYPE2)


    creator = models.ForeignKey(User, verbose_name=u'创建的用户',related_name=u'creatord', blank=True,null=True, default=None)
    approver = models.ForeignKey(User, verbose_name=u'审核通过的用户',related_name=u'approverd',blank=True, null=True, default=None)
    approver_status=models.BooleanField(verbose_name=u'审核状态',default=False)

    online=models.BooleanField(verbose_name='是否上线',default=True)
    showname=models.BooleanField(verbose_name='是否展示用户名',default=False)
    message=models.CharField(verbose_name='定制消息',default='',max_length=512)

    status= models.CharField(verbose_name=u'推送状态',max_length=64,choices=SEND_STATUS)
    created_time = models.DateTimeField(verbose_name=u'创建时间', auto_now_add=True)
    # 营销标签
    market_id = models.TextField(verbose_name=u'营销标签id列表')

    def get_item_data(self):
        """获取model具体数据"""
        return {
            'id': self.id,
            'heading': self.heading,
            'subheading': self.subheading,
            'create_time': self.pushtime.strftime('%Y-%m-%d  %H:%M:%S'),
            'img': self.image,
            'jump_url': self.jump_url,
            'imgheader': self.imgheader_v2,
        }



class PushUser(models.Model):
    '''
        推送用户列表
    '''
    pushtask=models.ForeignKey(PushTask2,verbose_name="关联任务")
    user=models.CharField(verbose_name='用户ID',null=False,max_length=256)
    device=models.CharField(verbose_name='设备号',null=False,max_length=256)
    is_all=models.BooleanField(verbose_name='是否全量',default=False)
    # 全量push的 is_read字段只是一个标识，7140版本之后的新全量push is_read=False
    is_read = models.BooleanField(verbose_name=u'用户是否已读', default=False)


class PushReadLog(models.Model):
    """
    全量推送已读数据记录
    """
    class Meta:
        verbose_name = u'push已读数据记录(全量push)'
        db_table = 'api_pushreadlog'

    push_task_id = models.IntegerField(verbose_name=u'关联任务id', db_index=True)
    create_time = models.DateTimeField(auto_now_add=True)
    update_time = models.DateTimeField(auto_now=True)
    user_id = models.IntegerField(verbose_name=u'已读用户id', db_index=True)

