# -*- coding:utf-8 -*-
'''
搜索导航页话题聚合配置
'''

import datetime

from django.db import models

from api.models import base_model


class TopicAggregation(base_model.BaseModel):
    class Meta:
        verbose_name = u'搜索导航页话题聚合配置'
        db_table = 'api_topic_aggregation'
        app_label = 'api'

    title = models.CharField(verbose_name=u'标题', max_length=255, null=False)
    img_url = models.CharField(verbose_name=u'图片url', max_length=255, null=False)
    position = models.IntegerField(verbose_name=u'位置', max_length=8, null=False)
    aggregate_id = models.IntegerField(verbose_name=u'聚合页id', default=0)
    related_url = models.CharField(verbose_name=u'关联打卡URL', max_length=255, null=False)
    topic_id = models.IntegerField(verbose_name=u'话题id', default=0)
    group_id = models.IntegerField(verbose_name=u'小组id', default=0)

    success_time = models.DateTimeField(verbose_name=u'生效时间', db_index=True)
    failure_time = models.DateTimeField(verbose_name=u'失效时间', db_index=True)
