#!/usr/bin/env python
# -*- coding:utf-8 -*-
#
#   Author  :   RobertDing
#   E-mail  :   robertdingx@gmail.com
#   Date    :   18/04/18 13:57:53
#   Desc    :   数据组统计数据
#

from django.conf import settings
from django.db.models import Model, Manager
from django.db.models import BigIntegerField, DateField


class MerchantStatDaily(Model):
    class Meta:
        verbose_name = '商户每日统计数据'
        db_table = 'al_merchant_stat_updates'

    objects = Manager().db_manager(using=settings.DOCTOR_TRAFFIC_DB)

    date = DateField('统计日期')
    merchant_id = BigIntegerField('商家ID')

    service_pv = BigIntegerField('美购详情页PV', default=0)
    home_pv = BigIntegerField('医生主页PV+医院主页PV', default=0)
    diary_pv = BigIntegerField('日记本详情页PV+日记帖详情页PV', default=0)

    ad_recharge = BigIntegerField('广告充值金额', default=0)
    ad_consume = BigIntegerField('广告消耗金额', default=0)
    offline_amount = BigIntegerField('财务确认的线下打款金额', default=0)

    validated_price = BigIntegerField('验证订单总价（更美价)', default=0)
    validated_discount = BigIntegerField('验证订单抽成', default=0)
    validated_price_user = BigIntegerField('纯用户验证订单总价（更美价）', default=0)
