# coding=utf8

from __future__ import unicode_literals, absolute_import, print_function
from django.db import models
from gm_upload import ImgUrlField, IMG_TYPE
from api.models.service import Service


class WaterMark(models.Model):
    class Meta:
        verbose_name = u'促销标签'
        db_table = 'api_watermark'
        app_label = 'api'

    name = models.CharField(verbose_name='标签名称', max_length=100)
    image_url = ImgUrlField(img_type=IMG_TYPE.SERVICE_WATERMARK, max_length=256, help_text=u"标签腿片url")
    start_time = models.DateTimeField(verbose_name='开始时间')
    end_time = models.DateTimeField(verbose_name='结束时间')
    services = models.ManyToManyField(Service, verbose_name='关联美购', through='WaterMarkService')


class WaterMarkService(models.Model):
    class Meta:
        verbose_name = '促销标签美购'
        db_table = 'api_watermarkservice'
        app_label = 'api'
    watermark = models.ForeignKey(WaterMark)
    service = models.ForeignKey(Service)
