# -*- coding: UTF-8 -*-
from celery import shared_task
from datetime import datetime
from django.db.models import Max
from hera.management.commands.utils import get_mail

from api.models import Person
from api.management.commands.create_fake_user import create_users_new


@shared_task
def create_fake_users(to_user_emails, num):

    max_phone = Person.objects.filter(phone__gte='10000000000', phone__lte='11000000000').aggregate(Max('phone'))[
        "phone__max"]
    export_book = create_users_new(start=max_phone, num=num)
    create_time = datetime.now().strftime('%Y_%m_%d_%H_%M_%S')
    sub = u'{}新增马甲用户.xlsx'.format(create_time)
    body = u'{}新增马甲用户.xlsx'.format(create_time)
    get_mail(sub, body, to_user_emails, export_book.xlsx).send()
