# -*- coding: utf-8 -*-
from talos.models.diary.diary import CpcCommunity
import logging
import traceback
from django.conf import settings
from celery import shared_task
from trans2es.type_info import get_type_info_map
from gaia.routers import thread_local


@shared_task
def diary_is_cpc_write_toes():
    try:
        pk_list = list(CpcCommunity.objects.using(settings.ARTEMIS_DB_NAME).values_list("related_id", flat=True))
        configuration = None
        use_batch_query_set = False
        es_config = None
        pk_list = list(frozenset(pk_list))
        type_info_map = get_type_info_map()
        type_info = type_info_map["diary"]
        type_info.insert_table_by_pk_list(
            index_prefix=settings.ES_INDEX_PREFIX,
            pk_list=pk_list,
            use_batch_query_set=use_batch_query_set,
            es_config=es_config
        )
        logging.info("diary_is_cpc_write_toes down")
    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
