# coding=utf-8

from celery import shared_task

from rpc.context import get_rpc_remote_invoker
from relation.models import UserTagRelation


@shared_task
def user_tag_relation_change(user):
    """
    当用户所关注的Tag发生变化的时候，全量更新用户关联的Jpush tag。
    :param user: 用户
    :return:
    """
    tag_ids = UserTagRelation.objects.values_list('related_tag_id', flat=True).filter(user=user)
    rpc_invoker = get_rpc_remote_invoker()
    rpc_invoker['push2/bind/user/user_id/tag'](
        user_id=user.id,
        tags=list(tag_ids)
    ).unwrap()




