# coding=utf-8

import django
from django.db.models import Q

from api.models import User
from api.tool.log_tool import logging_exception
from rpc.context import get_rpc_remote_invoker

from talos.models.live.live import LiveChannel


# TODO: talos migrate, add func for this
def get_or_create_channel_by_user_id(user_id):
    try:
        user = User.objects.get(id=user_id)
        channel, _ = LiveChannel.objects.get_or_create(
            person_id=user.person.id.hex,
            user_id=user_id
        )
        return channel
    except django.db.IntegrityError:
        channel = LiveChannel.objects.get(person_id=user.person.id.hex)
        return channel


def get_person_live_count(user_id):
    try:
        r = get_rpc_remote_invoker()
        result = r['mimas/live/get_person_live_count'](user_id=user_id).unwrap()
        return result
    except:
        logging_exception()
