# coding: utf-8
import copy

from django.conf import settings
from django.db import transaction
from gm_types.gaia import PLATFORM_CHANNEL
from gm_types.gaia import REQUEST_SOURCE

import point
from api.models import (
    RecommendApp,
    PLATFORM_CHOICES,
    AppStat,
    POINTS_TYPE,
    UpdatePop,
)
from api.models import TabConfigDeploy
from api.tool.user_tool import get_user_from_context
from rpc.api_control import request_source
from rpc.decorators import bind, bind_context
from services.custom_phone_service import Phone400Service


@bind_context('api/view/app/list')
def get_recommend_app_list(ctx, platform=None):
    """
    Function 推荐app列表
    :param ctx:
    :return:
    """
    apps = RecommendApp.objects.filter(platform=platform, is_online=True)
    messages = []
    for app in apps:
        messages.append(app.as_dict())

    return messages


@bind_context('api/view/app/get_by_download_app')
def get_recommend_app_detail(ctx, app_id=-1):
    """
    Function 推荐app 下载链接
    :param ctx:
    :return:
    """
    try:
        app = RecommendApp.objects.get(id=app_id, is_online=True)
        app_info = app.as_dict()
    except RecommendApp.DoesNotExist:
        app_info = {}

    user = get_user_from_context(ctx)
    if user:
        try:
            exist = True
            appstat = AppStat.objects.get(user=user, recommend_app=app)
        except AppStat.DoesNotExist:
            exist = False

        if not exist:
            with transaction.atomic():
                appstat = AppStat()
                appstat.user = user
                appstat.recommend_app = app
                appstat.save()

                point.add(user_id=user.id, reason=POINTS_TYPE.APP)

    return app_info


@bind('api/app/update_info')
def get_app_update_info(platform):
    """
    客户端更新信息
    """
    if platform == PLATFORM_CHOICES.IPHONE:
        source = PLATFORM_CHANNEL.IOS
    else:
        source = PLATFORM_CHANNEL.ANDROID
    try:
        app = UpdatePop.objects.filter(source=source).order_by('-code')[0]
        result = app.get_update_info()
    except:
        result = {}

    return result


@bind('api/app/customer_hotline')
def get_customer_hotline():
    """
    客服电话
    :return:
    """
    service = Phone400Service.get_service_by_vendor(settings.DEFAULT_400_VENDOR)
    return service.account


@bind_context('api/tool/slide_tab')
def get_slide_tab(ctx):
    """原始图像后面加－tab即为2X"""
    req_source = request_source.__dict__.get('req_source', REQUEST_SOURCE.GEMGMEI)
    rkey = 'tabconfigdeploy'
    if req_source == REQUEST_SOURCE.SHEQU:
        rkey = 'tabconfigdeploy{}'.format(req_source)
    ori_3x = TabConfigDeploy.get_deploy(rkey=rkey)
    tab_2x = []
    tab_3x = []
    for con in ori_3x:
        if con.values() == [''] * 4:
            tab_3x.append({})
            tab_2x.append({})
        else:
            con_2x = copy.deepcopy(con)
            con_2x['icon_normal'] = con['icon_normal'] + '-tab' if con['icon_normal'] else ''
            con_2x['icon_pressed'] = con['icon_pressed'] + '-tab' if con['icon_pressed'] else ''
            tab_2x.append(con_2x)
            tab_3x.append(con)
    data = {
        'INDEX_TAB_CONFIG': tab_3x,
        'INDEX_TAB_CONFIG_2X': tab_2x,
    }
    return data

