# coding:utf-8

import json
import time

from django.conf import settings

from gm_types.gaia import SLIDE_TYPE

from rpc.cache import personal_slide_cache


def same_city_group(city_id, show_version):
    """同城小组"""

    data = personal_slide_cache.hget("same_city_group:{}".format(show_version), city_id)
    if data:
        return json.loads(data)

    return {}


def same_city_toprank_doctor(city_id, show_version):
    """医生榜单"""
    img = personal_slide_cache.hget("same_city_toprank_doctor:{}".format(show_version), city_id)
    if not img:
        return

    return {"img": img}


def same_city_toprank_hospital(city_id, show_version):
    """机构榜单"""
    img = personal_slide_cache.hget("same_city_toprank_hospital:{}".format(show_version), city_id)
    if not img:
        return

    return {"img": img}


def same_city_clinical_doctor(city_id, show_version):
    """视频面诊"""
    img = personal_slide_cache.hget("same_city_clinical_doctor:{}".format(show_version), city_id)
    if not img:
        return

    return {"img": img}


def same_city_kuaishang(city_id, show_version):
    """人工咨询"""
    img = personal_slide_cache.hget("same_city_kuaishang:{}".format(show_version), city_id)
    if not img:
        return

    return {"img": img}


def same_city_new_user_skill(city_id, show_version):
    """新人秒杀"""
    img = personal_slide_cache.hget("same_city_new_user_skill:{}".format(show_version), city_id)
    if not img:
        return

    return {"img": img}


personal_slide = [
    {
        "id": -1,
        "title": "同城小组",
        "business_type": "",
        "service_type": "",
        "target_id": 10,
        "slide_type": SLIDE_TYPE.GROUP,
        "url": "",
    },
    {
        "id": -1,
        "title": "机构榜单",
        "business_type": "",
        "service_type": "",
        "target_id": "",
        "slide_type": SLIDE_TYPE.TOPRANK_HOSPITAL,
        "url": "",
    },
    {
        "id": -1,
        "title": "医生榜单",
        "business_type": "",
        "service_type": "",
        "target_id": "",
        "slide_type": SLIDE_TYPE.TOPRANK_DOCTOR,
        "url": "",
    },
    {
        "id": -1,
        "title": "视频面诊",
        "business_type": "",
        "service_type": "",
        "target_id": "",
        "slide_type": SLIDE_TYPE.CLINICAL_DOCTOR,
        "url": "",
    },
    {
        "id": -1,
        "title": "新人1元",
        "business_type": "",
        "service_type": "",
        "target_id": "",
        "slide_type": SLIDE_TYPE.URL,
        "url": "https://backend.igengmei.com/phantom/visual_special/584",
    },
    {
        "id": -1,
        "title": "人工咨询",
        "business_type": "",
        "service_type": "",
        "target_id": "",
        "slide_type": SLIDE_TYPE.TRANSFER_CONSULTANT,
        "url": "",
    },
]


def get_person_slide(city_id, show_version):

    funcs = [
        same_city_group,
        same_city_toprank_hospital,
        same_city_toprank_doctor,
        same_city_clinical_doctor,
        same_city_new_user_skill,
        same_city_kuaishang,
    ]

    slides = []
    for idx, func in enumerate(funcs):
        data = func(city_id, show_version)
        if not data:
            continue

        img = data["img"]
        target_id = data.get("target_id", "")

        img_url = settings.QINIU_HERAS_CND_HOST + img + "?t={}".format(int(time.time()))
        data = personal_slide[idx]
        data.update({
            "slide_img": img_url,
            "app_new_slide_img": img_url,
            "new_slide_img": img_url,
            "slide_img_big": img_url,
            "ordering": idx,
            "target_id": target_id,
        })
        slides.append(data)

    return slides
