# coding: utf-8
from gm_types.gaia import TAG_V3_TYPE
from collections import defaultdict

from django.forms import model_to_dict

from rpc.decorators import bind

from api.models.face.plastic import PlasticTemplate
from api.models.face.cheek_style import (CheekStyleClassifyMap, CheekStyleExtra, CheekStyleAppealExtra,
                                         CheekStyleClassify, CheekStyle)
from agile.services import TagV3Service


@bind("api/plastic/template_parameter")
def template_parameter(face_style, cheek_style_classify_id):
    cheek_style_ids = list(CheekStyleClassifyMap.objects.filter(cheek_style_classify_id=cheek_style_classify_id,
                                                                is_online=True).values_list("cheek_style_id",
                                                                                            flat=True))

    plastic_templates = PlasticTemplate.objects.filter(face_style=face_style, fenggelian__in=cheek_style_ids)

    return {plastic_template.fenggelian: plastic_template.detail() for plastic_template in plastic_templates}


@bind("api/plastic/plastic_extra_info")
def plastic_extra_info(cheek_style_classify_id):
    cheek_style_ids = list(CheekStyleClassifyMap.objects.filter(cheek_style_classify_id=cheek_style_classify_id,
                                                                is_online=True).values_list("cheek_style_id",
                                                                                            flat=True))

    cheek_style_extra_objs = CheekStyleExtra.objects.filter(cheek_style_id__in=cheek_style_ids)
    cheek_style_appeal_extra_objs = CheekStyleAppealExtra.objects.filter(cheek_style_id__in=cheek_style_ids)
    cheek_style_extra_info = {str(obj.cheek_style_id): model_to_dict(obj) for obj in cheek_style_extra_objs}
    cheek_style_appeal_extra_info = defaultdict(dict)

    for obj in cheek_style_appeal_extra_objs:
        cheek_style_appeal_extra_info[str(obj.cheek_style_id)][obj.appeal_tag_name] = model_to_dict(obj)

    return {
        "cheek_style_extra_info": cheek_style_extra_info,
        "cheek_style_appeal_extra_info": cheek_style_appeal_extra_info
    }


@bind("api/ai/tag_infos")
def api_plastic_tag_infos(tag_names, tag_type=TAG_V3_TYPE.NORMAL):
    tag_v3_infos = TagV3Service.get_tag_v3_info_by_names(tag_names, tag_type)

    tag_name2tag_info = {tv3["name"]: {"id": tv3["id"], "name": tv3["name"]} for tv3 in tag_v3_infos}
    return tag_name2tag_info


@bind("api/plastic/cheek_style_classify")
def cheek_style_classify():
    
    cheek_style_ids = CheekStyle.objects.filter(is_online=True).values_list("id", flat=True)
    cheek_style_classify_ids = CheekStyleClassifyMap.objects.filter(cheek_style_id__in=cheek_style_ids,
                                                                    is_online=True).values_list(
        "cheek_style_classify_id", flat=True)

    return list(
        CheekStyleClassify.objects.filter(id__in=cheek_style_classify_ids,
                                          is_online=True).order_by('rank').values("id", "name"))
