# coding: utf-8
from api.models.face.cheek_style import CheekStyleClassifyMap, CheekStyleClassify
from api.services.face.plastic import (
	CheekStyleService,
	CheekStyleSampleService,
	PercentDefinitionsService,
	FeatureWeightValueService,
)
from rpc.decorators import bind


@bind('api/plastic/cheek_styles')
def query_plastic_cheek_styles():
	"""获取模拟整形风格脸数据"""
	cs = CheekStyleService()
	cheek_styles = cs.query_cheek_styles_all()
	result = {"data": cheek_styles}
	return result


@bind('api/plastic/percent_definitions')
def query_plastic_percent_definitions():
	"""获取模拟整形 关键值 定义数据"""
	pds = PercentDefinitionsService()
	result = pds.gold_percents(is_online=True)
	return {"data": result}


@bind("api/plastic/secondary_demands")
def query_plastic_secondary_demands():
	fwv_service = FeatureWeightValueService()
	data = fwv_service.query_feature_weight_values()
	return {"data": data}


@bind("api/plastic/cheek_style_classify_map")
def query_cheek_style_classify_maps():
	"""获取模拟整形风格脸数据"""
	cs = CheekStyleService()
	cheek_style_classifys = cs.query_cheek_style_classify_maps()
	return {"data": cheek_style_classifys}


# 记录用户模拟整形的landmark
@bind("api/plastic/add_user_plastic_history")
def add_user_plastic_history(
		url_key,
		image_url,
		proportion,
		gold_values,
		megvii_landmark,
		byte_dance_landmark,
		user_id=0,
		device_id=0
):
	cheek_style_service = CheekStyleService()
	data = cheek_style_service.add_user_plastic_history(
		url_key,
		image_url,
		proportion,
		gold_values,
		megvii_landmark=megvii_landmark,
		byte_dance_landmark=byte_dance_landmark,
		user_id=user_id,
		device_id=device_id
	)
	return {"data": data}


# 根据device id 获取用户最后一次模拟整形的数据
@bind("api/plastic/get_last_user_plastic_history")
def get_last_user_plastic_history(device_id, user_id):
	cheek_style_service = CheekStyleService()
	data = cheek_style_service.get_last_user_plastic_history(
		user_id=user_id,
		device_id=device_id
	)
	return {"data": data}


# 记录用户模拟整形每个风格脸下的可行值
@bind("api/plastic/add_user_cheek_types_feasibility")
def add_user_cheek_types_feasibility(
		cheek_style_user_feasibility, user_plastic_history_id
):
	cheek_style_service = CheekStyleService()
	for cheek_style_feasibility in cheek_style_user_feasibility:
		cheek_style_service.add_user_cheek_types_feasibility(
			cheek_style_feasibility["id"],
			user_plastic_history_id,
			cheek_style_feasibility["feasibility"]
		)
	return {"data": "ok"}


# 风格脸列表，分页 搜索
@bind("api/plastic/query_cheek_styles")
def query_cheek_styles_do_page(page, page_size, name=None, cheek_style_id=None):
	"""
	{
		"data": {
			"gold_percent_values": [
				{
					"key": "",
					"value": 1
				}
			],
			"headers": [
				{
					"key": "",
					"name": "",
					"index": 1,
				}
			]

		}
	}
	"""
	cheek_style_service = CheekStyleService()
	data = cheek_style_service.page_cheek_styles(
		page, page_size, name, cheek_style_id
	)
	return data


# 单个风格脸信息获取
@bind("api/plastic/query_cheek_style")
def query_cheek_styles_do_page(cheek_style_id):
	cheek_style_service = CheekStyleService()
	data = cheek_style_service.query_one_cheek_styles(
		cheek_style_id
	)
	return data


# 风格脸 新增
@bind("api/plastic/add_cheek_styles")
def add_cheek_styles(name, image_url, is_online):
	cheek_style_service = CheekStyleService()
	data = cheek_style_service.add_new_cheek_style(
		name, image_url, is_online
	)
	if not data:
		return {"code": 1400, "error": "already existed", "message": u"风格脸名称已经存在"}
	return {"id": data}


# 更新风格脸信息或者 美学值
@bind("api/plastic/put_cheek_styles")
def update_cheek_style(
		cheek_style_id, name=None, image_url=None,
		is_online=None, key=None, value=None
):
	cheek_style_service = CheekStyleService()
	data = cheek_style_service.update_cheek_style_gold_values(
		cheek_style_id, name, image_url,
		is_online, key, value)
	if not data:
		return {"code": 1400, "error": "already existed", "message": u"风格脸名称已经存在"}
	return {"id": data}


# 获取其中一个风格脸信息
@bind("api/plastic/get_cheek_style")
def get_cheek_style(cheek_style_id):
	cheek_style_service = CheekStyleService()
	data = cheek_style_service.query_one_cheek_styles(
		cheek_style_id
	)
	if not data:
		return {"code": 1404, "error": "NOT_FOUND_CHEEK_STYLE", "message": u"风格脸不存在"}
	return data


# 获取风格脸样本列表
@bind("api/plastic/get_cheek_style_samples")
def get_cheek_style_samples(cheek_style_id, page=1, page_size=10):
	cheek_style_sample_service = CheekStyleSampleService()
	data = cheek_style_sample_service.get_cheek_style_samples(
		cheek_style_id, page=page, page_size=page_size
	)
	if not data:
		return {"code": 1404, "error": "NOT_FOUND_CHEEK_STYLE", "message": u"风格脸不存在"}
	return data


# 增加风格脸样本
@bind("api/plastic/add_cheek_style_sample")
def add_cheek_style_sample(cheek_style_id, image_url):
	cheek_style_sample_service = CheekStyleSampleService()
	data = cheek_style_sample_service.add_cheek_style_sample(
		cheek_style_id, image_url
	)
	return {"id": data}


# 写入风格脸样本的 美学值, 由gm_ai 调用接口计算而来
@bind("api/plastic/write_cheek_style_sample_value")
def write_cheek_style_sample_value(sample_id, gold_values):
	# gold_values = [{"gold_percent_define_id": 1, "percent_value": 1}]
	cheek_style_sample_service = CheekStyleSampleService()
	cheek_style_sample_service.update_cheek_style_sample_gold_value(
		sample_id, gold_values
	)
	return {"id": sample_id}


# 计算风格脸美学值 = 样本美学值的平均值
@bind("api/plastic/calculate_cheek_style_avg")
def calculate_cheek_style_avg(cheek_style_id):
	cs_service = CheekStyleService()
	result = cs_service.calculate_gold_values(cheek_style_id)
	if not result:
		return {"code": 1404, "error": "NOT_FOUND_CHEEK_STYLE", "message": u"风格脸不存在"}
	return result


# 删除风格脸样板库
@bind("api/plastic/delete_cheek_style_sample")
def delete_cheek_style_sample(cheek_style_id, sample_id):
	cheek_style_sample_service = CheekStyleSampleService()
	cheek_style_sample_service.delete_cheek_style_sample(cheek_style_id, sample_id)
	return {"sample_id": sample_id}


# 替换风格脸样本的图片
@bind("api/plastic/put_cheek_style_sample_values")
def put_cheek_style_sample_values(cheek_style_id, sample_id, image_url):
	cheek_style_sample_service = CheekStyleSampleService()
	result = cheek_style_sample_service.put_cheek_style_sample_values(
		cheek_style_id, sample_id, image_url)
	if not result:
		return {"code": 1404, "error": "NOT_FOUND_CHEEK_STYLE", "message": u"风格脸不存在"}
	if result == -1:
		return {"code": 1404, "error": "NOT_FOUND_CHEEK_STYLE_SAMPLE", "message": u"风格脸样本不存在"}
	return {"sample_id": sample_id}


# 获取风格脸 其中一个样本的美学值
@bind("api/plastic/get_cheek_style_sample_values")
def get_cheek_style_sample_value(cheek_style_id, sample_id):
	cheek_style_sample_service = CheekStyleSampleService()
	data = cheek_style_sample_service.cheek_style_sample_gold_values(
		cheek_style_id, sample_id
	)
	if data is None:
		return {"code": 1404, "error": "NOT_FOUND_CHEEK_STYLE_SAMPLE", "message": u"风格脸样本不存在"}
	else:
		if not data:
			return {"code": 1400, "error": "SAMPLE_NOT_CALCULATE", "message": u"样本计算未结束"}
		else:
			return {"gold_percent_values": data}


@bind("api/plastic/other_cheek_style_ids")
def other_cheek_style_ids_by_classify_id(classify_id, cheek_style_ids):
    cheek_style_ids = list(
        CheekStyleClassifyMap.objects.filter(cheek_style_id__in=cheek_style_ids).
            exclude(cheek_style_classify_id=classify_id).values_list("cheek_style_id", flat=True)
    )

    return cheek_style_ids


@bind("api/plastic/get_classify_id_by_rank")
def get_classify_id_by_rank(rank):
    classify_ids = list(CheekStyleClassify.objects.filter(
        rank=rank,
        is_online=True,
    ).values_list("id", flat=True))

    return classify_ids
