# coding=utf-8
from __future__ import unicode_literals, absolute_import, print_function

from datetime import datetime, timedelta

from django.conf import settings
from django.utils.html import strip_tags
from django.views.decorators.cache import cache_page
from gm_types.gaia import (
    TAG_TYPE,
    ZONE_TYPE_V2,
    OPTIMIZE_WIKI_TYPE,
    ZONE_DETAIL_SORT_TYPE,
    ZONE_DETAIL_TAB_TYPE,
    DIARY_ORDER_TYPE,
    SERVICE_ORDER_TYPE,
    TOPIC_TYPE,
    QUESTION_ORDER_TYPE, PROBLEM_ORDER_TYPE
)
from django.db.models import Q
from api.manager.tag_manager import get_tag_by_id
from api.models import Hospital, Doctor,City
from api.models.toprank import TopRankBanner,TopRankMeddle
from api.tool.user_tool import get_user_from_context
from rpc.context import get_rpc_remote_invoker
from rpc.decorators import bind, bind_context
from rpc.tool.error_code import CODES, gen
from rpc.tool.protocol import gm_protocol
from search.utils.diary import filter_diary
from search.utils.question import filter_qustion_v1, filter_question
from search.utils.service import filter_service
from search.utils.topic import filter_topic
from statistic.tasks import add_diary_pv, add_problem_pv
# from talos.manager.topic import topic_list_manager

@bind('api/doctor/info')
def get_hospital_info(doc_ids):
    if isinstance(doc_ids,list):
        docss = Doctor.objects.filter(id__in=doc_ids)
        ret = []
        for doc in docss:
            ret.append(doc.get_rank_doctor_detail())
        return ret
    else:
        return []

@bind('api/hospital/info')
def get_hospital_info(hos_ids):
    if isinstance(hos_ids,list):
        hoses = Hospital.objects.filter(id__in=hos_ids)
        ret = []
        for hos in hoses:
            ret.append(hos.get_rank_hospital_detail())
        return ret
    else:
        return []

@bind('api/city/info')
def get_city_info(city_id):
    try:
        res = City.objects.get(id=city_id)
        return res.city_data()
    except Exception as _:
        return {'name':'','id':city_id,'tag_id':-1}


@bind('api/toprank/banner')
def get_toprank_banner_info(city_id,rank_type):
    try:
        res = TopRankBanner.objects.get(city_id=city_id,rank_type=rank_type,is_online=True)
        return {'img_src':res.img_src}
    except Exception as _:
        return {'img_src':''}


@bind('api/toprank/meddle')
def get_toprank_banner_info(city_id,rank_type):
    now = datetime.now()
    query = Q(city_id=city_id,
              rank_type=rank_type,
              is_online=True,
              start_time__lt=now,
              end_time__gt=now)
    try:
        res = TopRankMeddle.objects.filter(query)
        return [{'sort_idx':item.sort_idx,'target_id':item.target_id} for item in res]
    except Exception as _:
        return []

@bind('api/toprank/city_tag_and_rank_meddle')
def city_tag_and_rank_meddle(city_id,rank_type):
    try:
        res = City.objects.get(id=city_id)
        tag_id = res.tag_id

        now = datetime.now()
        query = Q(city_id=city_id,
                  rank_type=rank_type,
                  is_online=True,
                  start_time__lt=now,
                  end_time__gt=now)
        res = TopRankMeddle.objects.filter(query)
        meddle = [{'sort_idx': item.sort_idx, 'target_id': item.target_id} for item in res]

        return {'tag_id':tag_id,'meddle':meddle}
    except Exception as _:
        return {'tag_id':-1,'meddle':[]}
