# coding: utf-8
from datetime import datetime

from api.models.hera.search import QueryOperation, QueryOperationWord
from rpc.decorators import bind


@bind('search/query_operation/get')
def query_operation_get(word):
    """ 搜索运营位获取  """

    now_datetime = datetime.now()

    operation_ids = QueryOperationWord.objects.filter(word=word).values_list("operation_id", flat=True).distinct()

    operation_objs = QueryOperation.objects.filter(id__in=operation_ids, is_online=True, start_time__lte=now_datetime,
                                                   end_time__gte=now_datetime).order_by("-rank")[:2]

    return [item.detial() for item in operation_objs]
