# coding=utf-8
from rpc.decorators import bind
from api.models.hera import SpecialPool
from rpc.cache import diary_cache


SPECIAL_POOL_SELL_AMOUNT_KEY = 'diary_topic_detail_special_pool_{}'


@bind("api/special_pool/info")
def get_special_pool_info_list(ids):
    """
        专题池配置信息获取
    """
    result = []
    if not ids:
        return result
    pools = SpecialPool.objects.filter(id__in=ids, is_online=True)

    for pool in pools:
        info = {
            'id': pool.id,
            'name': pool.name,
            'home_feed_cover_image': pool.home_feed_cover_image,
            'detail_cover_image': pool.detail_cover_image,
            'visual_page_id': pool.visual_page_id,
            'callback_for_ai': pool.callback_for_ai,
            'is_online': pool.is_online,
            'order': pool.order,
            'a_position_image': pool.a_position_image,
            'b_position_image': pool.b_position_image,
            'c_d_position_image': pool.c_d_position_image,
            'sell_amount': diary_cache.get(SPECIAL_POOL_SELL_AMOUNT_KEY.format(pool.visual_page_id)),
        }

        result.append(info)

    return result
