#coding=utf-8
from django.core.management import BaseCommand
from openpyxl import load_workbook

from api.models import SideSkidCategory
from category.models import CategoryMap


class Command(BaseCommand):
    """
    品类聚合映射
    python manage.py category_map
    """
    def handle(self, *args, **options):
        workbook = load_workbook('./map.xlsx', read_only=False, data_only=True)
        rows = workbook['map']._current_row
        for item in workbook['map'][2:rows]:
            sidesskidcategory_name = item[0].value
            categorypolymer_id = item[2].value
            print(sidesskidcategory_name, categorypolymer_id)
            obj = SideSkidCategory.objects.get(name=sidesskidcategory_name)
            sideskidcategory_id = obj.id
            CategoryMap.objects.update_or_create(categorypolymer_id=categorypolymer_id, sideskidcategory_id=sideskidcategory_id)




