#!/usr/bin/env python
# coding=utf-8

from rpc.all import get_rpc_remote_invoker
from gm_types.plutus.rm_type import RM_STATUS


def gen_order_data(order_query):
    """
        若是分期，则到院付为0
        data 传值Order QuerySet
    """
    result = []
    order_ids = []
    for order in order_query:
        order_ids.append(order.id)
        result.append(order.data())

    installments = get_rpc_remote_invoker()['plutus/installment/installment/status'](
        order_list=order_ids,
    ).unwrap()

    installments_map = {}
    if installments:
        for installment in installments:
            if installment['status'] in [RM_STATUS.REPAY, RM_STATUS.GRANT]:
                installments_map[installment['order_id']] = installment['status']

    for order in result:
        if installments_map.get(order['no']) is not None:
            order['final_payment'] = order['hospital_payment']
            order['hospital_payment'] = 0

    return result
