# coding=utf-8
from __future__ import unicode_literals
from rpc.decorators import bind_context
from rpc.context import get_rpc_remote_invoker
from gm_types.gaia import DOCTOR_TYPE

from api.tool.user_tool import get_doctor_from_context
from doctor.tool.switch_tool import DoctorSwitch
from api.tool.image_utils import get_full_path


@bind_context('doctor/switch/change', login_required=True)
def change_doctor(ctx, doctor_id):
    """
        切换医生
        返回切换后的session
    """
    doctor = get_doctor_from_context(ctx)
    return DoctorSwitch(ctx, doctor).do_switch(doctor_id)


@bind_context('doctor/switch/list')
def change_list(ctx):
    '''
        切换账号
    '''
    doctor = get_doctor_from_context(ctx)

    ret = []
    user_ids = []
    for doctor in DoctorSwitch(ctx, doctor).get_switch_doctors():
        doctor_type = doctor.doctor_type
        if doctor.user_id:
            user_ids.append(doctor.user_id)
        ret.append({'id': doctor.id,
                    'user_id': doctor.user_id,
                    'name': doctor.name,
                    'doctor_type': doctor_type,
                    'portrait': doctor.portrait if doctor.portrait else get_full_path('img%2Fuser_portrait.png')})

    rpc_client = get_rpc_remote_invoker()
    level_info = rpc_client['gm_im/transferconsultant/batch_level'](user_ids=user_ids).unwrap()
    for i in ret:
        i['doctor_level'] = level_info.get(str(i.pop('user_id'))) or 0
    return ret
