#coding=utf-8

import os

import redis
import xlrd
from django.conf import settings
from django.core.management.base import BaseCommand

redis_client = None
try:
    redis_client = redis.StrictRedis.from_url(settings.DORIS_URL)
except Exception as e:
    print(e)


def get_path():
    parent_path = os.path.dirname(os.path.dirname(__file__))
    path = parent_path + "/files/query相似词.xlsx"
    return path


class Command(BaseCommand):
    """
    """
    def handle(self, *args, **options):
        print("start")

        workbook = xlrd.open_workbook(get_path())
        worksheet = workbook.sheet_by_name("相似词")

        for row in range(0, worksheet.nrows):
            key = worksheet.cell_value(row, 0)
            res = []
            for i in range(1, worksheet.ncols):
                value = worksheet.cell_value(row, i)
                if value:
                    res.append(value)

            redis_key = "doris:search:query_simility:" + key
            redis_client.set(redis_key, ",".join(res))

            # str(redis_client.get(key2), encoding="utf-8").split(",")

        print("done")
