# -*- coding:utf-8 -*-
import uuid
import os
from datetime import timedelta
from celery.schedules import crontab

# DATABASE_ROUTERS = ["rpc.routers.HeraRouter"]
from gm_types.gaia import USER_RIGHTS_LEVEL, MEMBERSHIP_LEVEL, AGILE_TAG_STYLE, AGILE_TAG_TYPE

BASE_DIR = os.path.dirname(os.path.dirname(__file__))
PROJECT_ROOT = os.path.abspath(os.path.dirname(__file__))

STATIC_URL = '/static/'
VERSION = uuid.uuid1()
BOSS = 22  # 所长ID
SUOZHANG_UID = 22
# CELERY_SEND_EVENTS = True
CELERY_SEND_TASK_SENT_EVENT = True

CELERY_DEFAULT_EXCHANGE = 'celery'
CELERY_DEFAULT_EXCHANGE_TYPE = 'direct'
CELERY_DEFAULT_ROUTING_KEY = 'celery'

# REDIS_URL = 'redis://redis.paas-test.env:6379/1'
REDIS_URL = 'redis://127.0.0.1:6379/1'
CELERY_QUEUES = {
    'celery': {
        'exchange': CELERY_DEFAULT_EXCHANGE,
        'routing_key': CELERY_DEFAULT_ROUTING_KEY,
    },
    'order': {
        'exchange': 'order',
        'routing_key': 'order',
    },
    # 'dbmw': {
    #     'exchange': 'dbmw',
    #     'routing_key': 'dbmw',
    # },
}
#
CELERY_ROUTES = ['gaia.celery_task_router.CeleryTaskRouter']
CELERYBEAT_SCHEDULE = {
    'sms_service': {
        'task': 'api.tasks.period_task.sms_service',
        'schedule': timedelta(seconds=1200),
        'args': ()
    },
    'remind_doctor_reservation': {
        'task': 'api.tasks.period_task.remind_doctor_reservation',
        'schedule': crontab(hour=20, minute=0),
        'args': (),
    },
    'smark_rank_check': {
        'task': 'api.tasks.smart_rank.smark_rank_check',
        'schedule': timedelta(minutes=15),
        'args': (),
    },
    'cpt_sync':{
        'task': 'trans2es.utils.tasks.get_update_serviceids',
        'schedule': crontab(hour='*/1'),
        'args': (),
    },
    # 'allocate_stat_doctor': {
    #     'task': 'statistic.tasks.allocate_stat_doctor',
    #     'schedule': timedelta(minutes=60),
    #     'args': ()
    # },
    # 'allocate_stat_doctor_conversation': {
    #     'task': 'statistic.tasks.allocate_stat_doctor_conversation',
    #     'schedule': crontab(minute=43, hour='7,15,23'),
    #     'args': ()
    # },
    # 'remind_order_expired_before_15_days': {
    #     'task': 'api.tasks.period_task.remind_order_expired_before_15_days',
    #     'schedule': crontab(hour=14, minute=0),
    #     'args': (),
    # },
    'doctor_refund_timeout': {
        'task': 'api.tasks.order_task.doctor_refund_timeout',
        'schedule': timedelta(minutes=30),
        'args': ()
    },
    'order_evaluate_remind': {
        'task': 'api.tasks.period_task.order_evaluate_remind',
        'schedule': crontab(minute=0, hour=18),
        'args': ()
    },
    'remind_doctor_refund': {
        'task': 'api.tasks.period_task.remind_doctor_refund',
        'schedule': crontab(hour=20, minute=0),
        'args': (),
    },
    # ##### 统计邮件 #####
    # 以下service rating doctor rating hospital rating 计算逻辑迁移至calc_service_avg_score
    # http://wiki.gengmei.cc/pages/viewpage.action?pageId=4143241
    # 'service_rating_refresh': {
    #    'task': 'api.tasks.period_task.calc_service_rating',
    #    'schedule': crontab(hour=3, minute=0),
    #    'args': (),
    # },
    # 'calc_doctor_rating': {
    #    'task': 'api.tasks.period_task.calc_doctor_rating',
    #    'schedule': crontab(hour=3, minute=0),
    #    'args': (),
    # },
    # 'calc_hospital_rating': {
    #    'task': 'api.tasks.period_task.calc_hospital_rating',
    #    'schedule': crontab(hour=3, minute=0),
    #    'args': (),
    # },
    'get_phone_service': {
        'task': 'api.tasks.period_task.get_phone_service',
        'schedule': timedelta(minutes=60),
        'args': (),
    },
    'get_hosiptal_service_num': {
        'task': 'api.tasks.period_task.get_hosiptal_service_num',
        'schedule': crontab(minute=0, hour='7,17'),
        'args': (),
    },
    # repurchase reminder
    'repurchase_reminder': {
        'task': 'api.tasks.period_task.repurchase_reminder',
        'schedule': crontab(minute=0, hour=17),
        'args': (),
    },
    # ##### 统计邮件 end #####
    # ##### 美购监控 #####
    'judge_services': {
        'task': 'api.tasks.service_task.judge_services',
        'schedule': crontab(minute=20, hour=0),
        'args': ()
    },
    # ##### 美购监控 end #####
    'remind_coupon_expire': {
        'task': 'api.tasks.period_task.remind_coupon_expire',
        'schedule': crontab(minute=0, hour=10),
        'args': (),
    },
    # ##### 美购监控 end #####
    'record_doctor_coupon_info': {
        'task': 'api.tasks.period_task.record_doctor_coupon_info',
        'schedule': crontab(minute='10,50', hour=10),
        'args': (),
    },
    'send_check_shopcart_tasks': {
        'task': 'api.tasks.shopcart_task.send_check_shopcart_tasks',
        'schedule': crontab(minute='05,55', hour=17),
        'args': (),
    },
    # ##### 预约提醒 USER-336 http://jira.gengmei.cc/browse/USER-336 #####
    'remind_user_reservation': {
        'task': 'api.tasks.period_task.remind_user_reservation',
        'schedule': crontab(minute=0, hour=10),
        'args': (),
    },
    # 补单结算单, 每月1号生成.最好保证先执行budan_settlement然后在执行pay_settlement
    'budan_settlement': {
        'task': 'api.tasks.budan_task.settlement_create_event',
        'schedule': crontab(day_of_month=1, hour=2, minute=0),
        'args': (),
    },
    # create doctor statement at 5 am  the 1th of every month
    'create_all_statement': {
        'task': 'pay.tasks.create_all_statement_task.create_all_statements',
        'schedule': crontab(day_of_month=1, hour=3, minute=0),
        'args': (),
    },
    'get_momo_stat_log_from_db_and_send': {
        'task': 'pay.tasks.momo_task.get_momo_stat_log_from_db_and_send',
        'schedule': timedelta(seconds=10),
        'args': (),
    },
    # create doctor statement at 5 am  the 1th of every month
    # 'create_statement': {
    #     'task': 'pay.tasks.statement_task.create_all_statements',
    #     'schedule': crontab(day_of_month=1, hour=5, minute=0),
    #     'args': (),
    # },
    # # create doctor maidan statement at 0 am  the 5th of every month
    # 'create_maidan_statement': {
    #     'task': 'maidan.tasks.statement_task.create_all_statements',
    #     'schedule': crontab(day_of_month=5, hour=0, minute=0),
    #     'args': (),
    # },
    'period_stock_alert': {
        'task': 'pay.tasks.alter_task.period_stock_alert',
        'schedule': crontab(minute=0, hour='0,8,16'),
        'args': ()
    },
    # generate tag and area for filters
    'generate_common_filters': {
        'task': 'api.tasks.period_task.generate_common_filters',
        'schedule': timedelta(minutes=15),
        'args': (),
    },
    'generate_native_oversea_cities': {
        'task': 'api.tasks.period_task.generate_native_oversea_cities',
        'schedule': timedelta(minutes=30),
        'args': (),
    },
    'generate_special_filters': {
        'task': 'api.tasks.period_task.generate_special_filters',
        'schedule': timedelta(minutes=15),
        'args': (),
    },
    'generate_service_filters': {
        'task': 'api.tasks.period_task.generate_service_filters',
        'schedule': timedelta(minutes=15),
        'args': (),
    },
    'generate_doctor_filters': {
        'task': 'api.tasks.period_task.generate_doctor_filters',
        'schedule': timedelta(minutes=15),
        'args': (),
    },
    # seckill notify
    'seckill_notify': {
        'task': 'api.tasks.period_task.seckill_notify',
        'schedule': timedelta(minutes=2),
        'args': (),
    },
    # 定时计算沉睡用户
    'create_sleep_user_to_redis': {
        'task': 'api.tasks.user_related_tasks.create_sleep_user_to_redis',
        'schedule': crontab(hour=3, minute=0),
        'args': (),
    },
    # 计算医生的收入分
    # 'calc_doctor_discount_one_day': {
    #    'task': 'api.tasks.order_task.calc_doctor_discount_one_day',
    #    'schedule': crontab(hour=3, minute=0),
    #    'args': (),
    # }, 注销， 使用spark etl来替代
    # 'get_day_smart_rank': {
    #     'task': 'api.tasks.period_task.get_day_smart_rank',
    #     'schedule': crontab(hour=3, minute=0),
    #     'args': (),
    # },注销，接口已无用

    # 轮训七牛转码状态（美购视频）
    'check_water_mark_video_is_finish_service': {
        'task': 'api.tasks.service_task.check_water_mark_video_is_finish_service',
        'schedule': timedelta(seconds=60),
        'args': (),
    },
    # 轮训七牛转码状态（医院视频）
    'check_water_mark_video_is_finish_hospital': {
        'task': 'api.tasks.hospital_task.check_water_mark_video_is_finish_hospital',
        'schedule': timedelta(seconds=60),
        'args': (),
    },
    # 名医大赏医生信息同步
    # 'set_famous_doctor_info': {
    #     'task': 'api.tasks.period_task.set_famous_doctor_info',
    #     'schedule': timedelta(hours=3),
    #     'args': (),
    # },
    # 生成百科列表Cache
    'generate_wiki_list_cache': {
        'task': 'api.tasks.period_task.cache_wiki_list',
        'schedule': timedelta(minutes=15),
        'args': (),
    },
    'get_tag_top_sale_service': {
        'task': 'api.tasks.period_task.get_tag_top_sale_service',
        'schedule': crontab(hour=3, minute=0),
        'args': (),
    },

    # QQ卡券核销
    'consume_qqcoupon': {
        'task': 'api.tasks.period_task.consume_qqcoupon',
        'schedule': crontab(hour=1, minute=0),
        'args': (),
    },
    'set_service_home_city': {
        'task': 'api.tasks.period_task.set_service_home_city',
        'schedule': crontab(hour=3, minute=0),
        'args': (),
    },
    'search_dic': {
        'task': 'search.tasks.dic.calc_search_dic',
        'schedule': timedelta(hours=1),
        'args': (),
    },
    # 生成美购默认评价
    'generate_service_comment': {
        'task': 'api.tasks.period_task.generate_default_service_comment',
        'schedule': crontab(hour=5, minute=0),
        'args': (),
    },
    # 轮询机制，订单满足要求，但是未创建日记本
    'order_creation_diary_retried': {
        'task': 'api.tasks.period_task.order_creation_diary_retried',
        'schedule': timedelta(minutes=30),  # 30分钟轮询一次，频率是不是有点儿高
        'args': (),
    },
    # 医生相关统计的task
    'doctor_real_traffic': {
        'task': 'doctor.tasks.stats.real_traffic',
        'schedule': timedelta(hours=2),
        'args': (),
    },
    # 创建医生邀请问答定时任务 时间-每天下午5点，进行计算，每个医生从昨天17：00-今天17：00之间该被邀请的回答的个数
    'invite_answer': {
        'task': 'doctor.tasks.invite_answer.push_invite_answer',
        'schedule': crontab(hour=17, minute=0),
        'args': (),
    },
    'doris_trans2es': {
        'task': 'doris.tasks.trans2es.doris_trans2es',
        'schedule': crontab(hour=2, minute=0),
    },
    # 生成医生搜出tag缓存
    'calc_doctor_tags_for_search': {
        'task': 'api.tasks.hospital_task.calc_doctor_tags_for_search',
        'schedule': crontab(hour=3, minute=0),
        'args': (),
    },
    'calc_hospital_tags_for_search': {
        'task': 'api.tasks.hospital_task.calc_hospital_tags_for_search',
        'schedule': crontab(hour=3, minute=0),
        'args': (),
    },
    'calc_service_avg_score': {
        'task': 'api.tasks.period_task.calc_all_service_doctor_hospital_score',
        'schedule': crontab(hour=3, minute=0),
        'args': (),
    },
    'add_fake_fans_service': {
        'task': 'api.tasks.period_task.add_fake_fans_service',
        'schedule': crontab(hour=3, minute=0),
        'args': (),
    },
    # 签到通知   7730修改  为了新签到， 停掉老签到提醒
    # 'push_check_in_message': {
    #     'task': 'api.tasks.push_task.push_checkin_message',
    #     'schedule': crontab(hour=11, minute=0),
    #     'args': (),
    # },
    # 计算smart_rank
    # 'calculate_smart_rank': {
    #     'task': 'api.tasks.smart_rank.update_smart_rank',
    #     'schedule': crontab(hour=7, minute=0),
    #     'args': (),
    # },
    'fix_error_smart_rank': {
        'task': 'api.tasks.smart_rank.fix_error_smart_rank',
        'schedule': timedelta(hours=1),
        'args': ()
    },
    # 提醒用户验证订单 (每天下午10点)
    "remind_user_to_validate_order": {
        'task': 'api.tasks.period_task.remind_user_to_validate_after_order_create',
        'schedule': crontab(hour=17, minute=0),
        'args': (),
    },
    # 提醒用户去写日记
    "remind_user_to_write_diary": {
        'task': 'api.tasks.period_task.remind_user_to_write_diary_after_order_validate',
        'schedule': crontab(day_of_month="*", hour="8", minute=0),
        'args': ()
    },
    # 每日统计前一天医生新私信的数量
    "async_new_conversation_everyday": {
        'task': 'api.tasks.stats_everyday_doctorconversation.async_new_conversation_everyday',
        'schedule': crontab(hour=3, minute=20),
        'args': (),
    },
    # 每月1日2:30统计上个月的pv浏览量
    "async_lsat_month_pv_total_stats": {
        'task': 'api.tasks.stats_everyday_doctorconversation.async_lsat_month_pv_total_stats',
        'schedule': crontab(day_of_month=1, hour=2, minute=30),
        'args': (),
    },
    # 每日0:30同步私信未读数
    "async_conversation_unread_num": {
        'task': 'api.tasks.stats_everyday_doctorconversation.async_conversation_unread_num',
        'schedule': crontab(hour=0, minute=30),
        'args': (),
    },
    # --- *** ---
    # 每天给快到期的美购的医生发消息提醒
    "service_expiry_remind": {
        'task': 'api.tasks.doctor_message_task.service_expiry_remind',
        'schedule': crontab(hour=1, minute=0),
        'args': (),
    },
    # 每月28号11点给补单未补的消息通知，改变时间需改变方法中时间的判断
    "budan_message": {
        'task': 'api.tasks.doctor_message_task.budan_message',
        'schedule': crontab(day_of_month=28, hour=11, minute=0),
        'args': (),
    },
    # 计算搜索词推荐相关
    "cal_search_words": {
        'task': 'doris.tasks.cal_words.cal_search_words',
        'schedule': crontab(hour=3, minute=0),
        'args': (),
    },
    # 为价格对比导出全部sku信息
    "export_sku_for_price_competition": {
        'task': 'hera.tasks.service.export_sku_for_price_competition',
        'schedule': crontab(day_of_week=2, hour=8, minute=0),
        'args': (),
    },
    # 检查当月验证订单的医生是否具有有效商户
    "check_order_merchant": {
        'task': 'hera.tasks.order.check_order_merchant',
        'schedule': crontab(day_of_month="*", hour="16", minute=37),
        'args': (),
    },

    # 医生经营数据同步到整形表
    "doctor_business_data_async": {
        'task': 'api.tasks.businessdata.async_merchantstatdaily_pv_data',
        'schedule': crontab(hour=7, minute=0),
        'args': (),
    },

    # 医生经营数据当天
    "doctor_business_data_every_day": {
        'task': 'api.tasks.businessdata.async_doctor_everyday_business_data',
        'schedule': crontab(hour=8, minute=0),
        'args': (),
    },

    # 医生经营数据三个月和六个月
    "doctor_business_data_every_three_six_months": {
        'task': 'api.tasks.businessdata.async_doctor_month_business_data',
        'schedule': crontab(day_of_month=1, hour=8, minute=0),
        'args': (),
    },

    # 每天更新医生美购TAG标签分布数量
    "calc_doctor_and_hospital_service_tags_distribution": {
        'task': "api.tasks.period_task.calc_doctor_and_hospital_service_tags_distribution",
        'schedule': crontab(hour=3, minute=30),
        'args': (),
    },

    #  热门大学数据
    "recommend_colleges": {
        "task": "api.tasks.period_task.cache_recommends_college_data",
        "schedule": timedelta(hours=2),
        "args": (),
    },

    "cache_latest_n_special_skus": {
        "task": "api.tasks.period_task.cache_latest_n_special_skus",
        "schedule": timedelta(seconds=50),
        "args": (),
    },

    # "cal_disscuss_polymer_extra": {
    #     "task": "api.tasks.polymer.cal_disscuss_polymer_extra",
    #     "schedule": crontab(hour=2, minute=0),
    #     "args": (),
    # },
    # 检查失效的拼团并设置状态和退款
    "system_op_groupbuy_fail_order_refund": {
        "task": "pay.tasks.groupbuy_task.system_op_groupbuy_fail_order_refund",
        "schedule": timedelta(minutes=1),
        "args": (),
    },
    # 定期检查拼团失效后支付的订单，进行退款
    "system_op_after_groupbuy_fail_order_refund": {
        "task": "pay.tasks.groupbuy_task.system_op_after_groupbuy_fail_order_refund",
        "schedule": timedelta(minutes=5),
        "args": (),
    },
    # 处理退款失败的订单
    # "do_refund_fail_orders":{
    #     "task": "pay.tasks.refund_task.do_refund_fail_orders",
    #     "schedule": timedelta(minutes=10),
    #     "args": (),
    # },
    #周期性任务测试
    # "test_celery_beat": {
    #     "task": "api.manager.groupbuy_manager.test_celery_beat",
    #     "schedule": timedelta(seconds=5),
    #     "args": (),
    # },
    #定时检测团购状态
    "hour4_or_hour24_notify": {
        "task": "api.manager.groupbuy_manager.hour4_or_hour24_notify",
        "schedule":timedelta(minutes=1),
        "args": (),
    },
    #马甲补位
    "cover_groupbuy_with_users": {
        "task": "api.manager.groupbuy_manager.cover_groupbuy_with_users",
        "schedule": timedelta(minutes=1),
        "args": (),
    },
    #拼团成功推送
    "success_groupbuy_notify": {
        "task": "api.manager.groupbuy_manager.success_groupbuy_notify",
        "schedule": timedelta(minutes=1),
        "args": (),
    },
    # 更新商家设备池，更新模特用户, 每个月两次
    "record_model_user": {
        "task": "api.tasks.model_user_task.record_model_user",
        "schedule": crontab(day_of_month='1, 15', hour=2, minute=0),
        "args": (),
    },
    # 新氧与更美sku比价定时任务
    'compare_sku_price': {
        'task': 'api.tasks.compare_sku_price.compare_sku_price',
        'schedule': crontab(hour=9, minute=35),
        'args': (),
    },
    'has_no_click_push_notice': {
        'task': 'facialactivity.tasks.has_no_click_push_notice',
        'schedule': timedelta(minutes=30),  # 30分钟轮询一次
        'args': (),
    },
    'add_fake_vest_nums': {
        'task': 'facialactivity.tasks.add_fake_vest_nums',
        'schedule': timedelta(minutes=10),  # 30分钟轮询一次
        'args': (),
    },
    'add_new_keyword': {
        'task': 'api.tasks.set_data_redis.sync_face_similar_data_to_redis',
        'schedule': crontab(hour=5, minute=30),
        'args': (),
    },
    # 'compare_sku_price_for_third_platform': {
    #     'task': 'api.tasks.compare_sku_price.compare_sku_price_for_third_platform',
    #     'schedule': crontab(hour=9, minute=55),
    #     'args': (),
    # },
    'init_bdtransfer_budan': {
        'task': 'api.tasks.init_bdtransfer_month_data.init_bdtransfer_budan',
        'schedule': crontab(day_of_month='1', hour=2, minute=0),
        # 'schedule': crontab(day_of_week='0', hour="03", minute=0),
        'args': (),
    },
    # 为价格对比导出全部skx/
    'add_new_estype': {
        'task': 'api.tasks.set_data_redis.es_type_data_to_redis',
        'schedule': timedelta(hours=8),
        'args': (),
    },

    'add_new_tractate': {
        'task': 'api.tasks.set_data_redis.sync_tractate_data_to_redis',
        'schedule': crontab(hour=5, minute=0),
        'args': (),
    },
    'add_new_newwkiki': {
        'task': 'api.tasks.set_data_redis.sync_face_similar_data_to_redis',
        'schedule': crontab(hour=5, minute=0),
        'args': (),
    },
    # 更新 百科视频库 水印地址
    'check_water_mark_video_library_data_is_finish': {
        'task': 'wiki.tasks.video_tasks.check_water_mark_video_library_data_is_finish',
        'schedule': timedelta(minutes=3),  # 每3分钟轮询一次
        'args': (),
    },
    'update_special_sku_price': {
        'task': 'api.tasks.sync_specialitem_price.update_price_info',
        'schedule': crontab(hour=6, minute=0),
        'args': (),
    },
    # 签到抢购推送
    # 'sign_remind_push': {
    #     'task': 'api.tasks.sign_push_ontime.sign_remind_push',
    #     'schedule': crontab(hour=15, minute=55),
    #     'args': (),
    # },
    # 小程序签到抢购推送
    # 'sign_xcx_push': {
    #     'task': 'api.tasks.sign_push_ontime.sign_xcx_push',
    #     'schedule': crontab(hour=15, minute=55),
    #     'args': (),
    # },
    'sign_push_to_good_user': {
        'task': 'api.tasks.sign_push_ontime.sign_push_to_good_user',
        'schedule': crontab(hour=15, minute=30),
        'args': (),
    },

    # 断签推送
    # 'push_sign_user': {
    #     'task': 'api.tasks.sign_push_ontime.push_sign_user',  #断签的
    #     'schedule': crontab(hour=18, minute=0),
    #     'args': (),
    # },
    'sign_push_to_all_new_user': {
        'task': 'api.tasks.sign_push_ontime.sign_push_to_all_new_user',
        'schedule': crontab(hour=[10, 15], minute=30),
        'args': (),
    },
    # 断签推送
    # 'push_sign_user_2': {
    #     'task': 'api.tasks.sign_push_ontime.push_sign_user',
    #     'schedule': crontab(hour=10, minute=30),
    #     'args': (),
    # },
    'verfy_rush_task': {
        'task': 'api.tasks.sign_push_ontime.verfy_rush_task',
        'schedule': timedelta(seconds=60),
        'args': (),
    },
    # 百科视频库，轮询七牛状态码，用于webp数据转换
    'wiki_video_library_fsm_runner': {
        'task': 'wiki.tasks.video_tasks.wiki_video_library_fsm_runner',
        'schedule': timedelta(hours=3),
        'args': (),
    },
    'push2special_user': {
        'task': 'api.tasks.push2special.push2special_user',
        'schedule': crontab(hour=11, minute=0),
        'args': (),
    },

    'async_user_new_or_old_task': {
        'task': 'api.tasks.async_user_new_or_old_task.async_user_new_or_old',
        'schedule': crontab(hour=1, minute=0),
        'args': (),
    },

    # 'compare_sku_price': {
    #     'task': 'api.tasks.compare_sku_price.compare_sku_price',
    #     'schedule': crontab(hour=10, minute=0),
    #     'args': (),
    # },
    'collect_wiki_card': {
        'task': 'api.tasks.set_data_redis.get_query_wiki_card',
        'schedule': crontab(hour=6, minute=0),
        'args': (),
    },
    'merchant_level': {
        'task': 'hippo.tasks.update_merchant_level',
        'schedule': crontab(day_of_month='1', hour=0, minute=35),
        'args': (),
    },
    'merchant_level_info_detail': {
        'task': 'hippo.tasks.merchant_level_info',
        'schedule': crontab(day_of_month='2', hour=1, minute=0),
        'args': (),
    },
    'merchant_level_cashback': {
        'task': 'hippo.tasks.merchant_level_discount_cashback',
        'schedule': crontab(day_of_month='7', hour=0, minute=0),
        'args': (),
    },
    'alert_cash_back_status': {
        'task': 'api.tasks.cash_back_status.alert_cash_back_status',
        'schedule': crontab(day_of_week=1, hour=6, minute=0),
        'args': (),
    },
    'userlist_update_pay_order_per_hour': {
        'task': 'hippo.tasks.userlist_update_pay_order_per_hour',
        'schedule': crontab(minute=0, hour='*/1'),
        'args': (),
    },
    'userlist_update_validate_order_per_hour': {
        'task': 'hippo.tasks.userlist_update_validate_order_per_hour',
        'schedule': crontab(minute=0, hour='*/1'),
        'args': (),
    },
    'userlist_update_conversation_per_hour': {
        'task': 'hippo.tasks.userlist_update_conversation_per_hour',
        'schedule': crontab(minute=0, hour='*/1'),
        'args': (),
    },
    'userlist_update_browse_per_hour': {
        'task': 'hippo.tasks.userlist_update_browse_per_hour',
        'schedule': crontab(minute=0, hour='*/1'),
        'args': (),
    },
    'check_clues_followed_up_within_specified_days': {
        'task': 'api.tasks.sync_bdtransfer_status.check_clues_followed_up_within_specified_days',
        'schedule': crontab(hour=0, minute=0),
        'args': (),
    },
    #检测ip和设备的黑名单
    'check_ip_black_name': {
        'task': 'api.tasks.black_name_task.check_ip',
        'schedule': crontab(hour=1, minute=0),
        'args': ()
    },
    'check_device_black_name': {
        'task': 'api.tasks.black_name_task.check_device_id',
        'schedule': crontab(hour=1, minute=0),
        'args': ()
    },
    'check_clues_first_stage_status': {
        'task': 'api.tasks.sync_bdtransfer_status.check_clues_first_stage_status',
        'schedule': crontab(hour=1, minute=5),
        'args': (),
    },
    'check_second_and_third_stage': {
        'task': 'api.tasks.sync_bdtransfer_status.check_second_and_third_stage',
        'schedule': crontab(hour=1, minute=10),
        'args': (),
    },
    'free_recruitment_activity_started_subscriber_push': {
        'task': 'api.tasks.free_recruitment.activity_started_subscriber_push',
        'schedule': crontab(hour=10, minute=0),
        'args': (),
    },
    'free_recruitment_activity_ended_push': {
        'task': 'api.tasks.free_recruitment.activity_ended_push',
        'schedule': crontab(hour=12, minute=0),
        'args': (),
    },
     #'card_generate_stat': {
    #    'task': 'api.tasks.export_excel_task.card_generate_stat',
    #    'schedule': crontab(minute=0, hour="*/1"),
    #    'args': (),
    #},
    # 'group_follower_push': {
    #     'task': 'group.tasks.tasks.group_follower_push',
    #     'schedule': crontab(hour='9,15,21', minute=0),
    #     'args': (),
    # },
    'sort_group_topic': {  # 小组下话题排序
        'task': 'group.tasks.tasks.sort_group_topic',
        'schedule': timedelta(minutes=30),  # 每30分钟轮询一次
        'args': (),
    },

    'deal_gray_devices': {
        'task': 'mark.tasks.push.deal_gray_devices',
        'schedule': crontab(hour=16, minute=0),
        'args': (),
    },
    'deal_low_version_devices': {
        'task': 'mark.tasks.push.deal_low_version_devices',
        'schedule': crontab(hour=20, minute=0),
        'args': (),
    },
    'mark_push': {
        'task': 'mark tasks.push.mark_push',
        'schedule': crontab(hour=21, minute=0),
        'args': (),
    },
    'mark_again_push': {
        'task': 'mark.tasks.push.mark_again_push',
        'schedule': crontab(hour=21, minute=0),
        'args': (),
    },
    'check_cpt_white_list_status': {
        'task': 'api.tasks.voice_alert_task.check_cpt_white_list_status',
        'schedule': crontab(hour=0, minute=0),
        'args': (),
    },
    #定时下线无效美购
    'service_auto_down': {
        'task': 'api.tasks.service_task.service_auto_down',
        'schedule': timedelta(minutes=10),
        'args': (),
    },
    'topic_group_content_info': {
        'task': 'group.tasks.tasks.topic_group_content_info',
        'schedule': timedelta(hours=2),
        'args': (),
    },
    'auto_over_visit_task': {
        'task': 'api.tasks.service_task.auto_over_visit_task',
        'schedule': timedelta(minutes=10),
        'args': (),
    },
    'auto_push_bwc_order_not_verify':{
        'task': 'api.tasks.order_task.auto_push_bwc_order_not_verify',
        'schedule':crontab(hour=12, minute=0),
        'args':()
    },
    'same_city_group': {
        'task': 'api.tasks.personal_slide.same_city_group',
        'schedule': timedelta(hours=2),
        'args': (),
    },
    'same_city_toprank_doctor': {
        'task': 'api.tasks.personal_slide.same_city_toprank_doctor',
        'schedule': timedelta(hours=2),
        'args': (),
    },
    'same_city_toprank_hospital': {
        'task': 'api.tasks.personal_slide.same_city_toprank_hospital',
        'schedule': timedelta(hours=2),
        'args': (),
    },
    'same_city_clinical_doctor': {
        'task': 'api.tasks.personal_slide.same_city_clinical_doctor',
        'schedule': timedelta(hours=2),
        'args': (),
    },
    'same_city_kuaishang': {
        'task': 'api.tasks.personal_slide.same_city_kuaishang',
        'schedule': timedelta(hours=2),
        'args': (),
    },
    'same_city_new_user_skill': {
        'task': 'api.tasks.personal_slide.same_city_new_user_skill',
        'schedule': timedelta(hours=2),
        'args': (),
    },
    'diary_is_cpc_write_toes': {
        'task': 'api.tasks.diary_cpc_to_es.diary_is_cpc_write_toes',
        'schedule': timedelta(minutes=10),
        'args': (),
    },
    # 直播业务马甲机器人策略， 每天同步全量马甲用户到缓存池
    'sync_puppet_user_to_cache': {
        'task': 'api.tasks.sync_puppet_user_task.sync_puppet_user_to_cache',
        'schedule': crontab(hour=2, minute=0),
        'args': (),
    },
    # 每天标准化数据统计
    'export_upgrade_service_excel':{
        'task': 'api.tasks.export_upgrade_service_excel_task.export_upgrade_service_excel',
        'schedule': crontab(hour=[9, 19], minute=0),
        'args': (),
    },
    # # 每天未标准化数据统计
    # 'export_unupgrade_service_excel':{
    #     'task': 'api.tasks.export_unupgrade_service_excel_task.export_unupgrade_service_excel',
    #     'schedule': crontab(hour=[9, 19], minute=0),
    #     'args': (),
    # }
}

# ====================================================================================================
# ==========================================邮件服务===================================================
# ====================================================================================================
EMAIL_HOST = 'smtp.exmail.qq.com'
EMAIL_PORT = 25
HERA_EMAIL_USER = 'doctor@wanmeizhensuo.com'
HERA_EMAIL_PSWD = 'gengmei098'

# ====================================================================================================
# ==========================================PUSH 设置=================================================
# ====================================================================================================
PUSH_ANDROID_DELAY = 0  # seconds
PUSH_ALLOW_BLOCK = 60 * 60 * 24  # one day, the push that has been blocked one day will be deprecated
TOPIC_VOTE_AMPLIFY_THRESHOLD = 20
PUSH_NOTIFICATION_AFTER_FOLLOW_USER = False
PUSH_URL_PROTOCOL = dict(
    APP_HOME='gengmei://home?page=home',
    ZONE_HOME='gengmei://home?page=zone_home',
    PRI_MSG_LIST='gengmei://message_list',
    NEW_TOPIC_HOVER='gengmei://create_topic',
    COMMENT_LIST='gengmei://comment_list',

    ORDER_DETAIL='gengmei://order_detail?order_id={id}',
    DIARY_DETAIL='gengmei://diary?diary_id={id}',
    TOPCI_DETAIL='gengmei://topic?topic_id={id}',
    PROMOTION_DETAIL='gengmei://service?service_id={id}',
    PROMOTION_SPECIAL='gengmei://welfare_special?service_id={id}',

    WEB_URL='gengmei://common_webview?url={url}',
    ZONE_SINGLE='gengmei://zone?zone_id={id}',
    SPECIAL='gengmei://welfare_special?service_id={id}',
    TAG='gengmei://zone_detail?tag_id={id}&name={name}',
    SERVICE_LIST='gengmei://service_list?service_channel={channel_id}&section_id={section_id}&title={title}',
    SERVICE_LIST_WITH_TAG='gengmei://service_list?service_channel={channel_id}&tag_id={tag_id}&title={title}',

    DOCTOR_COMMENT_LIST='gmdoctor://home?page=msg&tab=comment',
    DOCTOR_PRI_MSG_LIST='gmdoctor://home?page=msg&tab=chat',
    DOCTOR_QA_INVITE_ANSWER='gmdoctor://qa_invite_answer',
)

# ====================================================================================================
# ==========================================时间 设置==================================================
# ====================================================================================================
SESSION_COOKIE_AGE = 60 * 60 * 24 * 300  # 300天才过期，认为用户只要登录就不会退出
ORDER_TIMEOUT = 1800
REMIND_TIME_BEFORE_ORDER_EXPIRED = 600  # 10 mins before order timeout
SETTLEMENT_SOFT_TIMEOUT = 7200  # 7.22.1 交易流程优化，下单和支付的交互合并，倒计时统一
SETTLEMENT_HARD_TIMEOUT = 7200
SETTLEMENT_PAY_REMIND_COUNTDOWN = 600

MAIDAN_SOFT_TIMEOUT = SETTLEMENT_SOFT_TIMEOUT
MAIDAN_HARD_TIMEOUT = SETTLEMENT_HARD_TIMEOUT

INSTALLMENT_HARD_TIMEOUT = 60 * 60 * 24
REMIND_TIME_BEFORE_SETTLEMENT_EXPIRED = 600  # 10 mins before order timeout
ORDER_EVALUATE_REMIND_TIME = 7  # 7 days after order validate
COUPON_WILL_EXPIRE_REMIND_DAYS = [1, 7]

NOTIFICATION_START_HOUR = 10  # 上午10点--晚上8点允许发通知
NOTIFICATION_STOP_HOUR = 20

PAY_GATEWAY_TIMEOUT = 60 * 10  # 支付网关10分钟还没返回,或返回不是已知状态
# ====================================================================================================
# ==========================================数字 设置==================================================
# ====================================================================================================
HOT_TOPIC_VOTE_THRESHOLD = 10
HOT_TOPIC_VOTE_THRESHOLD_IN_ZONE = 10

HODGEPODGE_TOP = 105

DIARY_VIEW = {
    "min": 5,
    "max": 15
}
TOPIC_VIEW = {
    "min": 1,
    "max": 3
}

POINTS_PER_YUAN = 100
MAX_LOGIN_ATTEMPTES = 20
COUNT_LIMIT = 100
OFFSET_LIMIT = 3000
SMS_DAILY_LIMIT = 20
UCPASS_DAILY_LIMIT = 5

HOT_DISCUSSION_TAG_DIARY_SHRESHOLD = 1000
HOT_DISCUSSION_TAG_CONSULT_SHRESHOLD = 30
HOT_DISCUSSION_TAG_DISCUSS_SHRESHOLD = 100

GAME_WISHTREE_MAX_DISCOUNT = 59
GAME_WISHTREE_COUPON_VALUE = 9
GAME_WISHTREE_CHANNEL = 7
GAME_GODDESS_MAX_DISCOUNT = 0.05
DOCTOR_HANDLE_TIME = 48  # 医生处理退款订单时间限制为 48 小时
DOCTOR_REFUND_TIMEOUT_MINUTES = DOCTOR_HANDLE_TIME * 60 + 15  # 48小时超时, 预留15分钟处理时间
ELITE_LIKE_NUM = 5

BAIDU_BUSINESS_CHANNEL = 14

# HOT CITIES
HOT_CITIES = [
    {'id': 'beijing', 'name': u'北京'},
    {'id': 'shanghai', 'name': u'上海'},
    {'id': 'guangzhou', 'name': u'广州'},
    {'id': 'shenzhen', 'name': u'深圳'},
    {'id': 'chengdu', 'name': u'成都'},
    {'id': 'chongqing', 'name': u'重庆'},
    {'id': 'wuhan', 'name': u'武汉'},
    {'id': 'changsha', 'name': u'长沙'},
    {'id': 'xian', 'name': u'西安'},
    {'id': 'zhengzhou', 'name': '郑州'},
    {'id': 'hangzhou', 'name': u'杭州'},
    {'id': 'nanjing', 'name': u'南京'},
]

NATIVE_HOT_CITIES = HOT_CITIES + [
    {'id': 'tianjin', 'name': '天津'},
    {'id': 'shenyang', 'name': '沈阳'},
    {'id': 'fuzhou', 'name': '福州'},
    {'id': 'nanchang', 'name': '南昌'},
    {'id': 'nanning', 'name': '南宁'},
    {'id': 'shijiazhuang', 'name': '石家庄'},
    {'id': 'suzhou', 'name': '苏州'},
    {'id': 'hefei', 'name': '合肥'},
    {'id': 'qingdao', 'name': '青岛'},
    {'id': 'kunming', 'name': '昆明'},
    {'id': 'guiyang', 'name': '贵阳'},
    {'id': 'lanzhou', 'name': '兰州'}
]

CHINA_EXCLUDE_PROVINCE_IDS = ['xianggang', 'aomen', 'taiwan']

ORIGIN_FOREIGN_HOT_CITIES = [
    {'id': 'shouer', 'name': '首尔'},
    {'id': 'dongjing', 'name': '东京'},
    {'id': 'mangu', 'name': '曼谷'},
    {'id': 'jizhoushi', 'name': '济州岛'},
]

FOREIGN_HOT_CITIES = ORIGIN_FOREIGN_HOT_CITIES + [
    {'id': 'xianggangdao', 'name': '香港'},
    {'id': 'aomen', 'name': '澳门'},
]
COUNTRY_CHINA_ID = 'china'
CHINA_TAG_ID = 259

GENGMEI_SECRETARY_USERID = 20889515  # 更美小秘书：金金

# ALERT CONFIG
STOCK_ALERT_THRESHOLD = 10

INVITE_COUPON_LIMIT = 3
INVITED_COUPON_LIMIT = 1
# ====================================================================================================
# ==========================================链接 设置==================================================
# ====================================================================================================
DEFAULT_USER_PROFILE_COVER = 'https://pic.igengmei.com/2015/09/09/7bb088bdc4-w'

QINIU_HERAS_CND_HOST = u'https://heras.igengmei.com/'
QINIU_CDN_HOST = u'https://pic.igengmei.com/'
QINIU_TEMP_CDN_HOST = u'http://pic-tmp.igengmei.com/'
PROTOCOL_MY_RESERVATION = 'gengmei://my_reservation'
DIARY_COVER_DEFAULT = 'https://heras.igengmei.com/2015/10/16/61b745cb36'
DEFAULT_PORTRAIT = 'https://pic.igengmei.com/img%2Fuser_portrait.png-thumb'
HOT_TAG_ICON = 'https://pic.igengmei.com/2015/11/19/952a3c052e-thumb'
BACKEND_API_HOST = 'https://backend.igengmei.com'
WEB_API_HOST = 'http://m.igengmei.com/'
APPLE_PROXIES = {
    'https': 'http://10.174.247.217:8888',
}

DEFAULT_ZONE_ICON = ''

# ====================================================================================================
# ==========================================文案 设置==================================================
# ====================================================================================================
RESERVATION_CONFIRM_TITLE = u'预约已确认'
RESERVATION_CONFIRM_CONTENT = u'你申请的{}，{}医生的预约已经确认，请按时到院【更美】'
RESERVATION_CANCEL_TITLE = u'预约已取消'
RESERVATION_CANCEL_CONTENT = u'你申请的{}，{}医生的预约因故取消，请选择其他时间预约【更美】'
RESERVATION_USER_CANCEL_CONTENT = u'您好，{}用户申请的{}的{}预约被用户取消，该时间段可安排其他预约'
RESERVATION_USER_CANCEL_TITLE = u'用户取消了预约'
RESERVATION_USER_CANCEL_PUSH_CONTENT = u'{}的预约被用户取消'
RESERVATION_USER_CREATE = u'{}用户申请预约，时间:{}，请您处理'
RESERVATION_USER_CREATE_TITLE = u'新预约'
REMINDER_DOCTOR_RESERVATION_CONTENT = u'{}医生您好，今天您有{}个未处理的预约请求，请登录网站处理 http://doctor.gmei.com【更美】'
REMIND_DOCTOR_REFUND_CONTENT = u'您好，今天有{}单待处理的用户退款申请，请登录最新的更美医生版或在医生版网页处理，用户申请后超过48小时不处理会视为您已经同意退'
SECKILL_NOTIFY = u'{} 还有3分钟就开始啦，还不马上抢！{} 退订回复TD'

WELCOME_CONTENT = u'''所长大人等你很久了！有什么问题需要解决吗？等不及回复时查看一下对话右上角的“客服中心”也许能帮到你哦'''

# ====================================================================================================
# ==========================================ES 设置==================================================
# ====================================================================================================
ES_SCRIPT_LANG = 'groovy'
ES_SEARCH_TIMEOUT = '10s'
ES_WRITE_TIMEOUT = '1000ms'
ES_V2_HOSTS = [
    {'host': 'http://es.paas-test.env', 'port': 9200},
]

# ### OTHERS ###
GENGMEI_CUSTOMER_SERVICES_PORTRAIT = 'https://heras.igengmei.com/2015/11/04/5bc2efa54a'

# 统计邮件组
STATIS_MAILS = {
    'liuliang': u'liulantongji@wanmeizhensuo.com',
    'yonghu': u'yonghutongji@wanmeizhensuo.com',
    'shequ': u'shequtongji@wanmeizhensuo.com',
    'sixin': u'sixintongji@wanmeizhensuo.com',
    'yiliao': u'yiliaotongji@wanmeizhensuo.com',
    'qudao': u'qudaotongji@wanmeizhensuo.com',
    'yonghuyunying': u'yonghu@wanmeizhensuo.com',
    'chanpin': u'chanpin@wanmeizhensuo.com',
    'jiaoyi': u'jiaoyi@wanmeizhensuo.com',
    'shequzutongji': u'shequzutongji@wanmeizhensuo.com',
    'jiaoyizutongji': u'jiaoyizutongji@wanmeizhensuo.com',
    'qudaozutongji': u'qudaozutongji@wanmeizhensuo.com',
    'qudaotongji2': u'qudaotongji2@wanmeizhensuo.com',
    'dingdantongji': u'dingdantongji@wanmeizhensuo.com',
    'yuyuetongji': u'yuyuetongji@wanmeizhensuo.com',
}

# 统计邮件发送帐号
STATIS_EMAIL_USER = ''
STATIS_EMAIL_PSWD = ''
PAY_GATEWAY_TIMEOUT
TAG_BLACK_LIST = []

# NEW_FEED_ID
NEW_FEED_ID = 'feed_id_generator_key'
FEED_ID_PREFIX = 'feed'
FEED_INFO_PREFIX = 'feed_info'

# 400服务请求
CUSTOM_SERVICE_PHONE_API_ENDPOINT = ''
CUSTOM_SERVICE_PHONE_REPORT_API_ENDPOINT = ''
CUSTOM_SERVICE_PHONE_AUDIO_API_ENDPOINT = ''
CUSTOM_SERVICE_PHONE_API_ID = ''
CUSTOM_SERVICE_PHONE_API_PASS = ''

# 评论图片和字数限制
CASHBACK_TOPIC_IMAGE_LIMIT = 2
CASHBACK_TOPIC_CONTENT_WORDS_LIMIT = 20

# ====================================================================================================
# ==========================================开关 需求==================================================
# ====================================================================================================
SWITCH_PURCHASE_PHONE_RESTRICT = True  # 通过手机号限制用户下单购买开关

# ====================================================================================================
# ==========================================临时 需求==================================================
# ====================================================================================================
# # 百度市场活动美券发放03/12 之后删掉
# BAIDU_COUPON_START_DATE = '2016-03-07'
# BAIDU_COUPON_STOP_DATE = '2016-03-12'
# BAIDU_COUPON_IDS = (1334, 1335, 1336, 1337, 1338)

# 美购日记本权重 非美购日记本权重
SERVICE_DIARY_WEIGHT = 100
NOT_SERVICE_DIARY_WEIGHT = 1

# USER-985 暂时将美购的特殊标签放到base中 后期如果需要做配置请删除total_features和feature_base_url两个变量
TOTAL_FEATURES = [
    ('refund_anytime', u'极速退款', 'refund', u'LV2以上等级可享30分钟内极速退款'),
    ('compensation_in_advance', u'先行赔付', 'compensation', u'符合赔付条件时，更美先行赔付手术费用'),
    ('share_get_cashback', u'写日记返现', 'returnmoney', u'订单验证后完成规定篇数的日记'),
    ('is_stage', u'分期服务', 'installment', u'支持花呗分期，先变美，后还款'),
    ('is_floor_price', u'底价', 'floorprice', u''),
    ('user_safe', u'用户保障', 'protection', u'更美安全保障计划，用诚信为求美者保驾护航'),
]
FEATURE_BASE_URL = 'http://backend.igengmei.com/hybrid/csc/'

FEATURES_SORT = ['is_stage', 'insurance', 'refund_anytime', 'compensation_in_advance', 'share_get_cashback',
                 'user_safe']

# rating limit
DIARY_RATING_LIMIT = 2

# 支付宝导出信息
HERA_PAY_EMAIL = 'zhengxuan@wanmeizhensuo.com'
HERA_EMAIL_NAME = u'北京完美创意科技有限公司'

# SENTRY FOR CELERY
SENTRY_CELERY_ENDPOINT = ''

# 超过该日记本评论次数，不显示
SHOW_COMMENT_NUM = 2

# 每天免费定制最大提交次数
MAX_CUSTOM_DAY_TIME = 5

# 大促对应的默认渠道
CAMPAIGN_CHANNEL_ID = 1

# add operategroup title  add by lipeng 2016-06-25 for hera-366
OPERATE_TEAM_TIYLE = 'kefu'

QQ_MAP_KEYS = [
    'QVMBZ-KZFRJ-VQ5F6-FMJIJ-SCJN6-WNFFS',
    '2RJBZ-EWTW3-ANB3A-3O6KS-SDYRK-EQFFO',
    '2LZBZ-K353F-ZQKJG-JGT7Z-PQYD2-YVBLE',
    'D7FBZ-SRGKG-AU3QI-IGMXR-63EU3-3PBOA',
    'H52BZ-JH2WX-EAB4T-TXW23-SNBLQ-GNFNQ',
    'RL2BZ-CASW3-MJ53C-3JCUR-IEGRO-TABLU',
    'NJIBZ-L2H3U-ZWLV6-4W3PK-H7DFF-OSFUM',
    'ZOBBZ-FP2WX-CA74G-TZC24-MPSL7-22BD4',
    'TENBZ-AZ53P-JRTDP-LUIQ2-KNVE6-XNF4X',
    'L7GBZ-JKMWP-HKJDV-LQPEC-QQ2M7-D6BAT',
    'PFPBZ-63ZRR-AB2W7-WHADL-LSDEH-CNFRN',
    '2EEBZ-6RYWD-EF546-H7Z5U-HKFLT-JWB2L',
    'KXHBZ-3HZ3O-OSIWQ-SVMHT-DMLBE-J6FJD',
    'CUNBZ-QAL3X-BPX4M-7BL77-YG5TZ-SCBPI',
    'QM5BZ-Z2RRX-ZZR4M-ZGBYO-X5BH5-X2BK2',
]

# gm_crypto settings
# base 里面这两个字段的默认值仅用于非生产环境使用，使代码更新后不出错
# 生产环境一定要在setting_local.py 里重新设置。切记！切记！
AES_KEY = 'keycasefornonprd'  # 16个字节的密钥
AES_IV = 'iv_casefornonprd'  # 16个字节的初始向量

# ###################### ########## 分期数据 ########### #######################
PARTNER_XY = 1  # 小赢ID

# ###################### ########## 分期数据 ########### #######################

# 音频文件上传失败重试最大次数
AUDIO_UPLOAD_MAX_RETRY_TIMES = 5

# M HOST URL
M_HOST = 'http://m.igengmei.com'

INSTALLMENT_STATUS = {
    '10': u'分期审核中',
    '50': u'已分期',
    '60': u'分期审核拒绝',
    '70': u'待补件'
}

# 短信
ALIDAYU_HOST = u''
ALIDAYU_SECRET = u''
ALIDAYU_APPKEY = u''
ALIDAYU_SIGNNAME = u''
DEFAULT_SMS_PLATFORM = u''
MD_HOST = u''
MD_SN = u''
MD_PWD = u''
YUNPIAN_API_KEY = ''
YUNPIAN_HOST = 'https://sms.yunpian.com'

# 美购分区标签图片
PROMOTION_ZONE_LABEL_PIC = 'https://heras.igengmei.com/2016/07/20/ebfdee36c0'

EMAIL_CONTENT = u'<!DOCTYPE html><html><head><meta charset="UTF-8"></head><body>亲爱的更美用户，您的邮箱验证码为：%s，' \
                u'有效期：15分钟【更美】<br><br>本邮件由系统自动发送，请勿直接回复！<br>遇到任何问题请联系我们' \
                u'<br>电话：400-811-3069转6666<br>邮箱：hi@igengmei.com<br></body></html>'

EMAIL_SEND_MAX_TIMES = 5

NO_REPLY_EMAIL = {
    'address': '',
    'host': '',
    'username': '',
    'password': '',
}

# 建立sitemap需要的信息数目
BUILD_SITEMAP_COUNT = 1000

GROUPON_SERVICE_IDS = (5269672,)

# 医生切换账号相关缓存使用，同ascle.settings.USER_COOKIE_TIME保持一致, 10days
ASCLE_USER_COOKIE_TIME = 864000

# 非标准美购默认的tag_attr
DEFAULT_TAG_ATTR_ID = 1

# 美购预付款、抽成相关配置
SERVICE_SETTING = {
    'discount': 10,  # 抽成默认百分比
    'pre_payment_price': 20,  # 预付款百分比
    'seckill_default_discount': 10,
}
# 纷享购的配置
SERVICE_FENGXIANGGOU_SETTING = {
    'discount': 60,  # 抽成默认百分比
    'pre_payment_price': 3,  # 预付款百分比
    'seckill_default_discount': 10,
}

EXCEPT_BLACK_LIST = [
]

# 更美客服对应的唯一一个person_id
KEFU_PERSION_ID = ''
# 更美呼叫中心咨询师对应的唯一一个person_id
CALL_CENTER_CONSULTANT_PERSON_ID = ''

# 2016双11特殊专场
# 1.用户返美分金额：返美分的金额=用户实际付款的10%
# 返美分用户条件：完成付款。
# 通知落地页：美分明细页，title 美购名称美分返还
# 2.抽成：抽成金额设置为用户支付的预付款（除美券美分），不按照比例计算
# 3.美分：不能使用美分
# 4.写日记返现：跟随美购本身，不受此专场影响
# 5.退款：不能退款
DOUBLE_EVELEN_SPECIAL = []

# 任买分期最小金额
RENMAI_INSTALLMENT_MIN_PAY = 500

# 任买分期最大金额
RENMAI_INSTALLMENT_MAX_PAY = 60000

# 宜人贷分期最小金额
YIRENDAI_INSTALLMENT_MIN_PAY = 1000

# 宜人贷分期最大金额
YIRENDAI_INSTALLMENT_MAX_PAY = 60000

# 任买分期默认期数
RENMAI_INSTALLMENT_PERIOD = 12

# 宜人贷分期默认期数
YIRENDAI_INSTALLMENT_PERIOD = 12

# 任买分期利率
RENMAI_INSTALLMENT_RATE = 0.0098

# 宜人贷分期利率
YIRENDAI_INSTALLMENT_RATE = 0.013

# 秒杀跨天天数
SECKILL_DAY = 3

# smart_rank区间个数
GAP_NUM = 6

# smart_rank验证订单对应的权重
MAP_VALIDATE_ORDER_W = {
    1: 9,
    2: 6,
    3: 6,
    4: 3,
    5: 3,
    6: 3,
    7: 21,
    8: 14,
    9: 14,
    10: 7,
    11: 7,
    12: 7,
}

# 默认400服务商, 取值来源`gm-types:gm_types/gaia.py:PHONE400_VENDOR`
# DEFAULT_400_VENDOR = 'xtwy'
DEFAULT_400_VENDOR = 'ztth'

# 信通网赢 400 配置
UNION400_CONF = {
    'account': '4006999227',
    'user': '4006999227_dev',
    'passwd': '319224446b366c4222222266ed3dd512',
    'api_domain': 'http://xtapi.union400.com',
}

# 中通天鸿
ZTTH_CONF = {
    'account': '4006901192',
    'user': '4216030104',
    'passwd': 'b77004e934cb8a6a69e77eece4e84dc4',
    'api_domain': 'http://m.icsoc.net/',
}
# ZTTH400录音域名
ZTTH400_AUDIO_RECORD = 'http://records.icsoc.net/saas_ali/call'

# 国际手机号区号
PHONE_AREA_CODE = (
    ('+86', u'中国大陆'),
    ('+852', u'香港'),
    ('+886', u'台湾'),
    ('+82', u'韩国'),
    ('+81', u'日本'),
    ('+66', u'泰国'),
)

VIDEO_PIC_URL = u'?vframe/jpg/offset/0/rotate/auto'

VIDEO_HOST = u'http://video-static.igengmei.com/'

ZHONGAN_MESSAGE_CONTENT = u'您好，欢迎您购买更美服务包。我是您的专业客服，如有问题可以私信我或者拨打客服电话{}转{}'

# 首页日记本排序,热度相关
DIARY_HEAT_RANK = {
    'lose_rate': 0.006,  # 热度分时间衰减比率  0.006/hour/热度分
    'max_score': 50,  # 最大热度分
    'reply_num_per_device': 3,  # 每设备评论每天限制三次
    # 加分相关
    'score_create_topic': 30,
    'score_modify_diary': 2,
    'score_self_reply': 1,
    'score_other_reply': 1,
    'score_other_vote': 0.5,
    # 限制相关
    'restrict_create_topic': 2,
    'restrict_modify_diary': 1,
    'restrict_self_reply': 10,
    'restrict_other_reply': 15,
    'restrict_other_vote': 20,
}

# 日记本质量分
DIARY_CONTENT_LEVEL_SCORE = {
    'UNAUDITED': -1000,
    'ILLEGAL': -1000,
    'BAD': -1000,
    'GENERAL': -1000,
    'BETTER': -1000,  # 新增内容等级 3.5，和郑伟确认先按照 -1000给值
    'FINE': 65.0,
    'EXCELLENT': 100.0

}

# 日记本关联美购评分
DIARY_SERVICE_RATING_LEVEL = {
    'GTE_5': 100.0,  # x >= 5
    'GTE_4_8': 75.0,  # 4.8 <= x <= 4.9
    'GTE_4_5': 50.0,  # 4.5 <= x <= 4.7
    'GTE_4': 25.0,  # 4 <= x <= 4.4
    'LT_4': -1000,  # x < 4
}

# 日记本首页排序因子权重
DIARY_SCORE_WEIGHT = {
    'HEAT_SCORE_WEIGHT': 0.2,  # 热度分权重
    'AUDIT_SCORE_WEIGHT': 0.55,  # 内容质量分权重
    'CHOUCHENG_SCORE_WEIGHT': 0.25,  # 抽成分权重
}

# show doctor v icon
SHOW_V = False

QINIU_LIVE_DOMAIN = u'pili-publish.live-test.igengmei.com'
QINIU_HUB_NAME = u'igengmei-live-test'
QINIU_LIVE_TIMEOUT = 3600
QINIU_REPLAY_LIVE_DOMAIN = u'http://live-static-test.igengmei.com/'
QINIU_TEMP_CDN_HOST = u'http://pic-tmp.igengmei.com/'

SEND_MSG_TIME = 10
MSG_POLL_TIME = 4
LIVE_TIME_OUT = 15 * 60
ENTER_MSG_TIME = 2 * 60

# ITEMWIKI_LIST_CACHE_KEY
ITEMWIKI_LIST_CACHE = 'KEY_FOR_CACHE_ITEMWIKI_LIST'

# 首页日记本推荐日记本数量
RESYS_DIARY_NUM = 3
# 是否开启日记本推荐系统
OPEN_RESYS = False
# 首页日记本重复惩罚因子
PENALTY_FACTOR = 1.5

LIVE_MSG_REDIS_FLAG = False

# QQ网站应用信息 仅占坑 在settings_local.py中覆盖
QQ_CONNECT_APPID = ''
QQ_CONNECT_APPKEY = ''
QQ_CONNECT_MD5KEY = ''

DEFAULT_REDIS = {'host': '127.0.0.1', 'port': 6379, 'db': 14}

LIVE_REDIS = {'host': 'redis.test.gengmei', 'port': 6379, 'db': 14}
PUNISHMENT_REDIS = {'host': 'redis.test.gengmei', 'port': 6379, 'db': 20}

# 老用户至少注册天数
OLD_USER_REG_MIN_DAY = 3
NEW_USER_REG_MAX_DAY = 7

# for data-transfer
DATA_TRANSFER_MARS_API_HOST = None  # 'mars.test.gengmei'
DATA_TRANSFER_MARS_AUTH_KEY = None  # '123123'

# for SLAVE_DB_NAME
SLAVE_DB_NAME = 'default'
DBMW_SLAVE_DB_NAME = 'default'
MIMAS_HERA_READ_DB = 'mimas'
# 每次推送允许最大用户量 user_id
PUSH_MAX_USER_COUNT = 128

SHOW_VIDEO_COVER = True

UNSHOW_TAGS = [u'美购日记', u'所长精选', u'热门讨论']

# 医生流量分析依赖于其他数据库, 开发环境使用 hera_test.ml_doctor_stat_updates 表
DOCTOR_TRAFFIC_DB = 'hera_test'
# =========================================================================================
# =========================================crash关键字======================================
# =========================================================================================

CRASH_KEYWORDS = ['crash', u'闪退', u'软件崩溃', u'软件问题', u'app问题']
# model中检索的字段
MODEL_FIELDS = {'diary': ['title'], 'problem': ['ask', 'answer'], 'topicreply': ['content']}
# 检索时间
DAYS_BEFORE_TODAY = -1
SENDTO = ['linli@gmei.com']
SUBJECT = u'用户版－用户反馈崩溃日报'

# answer hack num
ANSWER_HACK_STRT = '-'

# FOR TALOS #
TALOS_RPC_CACHE = {'host': 'redis.test.gengmei', 'port': 6379, 'db': 14}
# END FOR TALOS #


# 新用户首页
# add  V4
INDEX_V4_USER_GREY_NUM = []

QUESTION_SCORE_WEIGHT = {
    'time_score_weight': 1,  #
    'answers_num_score_weight': 1,
    'answer_views_score_weight': 1,
    'answer_likes_score_weight': 1,
    'question_view_score_weight': 1,
    'question_answer_likes_score_weight': 1,
}

# 分享购 新/旧 礼包/渠道 ID 配置
FENGXIANGGOU_COUPONGIFT_NEW_USER_GIFT_ID = 30046
FENGXIANGGOU_COUPONGIFT_NEW_USER_CHANNEL_ID = 37

FENGXIANGGOU_COUPONGIFT_OLD_USER_GIFT_ID = 30070
FENGXIANGGOU_COUPONGIFT_OLD_USER_CHANNEL_ID = 37

APPLEPAY_REFUND_URL = 'https://traderapi.lianlianpay.com/refund.htm'
APPLEPAY_QUERY_URL = 'https://queryapi.lianlianpay.com/orderquery.htm'

# 申请ID可配置到多个专场开关
DOCTOR_APPLY_IN_SPECIALS = False

# 通知页图标
# added 7.1.5
ABOUT_ME_IMG_HEADER_V2 = 'https://heras.igengmei.com/2017/05/03/ddd3f41707'
DIARY_IMG_HEADER_V2 = 'https://heras.igengmei.com/2017/05/03/b035031a67'
ACTIVITY_IMG_HEADER_V2 = 'https://heras.igengmei.com/2017/05/03/e25dea2dbf'
SPECIAL_IMG_HEADER_V2 = 'https://heras.igengmei.com/2017/05/03/04594c3171'
LIVE_IMG_HEADER_V2 = 'https://heras.igengmei.com/2017/05/03/10aeb2eb98'
TAG_IMG_HEADER_V2 = 'https://heras.igengmei.com/2017/05/03/957031e67e'

#  星座对应图片
CONSTELLATION_IMG = {
    "Capricorn": 'https://heras.igengmei.com/2017/06/13/0a55cb1429',
    "Aquarius": 'https://heras.igengmei.com/2017/06/13/b7da438392',
    "Pisces": 'https://heras.igengmei.com/2017/06/13/cfbf822941',
    "Aries": 'https://heras.igengmei.com/2017/06/13/e2c3c6222b',
    "Taurus": 'https://heras.igengmei.com/2017/06/13/41c489453b',
    "Gemini": 'https://heras.igengmei.com/2017/06/13/3dd6e73db3',
    "Cancer": 'https://heras.igengmei.com/2017/06/13/0abcf0ebdf',
    "Leo": 'https://heras.igengmei.com/2017/06/13/9d441ba869',
    "Virgo": 'https://heras.igengmei.com/2017/06/13/6b718603be',
    "Libra": 'https://heras.igengmei.com/2017/06/13/d0a275bc92',
    "Scorpio": 'https://heras.igengmei.com/2017/06/13/c55e3affc5',
    "Sagittarius": 'https://heras.igengmei.com/2017/06/13/9e6084009d',
}

# 新标签 样式图片
AGILE_STYLE = {
    AGILE_TAG_STYLE.UNDEFINED: '',
    AGILE_TAG_STYLE.ACTIVITY: 'https://heras.igengmei.com/slide/2019/06/28/ac3aaea28a',
    AGILE_TAG_STYLE.COMMEND: 'https://heras.igengmei.com/slide/2019/06/28/f5e41ce92d',
    AGILE_TAG_STYLE.OFFICIAL: 'https://heras.igengmei.com/slide/2019/06/28/b49be1aa4f',
}

# 用户权益等级对应图片
LEVEL_IMG = {
    USER_RIGHTS_LEVEL.V1: 'https://heras.igengmei.com/2017/09/18/70ac84d112',
    USER_RIGHTS_LEVEL.V2: 'https://heras.igengmei.com/2017/09/18/fd0d61a201',
    USER_RIGHTS_LEVEL.V3: 'https://heras.igengmei.com/2017/09/18/95f1d286e4',
    USER_RIGHTS_LEVEL.V4: 'https://heras.igengmei.com/2017/09/18/3308232ea5',
    USER_RIGHTS_LEVEL.V5: 'https://heras.igengmei.com/2017/09/18/bbc0d4a0b0',
    USER_RIGHTS_LEVEL.V6: 'https://heras.igengmei.com/2017/09/18/9fe7b12845',
    USER_RIGHTS_LEVEL.V7: 'https://heras.igengmei.com/2017/09/18/445bb6e927',
}

# 7780 修改用户的等级图片  目前仅用于 我的 页面的等级展示
NEW_LEVEL_IMG = {
    USER_RIGHTS_LEVEL.V1: 'https://pic.igengmei.com/diary/2019/05/05/99310ff62a',
    USER_RIGHTS_LEVEL.V2: 'https://pic.igengmei.com/diary/2019/05/05/f4e4a57c6e',
    USER_RIGHTS_LEVEL.V3: 'https://pic.igengmei.com/diary/2019/05/05/4099779ceb',
    USER_RIGHTS_LEVEL.V4: 'https://pic.igengmei.com/diary/2019/05/05/4fea8d151f',
    USER_RIGHTS_LEVEL.V5: 'https://pic.igengmei.com/diary/2019/05/05/501a7822db',
    USER_RIGHTS_LEVEL.V6: 'https://pic.igengmei.com/diary/2019/05/05/445f335594',
    USER_RIGHTS_LEVEL.V7: 'https://pic.igengmei.com/diary/2019/05/05/207ac9382c',
}

# 达人标示
MEMBERSHIP_IMG = {
    MEMBERSHIP_LEVEL.NORMAL: '',
    MEMBERSHIP_LEVEL.STAR: 'https://heras.igengmei.com/2019/06/27/774d5be861',
}

# 动态 SQL 日志
GM_DEVELOPER_IP_WHITE_LIST = []
ENABLE_CONDITIONAL_SQL_LOG = False
# 一次下单单个SKU最大购买数量，可以为0。设置值如果小于0，将会使用默认值10。
SKU_ORDERING_LIMIT = 10

REPLIES_READ_MYSQL_FLAG = True

# 短视频权限起始等级
CAN_CREATE_VIDEO_LEVEL = USER_RIGHTS_LEVEL.V3

# 大杂烩tag ID
MULTI_TOPIC_TAG_ID = 5150
# 高佣金项目说明
SERVICE_SPECIAL_DES_ICON = 'https://heras.igengmei.com/2017/07/07/e428a357f0'

ONEPURCHASE_COUPONGIFT_GIFT_ID = 859
ONEPURCHASE_COUPONGIFT_CHANNEL_ID = 40

VIDEO_TAG_ID = 4706

# GM_SERIALIZER 配置
GM_SERIALIZER = {
    'redis': {
        'host': 'localhost', 'port': 6379, 'db': 11
    },
}

# @yunyu
MIMAS_LOGICAL_DATABASE_ID = ''

NOTIFICATION_REPLY_IMG = 'https://heras.igengmei.com/2017/07/28/c32ff57e7a'
NOTIFICATION_VOTE_IMG = 'https://heras.igengmei.com/2017/07/28/d7e0c06fb0'

# http://wiki.wanmeizhensuo.com/pages/viewpage.action?pageId=4159515
REMIND_USER_WRITE_DIARY_AFTER_ORDER_VALIDATE_DAYS = 5  # 可以为0, 这三个值用来设置timedelta
REMIND_USER_WRITE_DIARY_AFTER_ORDER_VALIDATE_HOURS = 17
REMIND_USER_WRITE_DIARY_AFTER_ORDER_VALIDATE_MINUTES = 0

# MIMAS 从库key
MIMAS_SLAVE_DB_NAME = "mimas"
TALOS_MIMAS_ROUTER = True

PUSH_FOR_SHOPCART_CHANNEL_ID = 0
PUSH_FOR_SHOPCART_GIFT_ID_AND_PERCENT = [(0, 7), (-1, 30)]  # GiftId, Percent

WECHATPUB_APPID = 'wxe10d0d9c2c48269c'
WECHATPUB_APPSECRET = '46212c8c9dc0d52a6c6a34ddf67d4e09'

# 微信小程序
WECHAT_SMALL_APPID = 'wx113018c998de9eaf'
WECHAT_SMALL_APPSECRET = '328083f0cbb131c7de3b3920eed8ddaf'

# 小程序消息推送模板
# 审核不通过模板ID
TEMPLATE_CHECK = "nSpF40IOdPAnWXR9PBdjtW7HRZiuAOwpAl_mUunLLf0"
# 投票通知模板ID
TEMPLATE_VOTE = "u4yZ7i1n64h4zoGw1IzI5FVhatxD9C91dGua7TWR8oU"

TEMPLATE_GROUPBUY_UNFINISHED="N06je_lkoiJ8XOCXjMllr-Uq_CZe4oH4O63xgywNXxc"
TEMPLATE_GROUPBUY_FINISHED="earDsUXyoTQHAjOVSP1qIEmrXBROXRQL_HHoWYErblg"

# Google AdWords api access token
DEV_TOKEN = ''
LINK_ID = ''
GOOGLE_CHANNEL_URL = 'https://www.googleadservices.com/pagead/conversion/app/1.0'

# 百度渠道推广回调key
# BAIDU_AKEY = 'MjQ0MzI4NDg='
BAIDU_AKEY = 'MjQ3Njk3MTA='
MOBILE_BAIDU_KEY = 'Mjc3NDEwNzg='
BAIDU_SHOUZHU = '48f2fa8436262869e467ea21a71fbca3'

# 点入渠道回调URL
DIANRU_ACTIVATE_URL = 'http://api.mobile.dianru.com/callback/index.do'

# 渠道激活相关设置
InMobi_TRACKING_PARTNER = "wanmeichuangyi"
InMobi_PROPERTY_ID = "63a0b85ac73e444e8778c0cdbeb7c97e"

# 推送限制
PUSH_TOTAL_LIMIT = 3  # 推送限制总条数
# 各子类限制的条数,注意：子类限制数要小于总数
PUSH_SUB_LIMIT = 1

# 特殊推送限制
SPECTAL_SECONDS_LIMIT = 7200
SPECIAL_PUSH_LIMIT = 3

# 搜索词推荐最大数量
RECOMMEND_SEARCH_WORDS_COUNT = 15

# doris默认搜索词开关
SWITCH_DORIS_DEFAULT_SEARCH_WORDS = False

SPECIAL_SHOW_COUPON_GIFT_IDS = []  # 默认不存在，记得输入的是有效的CouponGiftId

# 不需要同步的商户id
FORBID_SYNC_MERCHANTS = []

# 美分抽奖 谢谢参与 和 再抽一次 的几率！！数字！！
# 随机1~100，如果小于NOTHING_NUMBER就是 谢谢参与
# 大于NOTHING_NUMBER 小于等于 TRY_AGAIN_NUMBER 就是再来一次
POINT_MALL_LOTTERY_NOTHING_NUMBER = 35
POINT_MALL_LOTTERY_TRY_AGAIN_NUMBER = 50

# 可进行广告pv扣费的界限
PV_LIMIT = 3000

# 极光IM配置
JIM_ADMIN = 'SkyMemory'
JIM_APPKEY = '9e779399e200529a63722da7'
JIM_SECRET = '38a0a35dc8bc96b509fc61e1'

# shanxi: 陕西 shannxi: 山西
NEARBY_REGION = {
    "beijing": ("hebei", "tianjin"),
    "tianjin": ("beijing", "hebei"),
    "hebei": ("beijing", "tianjin", "shandong", "henan", "shannxi", "neimenggu"),
    "shannxi": ("hebei", "shandong", "henan", "shanxi", "neimenggu"),
    "neimenggu": ("hebei", "liaoning", "jilin", "heilongjiang", "shannxi", "shanxi", "ningxia", "gansu"),
    "liaoning": ("hebei", "jilin", "neimenggu"),
    "jilin": ("liaoning", "heilongjiang", "neimenggu"),
    "heilongjiang": ("jilin", "neimenggu"),
    "shanghai": ("jiangsu", "anhui", "zhejiang"),
    "jiangsu": ("shandong", "anhui", "zhejiang", "shanghai"),
    "zhejiang": ("shanghai", "jiangsu", "anhui", "fujian"),
    "anhui": ("jiangsu", "zhejiang", "jiangxi", "hubei", "henan"),
    "fujian": ("zhejiang", "jiangxi", "guangdong"),
    "jiangxi": ("anhui", "zhejiang", "fujian", "guangdong", "hunan", "hubei"),
    "shandong": ("hebei", "henan", "jiangsu"),
    "henan": ("hebei", "shandong", "anhui", "hubei", "shanxi", "shannxi"),
    "hubei": ("henan", "anhui", "jiangxi", "hunan", "chongqing", "shanxi"),
    "hunan": ("hubei", "jiangxi", "guangdong", "guangxi", "guizhou", "chongqing"),
    "guangdong": ("guangxi", "hunan", "jiangxi", "fujian", "hainan"),
    "guangxi": ("guangdong", "hunan", "guizhou", "yunnan"),
    "hainan": ("guangdong",),
    "chongqing": ("shanxi", "hubei", "hunan", "guizhou"),
    "sichuan": ("gansu", "shanxi", "chongqing", "guizhou", "yunnan", "xizang", "qinghai"),
    "guizhou": ("chongqing", "hunan", "guangxi", "yunnan", "sichuan"),
    "yunnan": ("sichuan", "guizhou", "guangxi", "xizang"),
    "xizang": ("qinghai", "sichuan", "yunnan", "xinjiang"),
    "shanxi": ("neimenggu", "shannxi", "henan", "hubei", "chongqing", "sichuan", "gansu", "ningxia"),
    "gansu": ("ningxia", "shanxi", "sichuan", "qinghai", "xinjiang", "neimenggu"),
    "qinghai": ("gansu", "sichuan", "xizang", "xinjiang"),
    "ningxia": ("neimenggu", "shanxi", "gansu"),
    "xinjiang": ("gansu", "qinghai", "xizang"),
    "taiwan": ("fujian",),
    "xianggang": ("guangdong",),
    "aomen": ("guangdong",)
}

POPUP_CACHE_LIMIT_DAYS = 3

DB_TIDB = 'tidb'
DB_JERRY_TIDB = 'jerry_tidb'

# PV系数
PV_RATE = 2.1

# 红包拉新，提现额度
CASHBACK_WITHDRAW_UNIT = 30.0

# 公立TAG，与民营TAG
PUBLIC_TAG_ID = 2363
PRIVATE_TAG_ID = 1584

GMTRACER_PARSER = 'utils.setup_tracer'

# 讨论聚合页与八卦聚合页具体id，用于聚合页优先展示
POLYMER_ID_IS_DISCUSS = [6717, 6962]
MOMO_STAT_LOG_TEST_FLAG = False  # 陌陌打点是否使用测试地址，正式环境为 False

LOAD_SECKILL_INFO_FROM_PRE_WRITE_CACHE = True

# 需要限制的医生id
COUPON_LIMITED_DOCTOR_IDS = []
# 平台券的最大更美承担比例。如果平台券的更美承担比例大于这个值并且美购医生在 COUPON_LIMITED_DOCTOR_IDS 里面，这个平台券就不能用
# 比如设置为99，那么当更美承担比例小于等于99的时候都可以用，比例为100的不能用
COUPON_LIMITED_MAX_GENGMEI_PERCENT = 99

MESSAGE_ASK_REFERRAL_RECORD_TAG_ID = 6418  # 产品给的免费咨询页面意向描述写入的项目标签id，原因:意向描述若无项目无法写库！

COUPON_SHARE_CHANNEL_ID = 53
COUPON_SHARE_GIFT_ID = 17894


# feature聚合页面url
H5_API_HOST = 'http://backend.igengmei.com'
FEATRUE_AGGREGATE_URL = H5_API_HOST + '/phantom/meigou/description?service_id={service_id}&checked={type}'


# 拼团未满并且在进行中时，用户头像会多返回一个加号的图片
GROUPBUY_PLUS_IMG_URL = "https://heras.igengmei.com/doctor/2018/08/08/1ddaeea0bd"

VOTE_TONGDUN_RISK_SCORE = 999

# 美柚渠道回调
MEIYOU_AUTH_KEY = '66ab67063e9fc1dff47a358b5198f882'
MEIYOU_CALLBACK_URL = 'http://e.meiyou.com/track/callback?'

DIARY_MATCH_POPUP_ID = 703

# 默认头像
HOSPITAL_DEFAULT_PORTRAIT_KEY = "img%2Fyiyuan.png"
DOCTOR_DEFAULT_PORTRAIT_KEY = "2018/09/29/1412/11d7d42453e5"

# 新版推荐美购,数据筛选项
NEW_SERVICE_RECOMMEND_FILTERS = {
    "sales_count_range": {"gte": 100},  # 售卖量 >= 100
    "related_case_count_range": {"gte": 20},  # 案例数 >= 20
}

# 新氧与更美sku比价表收件人
SEND_TO_EMAIL = ["zhangjiachen@igengmei.com", "wanghao@igengmei.com", "xiaowei@igengmei.com", "jicha@igengmei.com"]
# 新人白名单 -- user_id
NEW_USER_WHITE_LIST = (
    30605581, 30903898, 23090436, 30162614, 18455, 30729310, 30974120, 27183880, 29787553, 30163460, 29410118, 30964249)


REDIS = {
    'doctor': {'host': '127.0.0.1', 'port': 6379, 'db': 0},
    'hospital': {'host': '127.0.0.1', 'port': 6379, 'db': 1},
    'view': {'host': '127.0.0.1', 'port': 6379, 'db': 2},
    'user_cache': {'host': '127.0.0.1', 'port': 6379, 'db': 5},
    'conversation_cache': {'host': '127.0.0.1', 'port': 6379, 'db': 6},
    'tag_cache': {'host': '127.0.0.1', 'port': 6379, 'db': 12},
    'diary': {'host': '127.0.0.1', 'port': 6379, 'db': 4},
    'page_cache': {'host': '127.0.0.1', 'port': 6379, 'db': 15},
    'coupon_gift': {'host': '127.0.0.1', 'port': 6379, 'db': 10},
    'social_cache': {'host': '127.0.0.1', 'port': 6379, 'db': 11},
    'vote_cache': {'host': '127.0.0.1', 'port': 6379, 'db': 11},
    'wechat': {'host': '127.0.0.1', 'port': 6379, 'db': 11},
    'game': {'host': '127.0.0.1', 'port': 6379, 'db': 4},
    'resys_cache': {'host': '127.0.0.1', 'port': 6379, 'db': 3},
    'user_reg_lock': {'host': '127.0.0.1', 'port': 6379, 'db': 7},
    'black_name': {'host': '127.0.0.1', 'port': '6379', 'db': 4},
    'wechat_token_lock': {'host': '127.0.0.1', 'port': '6379', 'db': 4},
}

REDIS_BLACK_IP_PREFIX = "gm:al_cpc_charge_remove_ip:"
REDIS_BLACK_DEVICE_PREFIX = "gm:al_cpc_charge_remove_device:"

# 视频图片水印地址
# WATER_MARK_URL_FOR_VIDEO = 'https://heras.igengmei.com/2019/03/21/5fc4ad1908'  # 2019.03.21 更美 微整形 logo
WATER_MARK_URL_FOR_VIDEO = 'https://heras.igengmei.com/2019/06/24/8d04d53b15'  # 2019.06.24 更美 医美 logo

# 图片打图片水印地址
WATER_MARK_URL_FOR_IMAGE = 'https://heras.igengmei.com/2019/03/21/5fc4ad1908'
# 三方注册需要手机号开关
PHONE_MUST_FOR_THIRD_REG = False
# 首页icon图标个数
HOMEPAGE_ICON_CNT = 20

ALL_TAGS_RECOMMEND_NAME = (u'热销及应季项目', u'新品速递')

# 三方注册需要手机号开关
PHONE_MUST_FOR_THIRD_REG = False

DISCOUNT_PRICE_DEMOTION = False

VIDEO_CONVERT_PATH = "/tmp/video_convert/"
VIDEO_FF_ARGS = "-vcodec libwebp -lossless 0 -qscale 75 -preset none -loop 0  -vf fps=5 -an -vsync 0"

#  feed卡片缓存过期时间
FEED_CARD_TIMEOUT = 180

# 商户每日主动私信数量
MERCHANT_DAILY_MESSAGE = 60

SMARK_RANK_CHECK_DINGTALK_ACCESS_TOKEN = ""
SMARK_RANK_CHECK_DINGTALK_MOBILES = []

# 标签映射hash key
TAT_MAPPING_HASH_NAME = 'tag_mapping:489b3045a38111e9b3426c0b84d610b3'

PRINCE_TEMPLATE_MESSAGE_ID_COMPLETING = '4f6e-y38EaYfFc3JzqmZ_VB2LKy9ThEMaKtkBybSPjI'
PRINCE_TEMPLATE_MESSAGE_ID_COMPLETE = 'C34VllOL_fN8tLXHQ2Thd-jDCT_kGocpFyqmlZGXMo0'
PRINCE_UNLOCK_TIMES = 3

FREE_RECRUITMENT_TEMPLATE = {
    "VOTED": "lWKhxdQFXOptzl2TWcqG9MNSIxf47sx_7xucJIEliWE",  # test
    "ACTIVITY_STARTED": "LABYWGuALmp4g04sqVCnVXSHcaZa9wF0ikinS7hCUAk",  # test
    "ACTIVITY_ENDED": "PxLXmhl2hS_7wUQNrEKxpqDg0v1d7NXJmgnWzwaYY2c",  # test
}

PROHIBITED_CITY = "shanghai"
PROHIBITED_WORDS = {
    '水光针': '水光导入',
    '热玛吉': '提拉紧致',
    '超声刀': '提拉紧致',
    '热拉提': '提拉紧致',
    '瘦脸针': '除皱瘦脸',
    '鼻部综合': '鼻部多项',
    '眼部综合': '眼部多项',
    '鼻综合': '鼻部多项',
    '眼部套餐': '眼部多项',
    '溶脂针瘦脸': '溶脂瘦脸',
    '自体脂肪全面部填充': '自体脂肪面部填充',
    '祛眼袋': '去眼袋',
    '外切祛眼袋': '外切去眼袋',
    '内切祛眼袋': '内切去眼袋',
    '激光祛腋臭': '激光治疗腋臭',
    '玻尿酸除颈纹': '玻尿酸',
    '祛痣': '点痣',
    '祛痘祛痘印': '淡化痘印',
    '果酸焕肤': '果酸嫩肤',
    '自体脂肪丰臀': '自体脂肪形体雕塑',
    '自体脂肪隆胸': '自体脂肪形体雕塑',
    '祛疤': '去疤痕'
}


SIGN_PUSH_TEMPLATE_ID = '1fRQA-9eZ17IyItO0s7gWGDJDM6twy-1CQSQLNl7Wz4'

# 是否开启私信自动回复功能
ENABLE_MESSAGE_AUTO_REPLY = False
# 默认私信自动回复延迟
MESSAGE_AUTO_REPLY_DELAY = 0.5
AUTO_REPLY_MESSAGE = {
    "text": "您好，请问您想了解什么？"
}

BLACKLIST = []

# 美购首页新人优惠券 礼包/渠道 ID
SERVICE_HOME_NEW_USER_GIFT_ID = 50238   #714  测试新人礼包id
# 图片
NEW_USER_COUPON_ICON_IMAGE = 'https://heras.igengmei.com/special/2020/03/12/5cf1e6a263'

# 面诊tag标签
FACE_CONSULT_TAGS = [3, 5, 1, 2, 7, 4, 992, 11, 9, 929, 1024]


# 拼团短信ID
PEOPLE_MATCH = 51
GENGMEI_MATCH = 52
GIFT_REMIND = 53

#商家分级返点比例
MERCHANT_CASHBACK = {5: 0.05, 6: 0.08, 7: 0.1}

# 选秀节目 少年之名 配置项
VARIETY_SHOW_YOUNG_CONFIG = {
    "can_voted_idol_nums": 7,  # 可投票选手数量
    "virtual_ticket_nums": 4,  # 真实投票完成，虚拟加票数
}

# 注册全流程，灰度设备组
LAUNCH_GRAY_RULE = [

    # 后端
    "7A37AD6E-7A0F-4B63-B8BB-F3230A8721CB",
    "androidid_e29086c23487fda2",
    "androidid_a25a1129c0b38f7b",
    "865032031896001",                      # 谢林臻
    "869378034450718",                      # 张永
    "867960032997576",                      # 张英杰
    "869384033053800",                      # 肖伟
    "863791030182646",                      # 薛倩倩

    # 策略
    "868771031984211",  #  段英荣

    # 客户端
    "5DCE4EB9-21A8-4E9C-9F6B-645BCA7CCD75"  # 冯健

    "E794990F-0717-4E79-9D31-33B4424100A0",  # pm 陈翔宇
    "C715995C-202C-4EF8-97E4-9D2C4740092D",  # pm 邓广宇
    "FDE6F4E3-E8DB-4E93-A5D1-26295AF3E894",  # 薛鹏飞
    "B6EDE80F-1121-4081-9ED2-6A426CD8FAB4",  # pm 王昕
    "2737596E-E447-4BC3-B9D1-BF110EC6E1E2",  # pm 王昕
    "E8AF6CB8-88C8-4D66-ABFA-777B49B90B82",  # pm 王昕
    "139580A6-85B7-41CD-B7C4-92366C23B4F0",  # boss刘?
    "6640A82A-E556-41F3-BEB1-1A86C7349540",  # 赵云
    "1BA2464E-8D6A-480D-9292-6CB98E44AB31",  # 运营 马霖唏
    "865277037750070",  # boss
    '764FC20F-B97F-4F2E-868E-FC6E3042C96D',  # Brian

    'B0569106-533A-4067-B30C-1ACD48F5A8BA',  # 董雏清
    'F3F4C95F-BF76-4F82-9CC6-B5A8933A6BD9',  # 梓君
    '73C73DC3-CD60-4F78-BBB5-05E41D384691',  # 梁奉龙
    'D9C551E5-53EB-4C0A-904B-A69B94750A96',  # 赵翊伊
    'E14834F6-9113-4037-B61C-DAC00280AA0B',  # 艾娇平
    'C626EE6D-763B-4A56-9AEC-64E305613B45',  # 汪洋

    '358520080632214',                       # brian
    '865712040467593',                       # 王媛媛
    '52944327-D4C0-445C-9BEE-59FAD407F11B',  # brian
    'FDE6F4E3-E8DB-4E93-A5D1-26295AF3E894',  # 薛鹏飞

    'C24CCDCF-F1BC-42BB-89A0-37D6BE3820DC',  # 刘颖
    '6640A82A-E556-41F3-BEB1-1A86C7349540',  # 赵云
    'B6712382-69D5-4B12-9810-5F266411C4CF',  # 李星宇

    'D6E43164-8E2D-4ABE-8600-7C2A73DA36FA',  # 李舒琪
    '865750037415134',                       # 吕平
    '66D01FCD-83CF-465E-BE40-3CCE5911C5E1',  # 陈昱瑾
    '865330041635918',                       # 李帅达
    '865987045470368',                       # 汪洋
    '860758048420451',                       # 董雏清 安卓

    # 运营
    "22F86BBD-6C14-418B-B6FA-E5301E9F2806",
    "1BA2464E-8D6A-480D-9292-6CB98E44AB31",
    "36C97DF2-9F3C-4E1D-9F11-3FDDC9BE1CEF",
    "861579033675423",
    "8F6F2ACA-57C1-44F6-9C5E-01878B0907F4",
    "E4454D3B-80BD-49BE-92F8-27DED97EAD31",
    "869531042743652",
    "FF9A0C41-8630-4689-AA3A-CB027FC791C4",
    "99001217241208",
    "66F3F0D0-53EC-41B1-88A3-D0D8061F46D2",
    "861203042050821",
    "863797035981551",
    "869172030852500",
    "1C0CE7B3-504E-41E8-9B75-5977481EA4B7",
    "805A6DC0-140A-4218-B9C0-6D80EB8BB4F7",
    "3AD13AAF-C145-4196-81B8-A5BBF8AA0053",
    "869379031802661",
    "513DD677-4832-439C-A63A-77BC10EF4B0A",
    "869699046483946",
    "E75B5814-9B34-453B-A10A-D3F49C58CCA1",
    "96F7D0B4-7108-4D2A-9D4C-1BA56524CD13",
    "EFE1CAB3-B0E3-45AE-88AC-1D993420FF31",

    # 测试机
    '0840E4C8-F6E4-4504-8812-D07049E86A25',
    '867391032675022',
    '868217046696333',
    'C60434E8-1F52-468D-8F57-BEAEC1E14C1D',
    'AC803C6A-602C-447E-8527-FD6F04E219DA',
    '868214031306127',
    '7A76480B-0192-4787-AB1A-93F7B9E606FF',
    '865712040467593',
    '868663038800476',
    '869414033653380',
    '1AA96C87-CDC4-48BB-8DED-D6A06F28F1B3',
    'F44088F9-03DC-47C4-92B7-88A67C44E300',
    'A9CA85F0-9369-471D-AAC4-0158BECDE2A0',
    '864973048086873',
    'androidid_12ffcaea1d71d6dc',
    '3542BDCA-73D7-4532-BB1B-D45365DC4A86',
    'DC494488-BE03-47E9-B500-6838DD5E5EA9',
    '864370038130912',

    '866411044819292',
    '3836688D-93B3-40D5-8A69-9E91C920264D',
    '44ADDAA8-F8AE-4934-97C8-9B27C1FD6A90',
    '1ED94F4E-E2CB-4377-82AB-00D1E87064FD',
    'A2A95117-B638-4D4D-98F5-D71FBB674DAF',

    # 策略
    '868771031984211',  # 段英荣
    '68335D20-760F-41C1-9A00-8F9B4C0D62DB',  # 李小芳

]

HERA_PUSHINFO_START_ID = 1

USER_CREATE_BATCH_EMIALS = ['wanghao@igengmei.com', 'xuepengfei@igengmei.com', 'lvguowei@igengmei.com']

NEW_USER_VISUAL_PAGE_ID = 303

# ai问答，获取用户选择的回答接口缓存时间【单位: 秒】
AI_QA_SELECTED_ANSWER_CACHE_TIME = 60 * 5

# 私信消息钉钉实时监控(临时)
MESSAGE_MONITOR_SCHEDULE = 30
MESSAGE_MONITOR_DINGTALK_ACCESS_TOKEN = ""
MESSAGE_MONITOR_DINGTALK_MOBILES = []
